/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptBase;
import org.jetbrains.debugger.ScriptManagerBase;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0015\u0010\u000f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0012\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0016\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0017\u001a\u00020\f2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0007H\u0016R0\u0010\u0005\u001a\u001e\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00018\u00008\u00000\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/debugger/ScriptManagerBaseEx;", "SCRIPT", "Lorg/jetbrains/debugger/ScriptBase;", "Lorg/jetbrains/debugger/ScriptManagerBase;", "()V", "idToScript", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "getIdToScript", "()Ljava/util/concurrent/ConcurrentMap;", "clear", "", "listener", "Lorg/jetbrains/debugger/DebugEventListener;", "findScriptById", "id", "(Ljava/lang/String;)Lorg/jetbrains/debugger/ScriptBase;", "findScriptByUrl", "url", "Lcom/intellij/util/Url;", "(Lcom/intellij/util/Url;)Lorg/jetbrains/debugger/ScriptBase;", "rawUrl", "forEachScript", "scriptProcessor", "Lkotlin/Function1;", "Lorg/jetbrains/debugger/Script;", "", "rawUrlToOurUrl", "script-debugger-backend"})
public abstract class ScriptManagerBaseEx<SCRIPT extends ScriptBase>
extends ScriptManagerBase<SCRIPT> {
    @NotNull
    private final ConcurrentMap<String, SCRIPT> idToScript = ContainerUtil.newConcurrentMap();

    @NotNull
    protected final ConcurrentMap<String, SCRIPT> getIdToScript() {
        return this.idToScript;
    }

    @Override
    public final void forEachScript(@NotNull Function1<? super Script, Boolean> scriptProcessor) {
        Intrinsics.checkParameterIsNotNull(scriptProcessor, (String)"scriptProcessor");
        Iterator iterator = this.idToScript.values().iterator();
        while (iterator.hasNext()) {
            ScriptBase script;
            ScriptBase scriptBase = script = (ScriptBase)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)scriptBase, (String)"script");
            if (((Boolean)scriptProcessor.invoke((Object)scriptBase)).booleanValue()) continue;
            return;
        }
    }

    @Nullable
    public final SCRIPT findScriptById(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return (SCRIPT)((ScriptBase)this.idToScript.get(id));
    }

    public final void clear(@NotNull DebugEventListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.idToScript.clear();
        listener2.scriptsCleared();
    }

    @Nullable
    public final SCRIPT findScriptByUrl(@NotNull String rawUrl) {
        Intrinsics.checkParameterIsNotNull((Object)rawUrl, (String)"rawUrl");
        Url url = this.rawUrlToOurUrl(rawUrl);
        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"rawUrlToOurUrl(rawUrl)");
        return (SCRIPT)this.findScriptByUrl(url);
    }

    @Nullable
    public final SCRIPT findScriptByUrl(@NotNull Url url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        for (ScriptBase script : this.idToScript.values()) {
            if (!url.equalsIgnoreParameters(script.getUrl())) continue;
            return (SCRIPT)script;
        }
        return null;
    }

    @NotNull
    public Url rawUrlToOurUrl(@NotNull String rawUrl) {
        Intrinsics.checkParameterIsNotNull((Object)rawUrl, (String)"rawUrl");
        Url url = Urls.parseEncoded(rawUrl);
        if (url == null) {
            Intrinsics.throwNpe();
        }
        return url;
    }
}

