/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.connection;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import com.intellij.util.io.NettyKt;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.rpc.CommandProcessorKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0002H\u0014J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bH&J\f\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0016J(\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u00052\u0010\b\u0002\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 H\u0007R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lorg/jetbrains/debugger/connection/RemoteVmConnection;", "Lorg/jetbrains/debugger/connection/VmConnection;", "Lorg/jetbrains/debugger/Vm;", "()V", "address", "Ljava/net/InetSocketAddress;", "getAddress", "()Ljava/net/InetSocketAddress;", "setAddress", "(Ljava/net/InetSocketAddress;)V", "connectCancelHandler", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlin/Function0;", "", "port", "", "port$annotations", "getPort", "()I", "setPort", "(I)V", "connectedAddressToPresentation", "", "vm", "createBootstrap", "Lio/netty/bootstrap/Bootstrap;", "vmResult", "Lorg/jetbrains/concurrency/AsyncPromise;", "detachAndClose", "Lorg/jetbrains/concurrency/Promise;", "open", "stopCondition", "Lcom/intellij/openapi/util/Condition;", "Ljava/lang/Void;", "script-debugger-ui"})
public abstract class RemoteVmConnection
extends VmConnection<Vm> {
    private int port = -1;
    @Nullable
    private InetSocketAddress address;
    private final AtomicReference<Function0<Unit>> connectCancelHandler = new AtomicReference();

    @Deprecated(message="Use address")
    public static /* synthetic */ void port$annotations() {
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    @Nullable
    public final InetSocketAddress getAddress() {
        return this.address;
    }

    public final void setAddress(@Nullable InetSocketAddress inetSocketAddress) {
        this.address = inetSocketAddress;
    }

    @NotNull
    public abstract Bootstrap createBootstrap(@NotNull InetSocketAddress var1, @NotNull AsyncPromise<Vm> var2);

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Promise<Vm> open(@NotNull InetSocketAddress address, @Nullable Condition<Void> stopCondition) {
        void attemptNumber;
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        if (address.isUnresolved()) {
            String error = "Host " + address.getHostString() + " is unresolved";
            VmConnection.setState$default(this, ConnectionStatus.CONNECTION_FAILED, error, null, 4, null);
            return Promises.rejectedPromise((String)error);
        }
        this.address = address;
        this.port = address.getPort();
        VmConnection.setState$default(this, ConnectionStatus.WAITING_FOR_CONNECTION, "Connecting to " + address.getHostString() + ':' + address.getPort(), null, 4, null);
        AsyncPromise result2 = new AsyncPromise();
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        Function0<Unit> attempt$ = new Function0<Unit>(this, result2, address, stopCondition, (Ref.IntRef)attemptNumber){
            final /* synthetic */ RemoteVmConnection this$0;
            final /* synthetic */ AsyncPromise $result;
            final /* synthetic */ InetSocketAddress $address;
            final /* synthetic */ Condition $stopCondition;
            final /* synthetic */ Ref.IntRef $attemptNumber;

            public final void invoke() {
                block0: {
                    RemoteVmConnection.access$getConnectCancelHandler$p(this.this$0).set(new Function0<Unit>(this){
                        final /* synthetic */ open.1 this$0;

                        public final void invoke() {
                            this.this$0.$result.setError("Closed explicitly");
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                    AsyncPromise connectionPromise = new AsyncPromise();
                    connectionPromise.rejected((Consumer)new Consumer<Throwable>(this){
                        final /* synthetic */ open.1 this$0;

                        public final void consume(Throwable it) {
                            AsyncPromise asyncPromise = this.this$0.$result;
                            Throwable throwable = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                            asyncPromise.setError(throwable);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                    this.$result.done((Consumer)new Consumer<Vm>(this){
                        final /* synthetic */ open.1 this$0;

                        public final void consume(Vm it) {
                            RemoteVmConnection remoteVmConnection = this.this$0.this$0;
                            Vm vm = it;
                            if (vm == null) {
                                Intrinsics.throwNpe();
                            }
                            remoteVmConnection.setVm(vm);
                            VmConnection.setState$default(this.this$0.this$0, ConnectionStatus.CONNECTED, "Connected to " + this.this$0.this$0.connectedAddressToPresentation(this.this$0.$address, it), null, 4, null);
                            this.this$0.this$0.startProcessing();
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }).rejected((Consumer)new Consumer<Throwable>(this){
                        final /* synthetic */ open.1 this$0;

                        public final void consume(Throwable it) {
                            if (!(it instanceof ConnectException)) {
                                Logger logger = CommandProcessorKt.getLOG();
                                Throwable throwable = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                                Promises.errorIfNotMessage((Logger)logger, (Throwable)throwable);
                            }
                            VmConnection.setState$default(this.this$0.this$0, ConnectionStatus.CONNECTION_FAILED, it.getMessage(), null, 4, null);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }).processed((Consumer)new Consumer<Vm>(this){
                        final /* synthetic */ open.1 this$0;

                        public final void consume(Vm it) {
                            RemoteVmConnection.access$getConnectCancelHandler$p(this.this$0.this$0).set(null);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                    Channel channel = NettyKt.connect(this.this$0.createBootstrap(this.$address, (AsyncPromise<Vm>)this.$result), this.$address, connectionPromise, this.$stopCondition == null ? 20 : -1, (Condition<Void>)this.$stopCondition);
                    if (channel == null || (channel = channel.closeFuture()) == null) break block0;
                    channel.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(this){
                        final /* synthetic */ open.1 this$0;

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final void operationComplete(Future<? super Void> it) {
                            if (Promises.isFulfilled((Promise)((Promise)this.this$0.$result))) {
                                this.this$0.this$0.close("Process disconnected unexpectedly", ConnectionStatus.DISCONNECTED);
                                return;
                            }
                            Ref.IntRef intRef = this.this$0.$attemptNumber;
                            ++intRef.element;
                            if (intRef.element <= 100) {
                                Condition condition2 = this.this$0.$stopCondition;
                                if (!(condition2 != null ? condition2.value(null) : false)) {
                                    NettyKt.sleep(this.this$0.$result, 500);
                                    this.this$0.invoke();
                                    return;
                                }
                            }
                            this.this$0.$result.setError("Cannot establish connection - promptly closed after open");
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.this$0 = remoteVmConnection;
                this.$result = asyncPromise;
                this.$address = inetSocketAddress;
                this.$stopCondition = condition2;
                this.$attemptNumber = intRef;
                super(0);
            }
        };
        java.util.concurrent.Future future2 = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(attempt$){
            final /* synthetic */ open.1 $attempt;

            public final void run() {
                if (Thread.interrupted()) {
                    return;
                }
                this.$attempt.invoke();
            }
            {
                this.$attempt = var1_1;
            }
        });
        this.connectCancelHandler.set(new Function0<Unit>(future2, result2){
            final /* synthetic */ java.util.concurrent.Future $future;
            final /* synthetic */ AsyncPromise $result;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    this.$future.cancel(true);
                }
                finally {
                    this.$result.setError("Cancelled");
                }
            }
            {
                this.$future = future2;
                this.$result = asyncPromise;
                super(0);
            }
        });
        return (Promise)result2;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Promise open$default(RemoteVmConnection remoteVmConnection, InetSocketAddress inetSocketAddress, Condition condition2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: open");
        }
        if ((n & 2) != 0) {
            condition2 = null;
        }
        return remoteVmConnection.open(inetSocketAddress, (Condition<Void>)condition2);
    }

    @JvmOverloads
    @NotNull
    public final Promise<Vm> open(@NotNull InetSocketAddress address) {
        return RemoteVmConnection.open$default(this, address, null, 2, null);
    }

    @NotNull
    protected String connectedAddressToPresentation(@NotNull InetSocketAddress address, @NotNull Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        return "" + address.getHostName() + ':' + address.getPort();
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public Promise<?> detachAndClose() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Removing goto target
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.removeTarget(Op03SimpleStatement.java:365)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.nopOut(Op03SimpleStatement.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.PointlessExpressions.removePointlessExpressionStatements(PointlessExpressions.java:28)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.removePointlessExpressionStatements(Op03Rewriters.java:185)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:561)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    public static final /* synthetic */ AtomicReference access$getConnectCancelHandler$p(RemoteVmConnection $this) {
        return $this.connectCancelHandler;
    }
}

