/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.template;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.element.FieldElement;
import org.jetbrains.java.generate.template.TemplateResource;
import org.jetbrains.java.generate.template.TemplatesState;

public abstract class TemplatesManager
implements PersistentStateComponent<TemplatesState> {
    public static final Key<Map<String, PsiType>> TEMPLATE_IMPLICITS = Key.create((String)"TEMPLATE_IMPLICITS");
    private TemplatesState myState = new TemplatesState();

    public abstract TemplateResource[] getDefaultTemplates();

    protected static String readFile(String resource, Class<? extends TemplatesManager> templatesManagerClass) throws IOException {
        BufferedInputStream in = new BufferedInputStream(templatesManagerClass.getResourceAsStream(resource));
        return StringUtil.convertLineSeparators((String)FileUtil.loadTextAndClose((Reader)new InputStreamReader((InputStream)in, CharsetToolkit.UTF8_CHARSET)));
    }

    public TemplatesState getState() {
        return this.myState;
    }

    public void loadState(TemplatesState state) {
        this.myState = state;
    }

    public void addTemplate(TemplateResource template) {
        this.myState.templates.add(template);
    }

    public void removeTemplate(TemplateResource template) {
        Iterator<TemplateResource> it = this.myState.templates.iterator();
        while (it.hasNext()) {
            TemplateResource resource = it.next();
            if (!Comparing.equal((String)resource.getFileName(), (String)template.getFileName())) continue;
            it.remove();
        }
    }

    public Collection<TemplateResource> getAllTemplates() {
        HashSet<String> names = new HashSet<String>();
        LinkedHashSet<TemplateResource> templates = new LinkedHashSet<TemplateResource>(Arrays.asList(this.getDefaultTemplates()));
        for (TemplateResource template : this.myState.templates) {
            if (!names.add(template.getFileName())) continue;
            templates.add(template);
        }
        return templates;
    }

    public TemplateResource getDefaultTemplate() {
        for (TemplateResource template : this.getAllTemplates()) {
            if (!Comparing.equal((String)template.getFileName(), (String)this.myState.defaultTempalteName)) continue;
            return template;
        }
        return this.getAllTemplates().iterator().next();
    }

    public void setDefaultTemplate(TemplateResource res) {
        this.myState.defaultTempalteName = res.getFileName();
    }

    public void setTemplates(List<TemplateResource> items) {
        this.myState.templates.clear();
        for (TemplateResource item : items) {
            if (item.isDefault()) continue;
            this.myState.templates.add(item);
        }
    }

    @NotNull
    public static PsiType createFieldListElementType(Project project2) {
        PsiType classType = TemplatesManager.createElementType(project2, FieldElement.class);
        PsiClass listClass = JavaPsiFacade.getInstance((Project)project2).findClass("java.util.List", GlobalSearchScope.allScope((Project)project2));
        Object object = listClass != null ? JavaPsiFacade.getElementFactory((Project)project2).createType(listClass, classType) : PsiType.NULL;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/generate/template/TemplatesManager", "createFieldListElementType"));
        }
        return object;
    }

    @NotNull
    public static PsiType createElementType(Project project2, Class<?> elementClass) {
        List methodNames = ContainerUtil.mapNotNull((Object[])elementClass.getMethods(), method -> {
            String methodName = method.getName();
            if (methodName.startsWith("set")) {
                return null;
            }
            return method.getGenericReturnType().toString() + " " + methodName + "();";
        });
        String text2 = "interface " + elementClass.getSimpleName() + " {\n" + StringUtil.join((Collection)methodNames, (String)"\n") + "}";
        PsiClass aClass = JavaPsiFacade.getElementFactory((Project)project2).createClassFromText(text2, null).getInnerClasses()[0];
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)project2).createType(aClass);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/generate/template/TemplatesManager", "createElementType"));
        }
        return psiClassType;
    }
}

