/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rpc;

import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandSenderBase;
import org.jetbrains.rpc.MessageManager;
import org.jetbrains.rpc.MessageProcessor;
import org.jetbrains.rpc.RequestPromise;
import org.jetbrains.rpc.ResultReader;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u0003*\u0004\b\u0002\u0010\u00042\b\u0012\u0004\u0012\u0002H\u00040\u00052\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00062\b\u0012\u0004\u0012\u0002H\u00040\b2\u00020\tB\u0005\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J0\u0010\u0014\u001a\u00020\u0012\"\u0004\b\u0003\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00072\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u0002H\u00150\u0018H\u0004J\u0014\u0010\u0019\u001a\u00020\u001a2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\r\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/rpc/CommandProcessor;", "INCOMING", "INCOMING_WITH_SEQ", "", "SUCCESS_RESPONSE", "Lorg/jetbrains/rpc/CommandSenderBase;", "Lorg/jetbrains/rpc/MessageManager$Handler;", "Lorg/jetbrains/jsonProtocol/Request;", "Lorg/jetbrains/rpc/ResultReader;", "Lorg/jetbrains/rpc/MessageProcessor;", "()V", "currentSequence", "Ljava/util/concurrent/atomic/AtomicInteger;", "messageManager", "Lorg/jetbrains/rpc/MessageManager;", "getMessageManager", "()Lorg/jetbrains/rpc/MessageManager;", "cancelWaitingRequests", "", "closed", "doSend", "RESULT", "message", "callback", "Lorg/jetbrains/rpc/RequestPromise;", "getUpdatedSequence", "", "script-debugger-backend"})
public abstract class CommandProcessor<INCOMING, INCOMING_WITH_SEQ, SUCCESS_RESPONSE>
extends CommandSenderBase<SUCCESS_RESPONSE>
implements MessageManager.Handler<Request<?>, INCOMING, INCOMING_WITH_SEQ, SUCCESS_RESPONSE>,
ResultReader<SUCCESS_RESPONSE>,
MessageProcessor {
    private final AtomicInteger currentSequence = new AtomicInteger();
    @NotNull
    private final MessageManager<Request<?>, INCOMING, INCOMING_WITH_SEQ, SUCCESS_RESPONSE> messageManager = new MessageManager(this);

    @NotNull
    protected final MessageManager<Request<?>, INCOMING, INCOMING_WITH_SEQ, SUCCESS_RESPONSE> getMessageManager() {
        return this.messageManager;
    }

    @Override
    public void cancelWaitingRequests() {
        this.messageManager.cancelWaitingRequests();
    }

    @Override
    public void closed() {
        this.messageManager.closed();
    }

    @Override
    public int getUpdatedSequence(@NotNull Request<?> message2) {
        Intrinsics.checkParameterIsNotNull(message2, (String)"message");
        int id = this.currentSequence.incrementAndGet();
        message2.finalize(id);
        return id;
    }

    @Override
    protected final <RESULT> void doSend(@NotNull Request<RESULT> message2, @NotNull RequestPromise<SUCCESS_RESPONSE, RESULT> callback) {
        Intrinsics.checkParameterIsNotNull(message2, (String)"message");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.messageManager.send(message2, callback);
    }

    @Override
    public int getSequence(@NotNull INCOMING_WITH_SEQ incomingWithSeq) {
        Intrinsics.checkParameterIsNotNull(incomingWithSeq, (String)"incomingWithSeq");
        return MessageManager.Handler.DefaultImpls.getSequence(this, incomingWithSeq);
    }

    @Override
    public int getSequence(@NotNull INCOMING_WITH_SEQ incomingWithSeq, INCOMING incoming) {
        Intrinsics.checkParameterIsNotNull(incomingWithSeq, (String)"incomingWithSeq");
        return MessageManager.Handler.DefaultImpls.getSequence(this, incomingWithSeq, incoming);
    }
}

