/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.injection.Injectable;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.FileContentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.intellij.plugins.intelliLang.references.InjectedReferencesContributor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectLanguageAction
implements IntentionAction,
LowPriorityAction {
    @NonNls
    private static final String INJECT_LANGUAGE_FAMILY = "Inject language or reference";
    public static final String LAST_INJECTED_LANGUAGE = "LAST_INJECTED_LANGUAGE";
    public static final Key<Processor<PsiLanguageInjectionHost>> FIX_KEY = Key.create((String)"inject fix key");
    private static FixPresenter DEFAULT_FIX_PRESENTER = (editor, range, pointer, text, handler) -> {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        HintManager.getInstance().showQuestionHint(editor, text, range.getStartOffset(), range.getEndOffset(), new QuestionAction(){

            public boolean execute() {
                return handler.process((Object)pointer.getElement());
            }
        });
    };

    @NotNull
    public static List<Injectable> getAllInjectables() {
        Language[] languages = InjectedLanguage.getAvailableLanguages();
        ArrayList<Injectable> list = new ArrayList<Injectable>();
        for (Language language : languages) {
            list.add(Injectable.fromLanguage((Language)language));
        }
        list.addAll(Arrays.asList(ReferenceInjector.EXTENSION_POINT_NAME.getExtensions()));
        Collections.sort(list);
        ArrayList<Injectable> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "getAllInjectables"));
        }
        return arrayList;
    }

    @NotNull
    public String getText() {
        if (INJECT_LANGUAGE_FAMILY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "getText"));
        }
        return INJECT_LANGUAGE_FAMILY;
    }

    @NotNull
    public String getFamilyName() {
        if (INJECT_LANGUAGE_FAMILY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "getFamilyName"));
        }
        return INJECT_LANGUAGE_FAMILY;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "isAvailable"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "isAvailable"));
        }
        PsiLanguageInjectionHost host = InjectLanguageAction.findInjectionHost(editor, file);
        if (host == null) {
            return false;
        }
        List injectedPsi = InjectedLanguageManager.getInstance((Project)project).getInjectedPsiFiles((PsiElement)host);
        if (injectedPsi == null || injectedPsi.isEmpty()) {
            return !InjectedReferencesContributor.isInjected(file.findReferenceAt(editor.getCaretModel().getOffset()));
        }
        return false;
    }

    @Nullable
    protected static PsiLanguageInjectionHost findInjectionHost(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "findInjectionHost"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "findInjectionHost"));
        }
        if (editor instanceof EditorWindow) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), PsiLanguageInjectionHost.class, (boolean)false);
        if (host == null) {
            return null;
        }
        return host.isValidHost() ? host : null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "invoke"));
        }
        SmartPsiElementPointer filePointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)file);
        InjectLanguageAction.doChooseLanguageToInject(editor, (Processor<Injectable>)((Processor)injectable -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "lambda$invoke$2"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "lambda$invoke$2"));
            }
            ReadAction.run(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "lambda$null$1"));
                }
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "lambda$null$1"));
                }
                if (project.isDisposed()) {
                    return;
                }
                PsiFile psiFile = (PsiFile)filePointer.getElement();
                if (psiFile == null || editor.isDisposed()) {
                    return;
                }
                InjectLanguageAction.invokeImpl(project, editor, psiFile, injectable);
            });
            return false;
        }));
    }

    public static void invokeImpl(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull Injectable injectable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "invokeImpl"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "invokeImpl"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "invokeImpl"));
        }
        if (injectable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectable", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "invokeImpl"));
        }
        InjectLanguageAction.invokeImpl(project, editor, file, injectable, DEFAULT_FIX_PRESENTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeImpl(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull Injectable injectable, @NotNull FixPresenter fixPresenter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "invokeImpl"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "invokeImpl"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "invokeImpl"));
        }
        if (injectable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectable", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "invokeImpl"));
        }
        if (fixPresenter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixPresenter", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "invokeImpl"));
        }
        PsiLanguageInjectionHost host = InjectLanguageAction.findInjectionHost(editor, file);
        if (host == null) {
            return;
        }
        if (InjectLanguageAction.defaultFunctionalityWorked(host, injectable.getId())) {
            return;
        }
        try {
            host.putUserData(FIX_KEY, null);
            Language language = injectable.toLanguage();
            for (LanguageInjectionSupport support : InjectorUtils.getActiveInjectionSupports()) {
                if (!support.isApplicableTo(host) || !support.addInjectionInPlace(language, host)) continue;
                return;
            }
            if (TemporaryPlacesRegistry.getInstance(project).getLanguageInjectionSupport().addInjectionInPlace(language, host)) {
                Processor data = (Processor)host.getUserData(FIX_KEY);
                String text = StringUtil.escapeXml((String)language.getDisplayName()) + " was temporarily injected.";
                if (data != null) {
                    SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)host);
                    String fixText = text + "<br>Do you want to insert annotation? " + KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
                    fixPresenter.showFix(editor, host.getTextRange(), (SmartPsiElementPointer<PsiLanguageInjectionHost>)pointer, fixText, (Processor<PsiLanguageInjectionHost>)data);
                } else {
                    HintManager.getInstance().showInformationHint(editor, text);
                }
            }
        }
        finally {
            if (injectable.getLanguage() != null) {
                FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
            } else {
                PsiManager.getInstance((Project)project).dropPsiCaches();
            }
        }
    }

    private static boolean defaultFunctionalityWorked(PsiLanguageInjectionHost host, String id) {
        return Configuration.getProjectInstance(host.getProject()).setHostInjectionEnabled(host, Collections.singleton(id), true);
    }

    public static void doChooseLanguageToInject(@NotNull Editor editor, @NotNull Processor<Injectable> onChosen) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "doChooseLanguageToInject"));
        }
        if (onChosen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onChosen", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "doChooseLanguageToInject"));
        }
        List<Injectable> injectables = InjectLanguageAction.getAllInjectables();
        JBList list = new JBList(injectables);
        list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<Injectable>(){

            protected void customizeCellRenderer(@NotNull JList<? extends Injectable> list, Injectable language, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction$2", "customizeCellRenderer"));
                }
                this.setIcon(language.getIcon());
                this.append(language.getDisplayName());
                String description = language.getAdditionalDescription();
                if (description != null) {
                    this.append(description, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }
        });
        Dimension minSize = new JLabel(PlainTextLanguage.INSTANCE.getDisplayName(), EmptyIcon.ICON_16, 2).getMinimumSize();
        minSize.height *= 4;
        list.setMinimumSize(minSize);
        JBPopup popup = new PopupChooserBuilder((JList)list).setItemChoosenCallback(() -> {
            if (onChosen == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onChosen", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction", "lambda$doChooseLanguageToInject$3"));
            }
            Injectable value = (Injectable)list.getSelectedValue();
            if (value != null) {
                onChosen.process((Object)value);
                PropertiesComponent.getInstance().setValue(LAST_INJECTED_LANGUAGE, value.getId());
            }
        }).setFilteringEnabled(language -> ((Injectable)language).getDisplayName()).setMinSize(minSize).createPopup();
        String lastInjected = PropertiesComponent.getInstance().getValue(LAST_INJECTED_LANGUAGE);
        if (lastInjected != null) {
            Injectable injectable = (Injectable)ContainerUtil.find(injectables, o -> lastInjected.equals(o.getId()));
            list.setSelectedValue((Object)injectable, true);
        }
        popup.showInBestPositionFor(editor);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static interface FixPresenter {
        public void showFix(@NotNull Editor var1, @NotNull TextRange var2, @NotNull SmartPsiElementPointer<PsiLanguageInjectionHost> var3, @NotNull String var4, @NotNull Processor<PsiLanguageInjectionHost> var5);
    }
}

