/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.javac.resolve;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.javac.resolve.CurrentClassAndInnerScope;
import org.jetbrains.kotlin.javac.resolve.SingleTypeImportScope;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaElement;
import org.jetbrains.kotlin.load.java.structure.JavaMember;
import org.jetbrains.kotlin.load.java.structure.JavaPackage;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameterListOwner;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J \u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\t\u001a\"\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nj\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/javac/resolve/ClassifierResolver;", "", "javac", "Lorg/jetbrains/kotlin/javac/JavacWrapper;", "(Lorg/jetbrains/kotlin/javac/JavacWrapper;)V", "beingResolved", "Ljava/util/HashSet;", "Lcom/sun/source/tree/Tree;", "Lkotlin/collections/HashSet;", "cache", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/load/java/structure/JavaClassifier;", "Lkotlin/collections/HashMap;", "", "tree", "pathSegments", "", "", "path", "removeBeingResolved", "resolve", "unit", "Lcom/sun/source/tree/CompilationUnitTree;", "containingElement", "Lorg/jetbrains/kotlin/load/java/structure/JavaElement;", "tryToResolve", "kotlin-compiler"})
public final class ClassifierResolver {
    private final HashMap<Tree, JavaClassifier> cache;
    private final HashSet<Tree> beingResolved;
    private final JavacWrapper javac;

    @Nullable
    public final JavaClassifier resolve(@NotNull Tree tree, @NotNull CompilationUnitTree unit, @NotNull JavaElement containingElement) {
        JavaClassifier javaClassifier;
        Intrinsics.checkParameterIsNotNull(tree, "tree");
        Intrinsics.checkParameterIsNotNull(unit, "unit");
        Intrinsics.checkParameterIsNotNull(containingElement, "containingElement");
        if (this.cache.containsKey(tree)) {
            return this.cache.get(tree);
        }
        if (this.beingResolved.contains(tree)) {
            return null;
        }
        this.beingResolved(tree);
        JavaClassifier $receiver = javaClassifier = this.tryToResolve(tree, unit, containingElement);
        Map map2 = this.cache;
        Tree tree2 = tree;
        JavaClassifier javaClassifier2 = $receiver;
        map2.put(tree2, javaClassifier2);
        this.removeBeingResolved(tree);
        return javaClassifier;
    }

    private final void beingResolved(Tree tree) {
        if (tree instanceof JCTree.JCTypeApply) {
            JCTree.JCExpression jCExpression = ((JCTree.JCTypeApply)tree).clazz;
            Intrinsics.checkExpressionValueIsNotNull(jCExpression, "tree.clazz");
            this.beingResolved(jCExpression);
        }
        if (tree instanceof JCTree.JCFieldAccess) {
            this.beingResolved.add(tree);
            JCTree.JCExpression jCExpression = ((JCTree.JCFieldAccess)tree).selected;
            Intrinsics.checkExpressionValueIsNotNull(jCExpression, "tree.selected");
            this.beingResolved(jCExpression);
        } else {
            this.beingResolved.add(tree);
        }
    }

    private final void removeBeingResolved(Tree tree) {
        if (tree instanceof JCTree.JCTypeApply) {
            JCTree.JCExpression jCExpression = ((JCTree.JCTypeApply)tree).clazz;
            Intrinsics.checkExpressionValueIsNotNull(jCExpression, "tree.clazz");
            this.beingResolved(jCExpression);
        }
        if (tree instanceof JCTree.JCFieldAccess) {
            this.beingResolved.remove(tree);
            JCTree.JCExpression jCExpression = ((JCTree.JCFieldAccess)tree).selected;
            Intrinsics.checkExpressionValueIsNotNull(jCExpression, "tree.selected");
            this.beingResolved(jCExpression);
        } else {
            this.beingResolved.remove(tree);
        }
    }

    private final List<String> pathSegments(String path) {
        ArrayList<String> arrayList;
        CharSequence $receiver$iv;
        ArrayList<String> pathSegments = new ArrayList<String>();
        int numberOfBrackets = 0;
        StringBuilder builder = new StringBuilder();
        CharSequence charSequence = $receiver$iv = (CharSequence)path;
        block6: for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv;
            char c = element$iv = charSequence.charAt(i);
            switch (c) {
                case '<': {
                    int n = numberOfBrackets;
                    numberOfBrackets = n + 1;
                    continue block6;
                }
                case '>': {
                    int n = numberOfBrackets;
                    numberOfBrackets = n + -1;
                    continue block6;
                }
                case '.': {
                    if (numberOfBrackets != 0) continue block6;
                    pathSegments.add(builder.toString());
                    builder.setLength(0);
                    continue block6;
                }
                case '@': {
                    continue block6;
                }
                default: {
                    if (numberOfBrackets != 0) continue block6;
                    builder.append(c);
                }
            }
        }
        ArrayList<String> $receiver = arrayList = pathSegments;
        $receiver.add(builder.toString());
        return arrayList;
    }

    private final JavaClassifier tryToResolve(Tree tree, CompilationUnitTree unit, JavaElement containingElement) {
        JavaClass javaClass;
        List<String> pathSegments = this.pathSegments(tree.toString());
        JavaElement javaElement = containingElement;
        if (javaElement instanceof JavaClass) {
            javaClass = (JavaClass)containingElement;
        } else if (javaElement instanceof JavaTypeParameterListOwner) {
            String string = CollectionsKt.singleOrNull(pathSegments);
            if (string != null) {
                Object v2;
                Object object;
                block9: {
                    String string2;
                    String pathSegment = string2 = string;
                    Name identifier = Name.identifier(pathSegment);
                    object = ((JavaTypeParameterListOwner)containingElement).getTypeParameters();
                    Iterable iterable = object;
                    for (Object t : iterable) {
                        JavaTypeParameter it = (JavaTypeParameter)t;
                        if (!Intrinsics.areEqual(it.getName(), identifier)) continue;
                        v2 = t;
                        break block9;
                    }
                    v2 = null;
                }
                JavaTypeParameter javaTypeParameter = v2;
                if (javaTypeParameter != null) {
                    Object it = object = javaTypeParameter;
                    return (JavaClassifier)it;
                }
            }
            JavaElement javaElement2 = containingElement;
            if (javaElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.load.java.structure.JavaMember");
            }
            javaClass = ((JavaMember)javaElement2).getContainingClass();
        } else {
            if (javaElement instanceof JavaPackage) {
                return new SingleTypeImportScope(this.javac, unit).findClass(CollectionsKt.first(pathSegments), pathSegments);
            }
            throw (Throwable)new UnsupportedOperationException();
        }
        JavaClass containingClass = javaClass;
        return new CurrentClassAndInnerScope(this.javac, unit, containingClass).findClass(CollectionsKt.first(pathSegments), pathSegments);
    }

    public ClassifierResolver(@NotNull JavacWrapper javac2) {
        Intrinsics.checkParameterIsNotNull(javac2, "javac");
        this.javac = javac2;
        ClassifierResolver classifierResolver = this;
        Cloneable cloneable2 = new HashMap();
        classifierResolver.cache = cloneable2;
        classifierResolver = this;
        cloneable2 = new HashSet();
        classifierResolver.beingResolved = cloneable2;
    }
}

