/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonCoroutineCodegenUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsDynamicScope;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.inline.DummyAccessorInvocationTransformer;
import org.jetbrains.kotlin.js.inline.ExpressionDecomposer;
import org.jetbrains.kotlin.js.inline.FunctionInlineMutator;
import org.jetbrains.kotlin.js.inline.FunctionReader;
import org.jetbrains.kotlin.js.inline.InlineableResult;
import org.jetbrains.kotlin.js.inline.clean.FunctionPostProcessor;
import org.jetbrains.kotlin.js.inline.clean.RemoveUnusedFunctionDefinitionsKt;
import org.jetbrains.kotlin.js.inline.clean.RemoveUnusedImportsKt;
import org.jetbrains.kotlin.js.inline.clean.RemoveUnusedLocalFunctionDeclarationsKt;
import org.jetbrains.kotlin.js.inline.clean.SimplifyWrappedFunctionsKt;
import org.jetbrains.kotlin.js.inline.context.FunctionContext;
import org.jetbrains.kotlin.js.inline.context.InliningContext;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.inline.util.NamingUtilsKt;
import org.jetbrains.kotlin.js.inline.util.RewriteUtilsKt;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.resolve.inline.InlineStrategy;

public class JsInliner
extends JsVisitorWithContextImpl {
    private final JsConfig config;
    private final Map<JsName, FunctionWithWrapper> functions;
    private final Map<String, FunctionWithWrapper> accessors;
    private final Stack<JsInliningContext> inliningContexts;
    private final Set<JsFunction> processedFunctions;
    private final Set<JsFunction> inProcessFunctions;
    private final FunctionReader functionReader;
    private final DiagnosticSink trace;
    private Map<String, JsName> existingImports;
    private JsContext<JsStatement> statementContextForInline;
    private final Map<JsBlock, FunctionWithWrapper> functionsByWrapperNodes;
    private final Map<JsFunction, FunctionWithWrapper> functionsByFunctionNodes;
    private final Stack<JsFunction> namedFunctionsStack;
    private final LinkedList<JsCallInfo> inlineCallInfos;
    private final Function1<JsNode, Boolean> canBeExtractedByInliner;
    private int inlineFunctionDepth;
    private final Map<JsWrapperKey, Map<JsName, JsExpression>> replacementsInducedByWrappers;

    public static void process(@NotNull JsConfig.Reporter reporter, @NotNull JsConfig config, @NotNull DiagnosticSink trace, @NotNull JsName currentModuleName, @NotNull List<JsProgramFragment> fragments2, @NotNull List<JsProgramFragment> fragmentsToProcess, @NotNull List<JsStatement> importStatements) {
        if (reporter == null) {
            JsInliner.$$$reportNull$$$0(0);
        }
        if (config == null) {
            JsInliner.$$$reportNull$$$0(1);
        }
        if (trace == null) {
            JsInliner.$$$reportNull$$$0(2);
        }
        if (currentModuleName == null) {
            JsInliner.$$$reportNull$$$0(3);
        }
        if (fragments2 == null) {
            JsInliner.$$$reportNull$$$0(4);
        }
        if (fragmentsToProcess == null) {
            JsInliner.$$$reportNull$$$0(5);
        }
        if (importStatements == null) {
            JsInliner.$$$reportNull$$$0(6);
        }
        Map<JsName, FunctionWithWrapper> functions2 = CollectUtilsKt.collectNamedFunctionsAndWrappers(fragments2);
        Map<String, FunctionWithWrapper> accessors = CollectUtilsKt.collectAccessors(fragments2);
        DummyAccessorInvocationTransformer accessorInvocationTransformer = new DummyAccessorInvocationTransformer();
        for (JsProgramFragment fragment : fragmentsToProcess) {
            accessorInvocationTransformer.accept(fragment.getDeclarationBlock());
            accessorInvocationTransformer.accept(fragment.getInitializerBlock());
        }
        FunctionReader functionReader = new FunctionReader(reporter, config, currentModuleName, fragments2);
        JsInliner inliner = new JsInliner(config, functions2, accessors, functionReader, trace);
        for (JsStatement statement2 : importStatements) {
            inliner.processImportStatement(statement2);
        }
        for (JsProgramFragment fragment : fragmentsToProcess) {
            inliner.existingImports.clear();
            Stack<JsInliningContext> stack = inliner.inliningContexts;
            JsInliner jsInliner = inliner;
            jsInliner.getClass();
            stack.push(jsInliner.new JsInliningContext(inliner.new JsVisitorWithContextImpl.ListContext<JsStatement>()));
            inliner.acceptStatement(fragment.getDeclarationBlock());
            JsFunction fakeInitFunction = new JsFunction((JsScope)JsDynamicScope.INSTANCE, fragment.getInitializerBlock(), "");
            JsGlobalBlock initWrapper = new JsGlobalBlock();
            initWrapper.getStatements().add(new JsExpressionStatement(fakeInitFunction));
            inliner.accept(initWrapper);
            initWrapper.getStatements().remove(initWrapper.getStatements().size() - 1);
            inliner.inliningContexts.pop();
            fragment.getInitializerBlock().getStatements().addAll(0, initWrapper.getStatements());
        }
        for (JsProgramFragment fragment : fragmentsToProcess) {
            JsBlock block = new JsBlock(fragment.getDeclarationBlock(), fragment.getInitializerBlock(), fragment.getExportBlock());
            RemoveUnusedImportsKt.removeUnusedImports(block);
            SimplifyWrappedFunctionsKt.simplifyWrappedFunctions(block);
            RemoveUnusedFunctionDefinitionsKt.removeUnusedFunctionDefinitions(block, CollectUtilsKt.collectNamedFunctions(block));
        }
    }

    private JsInliner(@NotNull JsConfig config, @NotNull Map<JsName, FunctionWithWrapper> functions2, @NotNull Map<String, FunctionWithWrapper> accessors, @NotNull FunctionReader functionReader, @NotNull DiagnosticSink trace) {
        if (config == null) {
            JsInliner.$$$reportNull$$$0(7);
        }
        if (functions2 == null) {
            JsInliner.$$$reportNull$$$0(8);
        }
        if (accessors == null) {
            JsInliner.$$$reportNull$$$0(9);
        }
        if (functionReader == null) {
            JsInliner.$$$reportNull$$$0(10);
        }
        if (trace == null) {
            JsInliner.$$$reportNull$$$0(11);
        }
        this.inliningContexts = new Stack();
        this.processedFunctions = CollectionUtilsKt.IdentitySet();
        this.inProcessFunctions = CollectionUtilsKt.IdentitySet();
        this.existingImports = new HashMap<String, JsName>();
        this.functionsByWrapperNodes = new HashMap<JsBlock, FunctionWithWrapper>();
        this.functionsByFunctionNodes = new HashMap<JsFunction, FunctionWithWrapper>();
        this.namedFunctionsStack = new Stack();
        this.inlineCallInfos = new LinkedList();
        this.canBeExtractedByInliner = node -> node instanceof JsInvocation && this.hasToBeInlined((JsInvocation)node);
        this.replacementsInducedByWrappers = new HashMap<JsWrapperKey, Map<JsName, JsExpression>>();
        this.config = config;
        this.functions = functions2;
        this.accessors = accessors;
        this.functionReader = functionReader;
        this.trace = trace;
        Stream.concat(functions2.values().stream(), accessors.values().stream()).forEach(f -> {
            this.functionsByFunctionNodes.put(f.getFunction(), (FunctionWithWrapper)f);
            if (f.getWrapperBody() != null) {
                this.functionsByWrapperNodes.put(f.getWrapperBody(), (FunctionWithWrapper)f);
            }
        });
    }

    private void processImportStatement(JsStatement statement2) {
        JsVars jsVars;
        String tag;
        if (statement2 instanceof JsVars && (tag = CollectUtilsKt.getImportTag(jsVars = (JsVars)statement2)) != null) {
            this.existingImports.put(tag, jsVars.getVars().get(0).getName());
        }
    }

    @Override
    public boolean visit(@NotNull JsFunction function2, @NotNull JsContext context) {
        FunctionWithWrapper functionWithWrapper;
        if (function2 == null) {
            JsInliner.$$$reportNull$$$0(12);
        }
        if (context == null) {
            JsInliner.$$$reportNull$$$0(13);
        }
        if ((functionWithWrapper = this.functionsByFunctionNodes.get(function2)) != null) {
            this.visit(functionWithWrapper);
            return false;
        }
        this.startFunction(function2);
        return super.visit(function2, context);
    }

    @Override
    public void endVisit(@NotNull JsFunction function2, @NotNull JsContext context) {
        if (function2 == null) {
            JsInliner.$$$reportNull$$$0(14);
        }
        if (context == null) {
            JsInliner.$$$reportNull$$$0(15);
        }
        super.endVisit(function2, context);
        if (!this.functionsByFunctionNodes.containsKey(function2)) {
            this.endFunction(function2);
        }
    }

    private void startFunction(@NotNull JsFunction function2) {
        if (function2 == null) {
            JsInliner.$$$reportNull$$$0(16);
        }
        JsContext<JsStatement> statementContext = this.statementContextForInline != null ? this.statementContextForInline : this.getLastStatementLevelContext();
        this.inliningContexts.push(new JsInliningContext(statementContext));
        assert (!this.inProcessFunctions.contains(function2)) : "Inliner has revisited function";
        this.inProcessFunctions.add(function2);
        if (this.functions.values().stream().anyMatch(namedFunction -> {
            if (function2 == null) {
                JsInliner.$$$reportNull$$$0(40);
            }
            return namedFunction.getFunction().equals(function2);
        })) {
            this.namedFunctionsStack.push(function2);
        }
    }

    private void endFunction(@NotNull JsFunction function2) {
        if (function2 == null) {
            JsInliner.$$$reportNull$$$0(17);
        }
        NamingUtilsKt.refreshLabelNames(function2.getBody(), function2.getScope());
        RemoveUnusedLocalFunctionDeclarationsKt.removeUnusedLocalFunctionDeclarations(function2);
        this.processedFunctions.add(function2);
        new FunctionPostProcessor(function2).apply();
        assert (this.inProcessFunctions.contains(function2));
        this.inProcessFunctions.remove(function2);
        this.inliningContexts.pop();
        if (!this.namedFunctionsStack.empty() && this.namedFunctionsStack.peek() == function2) {
            this.namedFunctionsStack.pop();
        }
    }

    @Override
    public boolean visit(@NotNull JsBlock x, @NotNull JsContext ctx) {
        FunctionWithWrapper functionWithWrapper;
        if (x == null) {
            JsInliner.$$$reportNull$$$0(18);
        }
        if (ctx == null) {
            JsInliner.$$$reportNull$$$0(19);
        }
        if ((functionWithWrapper = this.functionsByWrapperNodes.get(x)) != null) {
            this.visit(functionWithWrapper);
            return false;
        }
        return super.visit(x, ctx);
    }

    private void visit(@NotNull FunctionWithWrapper functionWithWrapper) {
        if (functionWithWrapper == null) {
            JsInliner.$$$reportNull$$$0(20);
        }
        JsContext<JsStatement> oldContextForInline = this.statementContextForInline;
        Map<String, JsName> oldExistingImports = this.existingImports;
        JsVisitorWithContextImpl.ListContext<JsStatement> innerContext = new JsVisitorWithContextImpl.ListContext<JsStatement>();
        JsBlock wrapperBody = functionWithWrapper.getWrapperBody();
        List<JsStatement> statements = null;
        if (wrapperBody != null) {
            this.existingImports = new HashMap<String, JsName>();
            this.statementContexts.push(innerContext);
            this.statementContextForInline = innerContext;
            for (JsStatement statement2 : wrapperBody.getStatements()) {
                this.processImportStatement(statement2);
            }
            assert (functionWithWrapper.getWrapperBody() != null);
            statements = functionWithWrapper.getWrapperBody().getStatements();
            if (!statements.isEmpty() && statements.get(statements.size() - 1) instanceof JsReturn) {
                statements = statements.subList(0, statements.size() - 1);
            }
            innerContext.traverse(statements);
            this.statementContexts.pop();
        } else {
            this.statementContextForInline = this.getLastStatementLevelContext();
        }
        this.startFunction(functionWithWrapper.getFunction());
        JsBlock block = new JsBlock((JsStatement)functionWithWrapper.getFunction().getBody());
        innerContext.traverse(block.getStatements());
        functionWithWrapper.getFunction().getBody().traverse(this, innerContext);
        this.endFunction(functionWithWrapper.getFunction());
        if (statements != null) {
            statements.addAll(block.getStatements().subList(0, block.getStatements().size() - 1));
        }
        this.statementContextForInline = oldContextForInline;
        this.existingImports = oldExistingImports;
    }

    @Override
    public boolean visit(@NotNull JsInvocation call2, @NotNull JsContext context) {
        FunctionWithWrapper definition;
        if (call2 == null) {
            JsInliner.$$$reportNull$$$0(21);
        }
        if (context == null) {
            JsInliner.$$$reportNull$$$0(22);
        }
        if (InlineMetadata.decompose(call2) != null) {
            ++this.inlineFunctionDepth;
        }
        if (!this.hasToBeInlined(call2)) {
            return true;
        }
        JsFunction containingFunction = this.getCurrentNamedFunction();
        if (containingFunction != null) {
            this.inlineCallInfos.add(new JsCallInfo(call2, containingFunction));
        }
        if (this.inProcessFunctions.contains((definition = this.getFunctionContext().getFunctionDefinition(call2)).getFunction())) {
            this.reportInlineCycle(call2, definition.getFunction());
        } else if (!this.processedFunctions.contains(definition.getFunction())) {
            for (int i = 0; i < call2.getArguments().size(); ++i) {
                JsExpression argument = call2.getArguments().get(i);
                call2.getArguments().set(i, this.accept(argument));
            }
            ++this.inlineFunctionDepth;
            this.visit(definition);
            --this.inlineFunctionDepth;
            return false;
        }
        return true;
    }

    @Override
    public void endVisit(@NotNull JsInvocation x, @NotNull JsContext ctx) {
        if (x == null) {
            JsInliner.$$$reportNull$$$0(23);
        }
        if (ctx == null) {
            JsInliner.$$$reportNull$$$0(24);
        }
        if (InlineMetadata.decompose(x) != null) {
            --this.inlineFunctionDepth;
        }
        if (this.hasToBeInlined(x)) {
            this.inline(x, ctx);
        }
        JsCallInfo lastCallInfo = null;
        if (!this.inlineCallInfos.isEmpty()) {
            lastCallInfo = this.inlineCallInfos.getLast();
        }
        if (lastCallInfo != null && lastCallInfo.call == x) {
            this.inlineCallInfos.removeLast();
        }
    }

    @Override
    protected void doAcceptStatementList(List<JsStatement> statements) {
        if (!this.inliningContexts.isEmpty()) {
            List<JsStatement> additionalStatements;
            for (int i = 0; i < statements.size(); i += additionalStatements.size() + 1) {
                additionalStatements = ExpressionDecomposer.preserveEvaluationOrder(statements.get(i), this.canBeExtractedByInliner);
                statements.addAll(i, additionalStatements);
            }
        }
        super.doAcceptStatementList(statements);
    }

    private void inline(@NotNull JsInvocation call2, @NotNull JsContext context) {
        CallableDescriptor callDescriptor;
        if (call2 == null) {
            JsInliner.$$$reportNull$$$0(25);
        }
        if (context == null) {
            JsInliner.$$$reportNull$$$0(26);
        }
        if (JsInliner.isSuspendWithCurrentContinuation(callDescriptor = MetadataProperties.getDescriptor(call2))) {
            this.inlineSuspendWithCurrentContinuation(call2, context);
            return;
        }
        JsInliningContext inliningContext = this.getInliningContext();
        FunctionWithWrapper functionWithWrapper = inliningContext.getFunctionContext().getFunctionDefinition(call2);
        if (this.functionsByFunctionNodes.containsKey(functionWithWrapper.getFunction())) {
            functionWithWrapper = this.functionsByFunctionNodes.get(functionWithWrapper.getFunction());
        }
        JsFunction function2 = functionWithWrapper.getFunction().deepCopy();
        if (functionWithWrapper.getWrapperBody() != null) {
            this.applyWrapper(functionWithWrapper.getWrapperBody(), function2, functionWithWrapper.getFunction(), inliningContext);
        }
        InlineableResult inlineableResult = FunctionInlineMutator.getInlineableCallReplacement(call2, function2, inliningContext);
        JsStatement inlineableBody = inlineableResult.getInlineableBody();
        JsExpression resultExpression = inlineableResult.getResultExpression();
        JsContext<JsStatement> statementContext = inliningContext.getStatementContext();
        JsStatement inlineableBodyWithLambdasInlined = this.accept(inlineableBody);
        assert (inlineableBody == inlineableBodyWithLambdasInlined);
        statementContext.addPrevious(JsAstUtils.flattenStatement(inlineableBody));
        if (resultExpression == null) {
            statementContext.removeMe();
            return;
        }
        resultExpression = this.accept(resultExpression);
        MetadataProperties.setSynthetic(resultExpression, true);
        context.replaceMe(resultExpression);
    }

    private void applyWrapper(@NotNull JsBlock wrapper, @NotNull JsFunction function2, @NotNull JsFunction originalFunction, @NotNull InliningContext inliningContext) {
        if (wrapper == null) {
            JsInliner.$$$reportNull$$$0(27);
        }
        if (function2 == null) {
            JsInliner.$$$reportNull$$$0(28);
        }
        if (originalFunction == null) {
            JsInliner.$$$reportNull$$$0(29);
        }
        if (inliningContext == null) {
            JsInliner.$$$reportNull$$$0(30);
        }
        Function<JsWrapperKey, Map> replacementGen = k -> {
            if (wrapper == null) {
                JsInliner.$$$reportNull$$$0(39);
            }
            JsContext ctx = k.context;
            HashMap<JsName, JsNameRef> newReplacements = new HashMap<JsName, JsNameRef>();
            ArrayList<JsStatement> copiedStatements = new ArrayList<JsStatement>();
            for (JsStatement statement2 : wrapper.getStatements()) {
                JsVars jsVars;
                String tag;
                if (statement2 instanceof JsReturn) continue;
                statement2 = statement2.deepCopy();
                if (this.inlineFunctionDepth == 0) {
                    JsInliner.replaceExpressionsWithLocalAliases(statement2);
                }
                if (statement2 instanceof JsVars && (tag = CollectUtilsKt.getImportTag(jsVars = (JsVars)statement2)) != null) {
                    JsName existingName;
                    JsName name2 = jsVars.getVars().get(0).getName();
                    JsName jsName = existingName = this.inlineFunctionDepth == 0 ? MetadataProperties.getLocalAlias(name2) : null;
                    if (existingName == null) {
                        existingName = this.existingImports.computeIfAbsent(tag, t -> {
                            copiedStatements.add(jsVars);
                            JsName alias = JsScope.declareTemporaryName(name2.getIdent());
                            alias.copyMetadataFrom(name2);
                            newReplacements.put(name2, JsAstUtils.pureFqn(alias, null));
                            return alias;
                        });
                    }
                    if (name2 == existingName) continue;
                    JsNameRef replacement = JsAstUtils.pureFqn(existingName, null);
                    newReplacements.put(name2, replacement);
                    continue;
                }
                copiedStatements.add(statement2);
            }
            Set definedNames = copiedStatements.stream().flatMap(node -> CollectUtilsKt.collectDefinedNamesInAllScopes(node).stream()).filter(name -> !newReplacements.containsKey(name)).collect(Collectors.toSet());
            for (JsName jsName : definedNames) {
                JsName alias = JsScope.declareTemporaryName(jsName.getIdent());
                alias.copyMetadataFrom(jsName);
                JsNameRef replacement = JsAstUtils.pureFqn(alias, null);
                newReplacements.put(jsName, replacement);
            }
            for (JsStatement jsStatement : copiedStatements) {
                JsStatement jsStatement2 = RewriteUtilsKt.replaceNames(jsStatement, newReplacements);
                ctx.addPrevious(this.accept(jsStatement2));
            }
            for (Map.Entry entry : CollectUtilsKt.collectNamedFunctions(new JsBlock(copiedStatements)).entrySet()) {
                if (!(MetadataProperties.getStaticRef((JsName)entry.getKey()) instanceof JsFunction)) continue;
                MetadataProperties.setStaticRef((JsName)entry.getKey(), (JsNode)entry.getValue());
            }
            return newReplacements;
        };
        JsWrapperKey key = new JsWrapperKey(inliningContext.getStatementContextBeforeCurrentFunction(), originalFunction);
        Map replacements = this.replacementsInducedByWrappers.computeIfAbsent(key, replacementGen);
        RewriteUtilsKt.replaceNames(function2, replacements);
    }

    private static void replaceExpressionsWithLocalAliases(@NotNull JsStatement statement2) {
        if (statement2 == null) {
            JsInliner.$$$reportNull$$$0(31);
        }
        new JsVisitorWithContextImpl(){

            @Override
            public void endVisit(@NotNull JsNameRef x, @NotNull JsContext ctx) {
                if (x == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ctx == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.replaceIfNecessary(x, ctx);
            }

            @Override
            public void endVisit(@NotNull JsArrayAccess x, @NotNull JsContext ctx) {
                if (x == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (ctx == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.replaceIfNecessary(x, ctx);
            }

            private void replaceIfNecessary(@NotNull JsExpression expression2, @NotNull JsContext context) {
                JsName alias;
                if (expression2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(5);
                }
                if ((alias = MetadataProperties.getLocalAlias(expression2)) != null) {
                    context.replaceMe(alias.makeRef());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "x";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ctx";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/js/inline/JsInliner$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "endVisit";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "replaceIfNecessary";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.accept(statement2);
    }

    private static boolean isSuspendWithCurrentContinuation(@Nullable DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return false;
        }
        return CommonCoroutineCodegenUtilKt.isBuiltInSuspendCoroutineOrReturn((FunctionDescriptor)descriptor2.getOriginal());
    }

    private void inlineSuspendWithCurrentContinuation(@NotNull JsInvocation call2, @NotNull JsContext context) {
        if (call2 == null) {
            JsInliner.$$$reportNull$$$0(32);
        }
        if (context == null) {
            JsInliner.$$$reportNull$$$0(33);
        }
        JsExpression lambda2 = call2.getArguments().get(0);
        JsExpression continuationArg = call2.getArguments().get(call2.getArguments().size() - 1);
        JsInvocation invocation = new JsInvocation(lambda2, continuationArg);
        MetadataProperties.setSuspend(invocation, true);
        context.replaceMe(this.accept(invocation));
    }

    @NotNull
    private JsInliningContext getInliningContext() {
        JsInliningContext jsInliningContext = this.inliningContexts.peek();
        if (jsInliningContext == null) {
            JsInliner.$$$reportNull$$$0(34);
        }
        return jsInliningContext;
    }

    @NotNull
    private FunctionContext getFunctionContext() {
        FunctionContext functionContext = this.getInliningContext().getFunctionContext();
        if (functionContext == null) {
            JsInliner.$$$reportNull$$$0(35);
        }
        return functionContext;
    }

    @Nullable
    private JsFunction getCurrentNamedFunction() {
        if (this.namedFunctionsStack.empty()) {
            return null;
        }
        return this.namedFunctionsStack.peek();
    }

    private void reportInlineCycle(@NotNull JsInvocation call2, @NotNull JsFunction calledFunction) {
        if (call2 == null) {
            JsInliner.$$$reportNull$$$0(36);
        }
        if (calledFunction == null) {
            JsInliner.$$$reportNull$$$0(37);
        }
        MetadataProperties.setInlineStrategy(call2, InlineStrategy.NOT_INLINE);
        Iterator<JsCallInfo> it = this.inlineCallInfos.descendingIterator();
        while (it.hasNext()) {
            JsCallInfo callInfo = it.next();
            PsiElement psiElement = MetadataProperties.getPsiElement(callInfo.call);
            CallableDescriptor descriptor2 = MetadataProperties.getDescriptor(callInfo.call);
            if (psiElement != null && descriptor2 != null) {
                this.trace.report(Errors.INLINE_CALL_CYCLE.on(psiElement, descriptor2));
            }
            if (callInfo.containingFunction != calledFunction) continue;
            break;
        }
    }

    private boolean hasToBeInlined(@NotNull JsInvocation call2) {
        InlineStrategy strategy;
        if (call2 == null) {
            JsInliner.$$$reportNull$$$0(38);
        }
        if ((strategy = MetadataProperties.getInlineStrategy(call2)) == null || !strategy.isInline()) {
            return false;
        }
        return this.getFunctionContext().hasFunctionDefinition(call2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentModuleName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentsToProcess";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatements";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessors";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReader";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 28: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 13: 
            case 15: 
            case 22: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionWithWrapper";
                break;
            }
            case 21: 
            case 25: 
            case 32: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 27: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFunction";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inliningContext";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/inline/JsInliner";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calledFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/inline/JsInliner";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getInliningContext";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 14: 
            case 15: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "endVisit";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "startFunction";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "endFunction";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "inline";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "applyWrapper";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpressionsWithLocalAliases";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "inlineSuspendWithCurrentContinuation";
                break;
            }
            case 34: 
            case 35: {
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "reportInlineCycle";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "hasToBeInlined";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyWrapper$6";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$startFunction$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class JsWrapperKey {
        final JsContext context;
        private final JsFunction function;

        public JsWrapperKey(@NotNull JsContext context, @NotNull JsFunction function2) {
            if (context == null) {
                JsWrapperKey.$$$reportNull$$$0(0);
            }
            if (function2 == null) {
                JsWrapperKey.$$$reportNull$$$0(1);
            }
            this.context = context;
            this.function = function2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsWrapperKey key = (JsWrapperKey)o;
            return Objects.equals(this.context, key.context) && Objects.equals(this.function, key.function);
        }

        public int hashCode() {
            return Objects.hash(this.context, this.function);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "function";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/js/inline/JsInliner$JsWrapperKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JsCallInfo {
        @NotNull
        public final JsInvocation call;
        @NotNull
        public final JsFunction containingFunction;

        private JsCallInfo(@NotNull JsInvocation call2, @NotNull JsFunction function2) {
            if (call2 == null) {
                JsCallInfo.$$$reportNull$$$0(0);
            }
            if (function2 == null) {
                JsCallInfo.$$$reportNull$$$0(1);
            }
            this.call = call2;
            this.containingFunction = function2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "call";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "function";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/js/inline/JsInliner$JsCallInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class JsInliningContext
    implements InliningContext {
        private final FunctionContext functionContext;
        @NotNull
        private final JsContext<JsStatement> statementContextBeforeCurrentFunction;

        JsInliningContext(@NotNull JsContext<JsStatement> statementContextBeforeCurrentFunction) {
            if (statementContextBeforeCurrentFunction == null) {
                JsInliningContext.$$$reportNull$$$0(0);
            }
            this.functionContext = new FunctionContext(JsInliner.this.functionReader, JsInliner.this.config){

                @Override
                @Nullable
                protected FunctionWithWrapper lookUpStaticFunction(@Nullable JsName functionName) {
                    return (FunctionWithWrapper)JsInliner.this.functions.get(functionName);
                }

                @Override
                @Nullable
                protected FunctionWithWrapper lookUpStaticFunctionByTag(@NotNull String functionTag) {
                    if (functionTag == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return (FunctionWithWrapper)JsInliner.this.accessors.get(functionTag);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionTag", "org/jetbrains/kotlin/js/inline/JsInliner$JsInliningContext$1", "lookUpStaticFunctionByTag"));
                }
            };
            this.statementContextBeforeCurrentFunction = statementContextBeforeCurrentFunction;
        }

        @Override
        @NotNull
        public NamingContext newNamingContext() {
            NamingContext namingContext = new NamingContext(this.getStatementContext());
            if (namingContext == null) {
                JsInliningContext.$$$reportNull$$$0(1);
            }
            return namingContext;
        }

        @Override
        @NotNull
        public JsContext<JsStatement> getStatementContext() {
            JsContext jsContext = JsInliner.this.getLastStatementLevelContext();
            if (jsContext == null) {
                JsInliningContext.$$$reportNull$$$0(2);
            }
            return jsContext;
        }

        @Override
        @NotNull
        public FunctionContext getFunctionContext() {
            FunctionContext functionContext = this.functionContext;
            if (functionContext == null) {
                JsInliningContext.$$$reportNull$$$0(3);
            }
            return functionContext;
        }

        @Override
        @NotNull
        public JsContext<JsStatement> getStatementContextBeforeCurrentFunction() {
            JsContext<JsStatement> jsContext = this.statementContextBeforeCurrentFunction;
            if (jsContext == null) {
                JsInliningContext.$$$reportNull$$$0(4);
            }
            return jsContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statementContextBeforeCurrentFunction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/inline/JsInliner$JsInliningContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/inline/JsInliner$JsInliningContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newNamingContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatementContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFunctionContext";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatementContextBeforeCurrentFunction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

