/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinImportDirectiveStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.resolve.ImportPath;

public class KtImportDirective
extends KtElementImplStub<KotlinImportDirectiveStub> {
    public KtImportDirective(@NotNull ASTNode node) {
        if (node == null) {
            KtImportDirective.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public KtImportDirective(@NotNull KotlinImportDirectiveStub stub) {
        if (stub == null) {
            KtImportDirective.$$$reportNull$$$0(1);
        }
        super(stub, KtStubElementTypes.IMPORT_DIRECTIVE);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            KtImportDirective.$$$reportNull$$$0(2);
        }
        return visitor2.visitImportDirective(this, data);
    }

    @IfNotParsed
    @Nullable
    public KtExpression getImportedReference() {
        KtExpression[] references = (KtExpression[])this.getStubOrPsiChildren(KtStubElementTypes.INSIDE_DIRECTIVE_EXPRESSIONS, KtExpression.ARRAY_FACTORY);
        if (references.length > 0) {
            return references[0];
        }
        return null;
    }

    @Nullable
    public KtImportAlias getAlias() {
        return this.getStubOrPsiChild(KtStubElementTypes.IMPORT_ALIAS);
    }

    @Nullable
    public String getAliasName() {
        KtImportAlias alias = this.getAlias();
        return alias != null ? alias.getName() : null;
    }

    public boolean isAllUnder() {
        KotlinImportDirectiveStub stub = (KotlinImportDirectiveStub)this.getStub();
        if (stub != null) {
            return stub.isAllUnder();
        }
        return this.getNode().findChildByType(KtTokens.MUL) != null;
    }

    @IfNotParsed
    @Nullable
    public FqName getImportedFqName() {
        KotlinImportDirectiveStub stub = (KotlinImportDirectiveStub)this.getStub();
        if (stub != null) {
            return stub.getImportedFqName();
        }
        return KtImportDirective.fqNameFromExpression(this.getImportedReference());
    }

    @IfNotParsed
    @Nullable
    public ImportPath getImportPath() {
        FqName importFqn = this.getImportedFqName();
        if (importFqn == null) {
            return null;
        }
        Name alias = null;
        String aliasName = this.getAliasName();
        if (aliasName != null) {
            alias = Name.identifier(aliasName);
        }
        return new ImportPath(importFqn, this.isAllUnder(), alias);
    }

    public boolean isValidImport() {
        KotlinImportDirectiveStub stub = (KotlinImportDirectiveStub)this.getStub();
        if (stub != null) {
            return stub.isValid();
        }
        return !PsiTreeUtil.hasErrorElements(this);
    }

    @Nullable
    private static FqName fqNameFromExpression(@Nullable KtExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        if (expression2 instanceof KtDotQualifiedExpression) {
            KtDotQualifiedExpression dotQualifiedExpression = (KtDotQualifiedExpression)expression2;
            FqName parentFqn = KtImportDirective.fqNameFromExpression(dotQualifiedExpression.getReceiverExpression());
            Name child = KtImportDirective.nameFromExpression(dotQualifiedExpression.getSelectorExpression());
            if (child == null) {
                return parentFqn;
            }
            if (parentFqn != null) {
                return parentFqn.child(child);
            }
            return null;
        }
        if (expression2 instanceof KtSimpleNameExpression) {
            KtSimpleNameExpression simpleNameExpression = (KtSimpleNameExpression)expression2;
            return FqName.topLevel(simpleNameExpression.getReferencedNameAsName());
        }
        throw new IllegalArgumentException("Can't construct fqn for: " + expression2.getClass().toString());
    }

    @Nullable
    private static Name nameFromExpression(@Nullable KtExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        if (expression2 instanceof KtSimpleNameExpression) {
            return ((KtSimpleNameExpression)expression2).getReferencedNameAsName();
        }
        throw new IllegalArgumentException("Can't construct name for: " + expression2.getClass().toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/psi/KtImportDirective";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

