/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.concurrent.Callable;
import org.gradle.api.provider.Provider;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProvider<T>
implements Provider<T> {
    public static final String NON_NULL_VALUE_EXCEPTION_MESSAGE = "Needs to set a non-null value before it can be retrieved";
    private final Callable<T> value;

    public DefaultProvider(Callable<T> value) {
        assert (value != null) : "value cannot be null";
        this.value = value;
    }

    @Override
    public T get() {
        T evaluatedValue = this.getOrNull();
        if (evaluatedValue == null) {
            throw new IllegalStateException(NON_NULL_VALUE_EXCEPTION_MESSAGE);
        }
        return evaluatedValue;
    }

    @Override
    public T getOrNull() {
        try {
            return this.value.call();
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    @Override
    public boolean isPresent() {
        return this.getOrNull() != null;
    }

    public String toString() {
        return String.format("value: %s", this.getOrNull());
    }
}

