/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.composite;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.gradle.StartParameter;
import org.gradle.api.GradleException;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.IncludedBuildFactory;
import org.gradle.initialization.SettingsLoader;
import org.gradle.internal.composite.CompositeContextBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeBuildSettingsLoader
implements SettingsLoader {
    private static final Logger LOGGER = Logging.getLogger(CompositeBuildSettingsLoader.class);
    private final SettingsLoader delegate;
    private final CompositeContextBuilder compositeContextBuilder;
    private final IncludedBuildFactory includedBuildFactory;

    public CompositeBuildSettingsLoader(SettingsLoader delegate, CompositeContextBuilder compositeContextBuilder, IncludedBuildFactory includedBuildFactory) {
        this.delegate = delegate;
        this.compositeContextBuilder = compositeContextBuilder;
        this.includedBuildFactory = includedBuildFactory;
    }

    @Override
    public SettingsInternal findAndLoadSettings(GradleInternal gradle) {
        SettingsInternal settings = this.delegate.findAndLoadSettings(gradle);
        this.compositeContextBuilder.setRootBuild(settings);
        Collection<IncludedBuild> includedBuilds = this.getIncludedBuilds(gradle.getStartParameter(), settings);
        if (!includedBuilds.isEmpty()) {
            gradle.setIncludedBuilds(includedBuilds);
            if (gradle.getStartParameter().isContinuous()) {
                LOGGER.warn("[composite-build] Warning: continuous build doesn't detect changes in included builds.");
            }
            this.compositeContextBuilder.addIncludedBuilds(includedBuilds);
        }
        return settings;
    }

    private Collection<IncludedBuild> getIncludedBuilds(StartParameter startParameter, SettingsInternal settings) {
        LinkedHashMap includedBuildMap = Maps.newLinkedHashMap();
        includedBuildMap.putAll(settings.getIncludedBuilds());
        for (File file : startParameter.getIncludedBuilds()) {
            if (includedBuildMap.containsKey(file)) continue;
            includedBuildMap.put(file, this.includedBuildFactory.createBuild(file));
        }
        return this.validateBuildNames(includedBuildMap.values(), settings);
    }

    private Collection<IncludedBuild> validateBuildNames(Collection<IncludedBuild> builds, SettingsInternal settings) {
        HashSet names = Sets.newHashSet();
        for (IncludedBuild build : builds) {
            String buildName = build.getName();
            if (!names.add(buildName)) {
                throw new GradleException("Included build '" + buildName + "' is not unique in composite.");
            }
            if (settings.getRootProject().getName().equals(buildName)) {
                throw new GradleException("Included build '" + buildName + "' collides with root project name.");
            }
            if (settings.findProject(":" + buildName) == null) continue;
            throw new GradleException("Included build '" + buildName + "' collides with subproject of the same name.");
        }
        return builds;
    }
}

