/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.ResourceXmlDetector;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.XmlContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class BatteryDetector
extends ResourceXmlDetector
implements Detector.UastScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(BatteryDetector.class, EnumSet.of(Scope.MANIFEST, Scope.JAVA_FILE), Scope.MANIFEST_SCOPE, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("BatteryLife", "Battery Life Issues", "This issue flags code that either\n* negatively affects battery life, or\n* uses APIs that have recently changed behavior to prevent background tasks from consuming memory and battery excessively.\n\nGenerally, you should be using `JobScheduler` or `GcmNetworkManager` instead.\n\nFor more details on how to update your code, please seehttp://developer.android.com/preview/features/background-optimization.html", Category.CORRECTNESS, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://developer.android.com/preview/features/background-optimization.html");

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("action");
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        String message;
        assert (element.getTagName().equals("action"));
        Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        if (attr == null) {
            return;
        }
        String name = attr.getValue();
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(name) && element.getParentNode() != null && element.getParentNode().getParentNode() != null && "receiver".equals(element.getParentNode().getParentNode().getNodeName()) && context.getMainProject().getTargetSdkVersion().getFeatureLevel() >= 24) {
            message = "Declaring a broadcastreceiver for `android.net.conn.CONNECTIVITY_CHANGE` is deprecated for apps targeting N and higher. In general, apps should not rely on this broadcast and instead use `JobScheduler` or `GCMNetworkManager`.";
            context.report(ISSUE, element, context.getValueLocation(attr), message);
        }
        if ("android.settings.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS".equals(name) && context.getMainProject().getTargetSdkVersion().getFeatureLevel() >= 23) {
            message = BatteryDetector.getBatteryOptimizationsErrorMessage();
            context.report(ISSUE, element, context.getValueLocation(attr), message);
        }
        if ("android.hardware.action.NEW_PICTURE".equals(name) || "android.hardware.action.NEW_VIDEO".equals(name) || "com.android.camera.NEW_PICTURE".equals(name)) {
            message = String.format("Use of %1$s is deprecated for all apps starting with the N release independent of the target SDK. Apps should not rely on these broadcasts and instead use `JobScheduler`", name);
            context.report(ISSUE, element, context.getValueLocation(attr), message);
        }
    }

    @Override
    @Nullable
    public List<String> getApplicableReferenceNames() {
        return Collections.singletonList("ACTION_REQUEST_IGNORE_BATTERY_OPTIMIZATIONS");
    }

    @Override
    public void visitReference(@NonNull JavaContext context, @Nullable UastVisitor visitor, @NonNull UReferenceExpression reference, @NonNull PsiElement resolved) {
        if (resolved instanceof PsiField && context.getEvaluator().isMemberInSubClassOf((PsiMember)((PsiField)resolved), "android.provider.Settings", false) && context.getMainProject().getTargetSdkVersion().getFeatureLevel() >= 23) {
            String message = BatteryDetector.getBatteryOptimizationsErrorMessage();
            context.report(ISSUE, (UElement)reference, context.getUastNameLocation((UElement)reference), message);
        }
    }

    @NonNull
    private static String getBatteryOptimizationsErrorMessage() {
        return "Use of `REQUEST_IGNORE_BATTERY_OPTIMIZATIONS` violates the Play Store Content Policy regarding acceptable use cases, as described in http://developer.android.com/training/monitoring-device-state/doze-standby.html";
    }
}

