/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.CharSequences;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;

public class ProguardDetector
extends Detector {
    private static final Implementation IMPLEMENTATION = new Implementation(ProguardDetector.class, Scope.PROGUARD_SCOPE);
    public static final Issue WRONG_KEEP = Issue.create("Proguard", "Using obsolete ProGuard configuration", "Using `-keepclasseswithmembernames` in a proguard config file is not correct; it can cause some symbols to be renamed which should not be.\nEarlier versions of ADT used to create proguard.cfg files with the wrong format. Instead of `-keepclasseswithmembernames` use `-keepclasseswithmembers`, since the old flags also implies \"allow shrinking\" which means symbols only referred to from XML and not Java (such as possibly CustomViews) can get deleted.", Category.CORRECTNESS, 8, Severity.FATAL, IMPLEMENTATION).addMoreInfo("http://http://code.google.com/p/android/issues/detail?id=16384");
    public static final Issue SPLIT_CONFIG = Issue.create("ProguardSplit", "Proguard.cfg file contains generic Android rules", "Earlier versions of the Android tools bundled a single `proguard.cfg` file containing a ProGuard configuration file suitable for Android shrinking and obfuscation. However, that version was copied into new projects, which means that it does not continue to get updated as we improve the default ProGuard rules for Android.\n\nIn the new version of the tools, we have split the ProGuard configuration into two halves:\n* A simple configuration file containing only project-specific flags, in your project\n* A generic configuration file containing the recommended set of ProGuard options for Android projects. This generic file lives in the SDK install directory which means that it gets updated along with the tools.\n\nIn order for this to work, the proguard.config property in the `project.properties` file now refers to a path, so you can reference both the generic file as well as your own (and any additional files too).\n\nTo migrate your project to the new setup, create a new `proguard-project.txt` file in your project containing any project specific ProGuard flags as well as any customizations you have made, then update your project.properties file to contain:\n`proguard.config=${sdk.dir}/tools/proguard/proguard-android.txt:proguard-project.txt`", Category.CORRECTNESS, 3, Severity.WARNING, IMPLEMENTATION);

    @Override
    public void run(Context context) {
        CharSequence contents = context.getContents();
        if (contents != null) {
            int index;
            if (context.isEnabled(WRONG_KEEP) && (index = CharSequences.indexOf(contents, "-keepclasseswithmembernames class * {\n    public <init>(android.")) != -1) {
                context.report(WRONG_KEEP, Location.create(context.file, contents, index, index), "Obsolete ProGuard file; use `-keepclasseswithmembers` instead of `-keepclasseswithmembernames`");
            }
            if (context.isEnabled(SPLIT_CONFIG) && (index = CharSequences.indexOf(contents, "-keep public class * extends android.app.Activity")) != -1) {
                File propertyFile = new File(context.file.getParentFile(), "project.properties");
                if (!propertyFile.exists()) {
                    return;
                }
                CharSequence properties = context.getClient().readFile(propertyFile);
                int i = CharSequences.indexOf(properties, "proguard.config");
                if (i == -1) {
                    return;
                }
                while (i >= 0) {
                    char c = properties.charAt(i);
                    if (c == '#') {
                        return;
                    }
                    if (c == '\n') break;
                    --i;
                }
                if (CharSequences.indexOf(properties, "proguard.config") != -1) {
                    context.report(SPLIT_CONFIG, Location.create(context.file, contents, index, index), String.format("Local ProGuard configuration contains general Android configuration: Inherit these settings instead? Modify `project.properties` to define `proguard.config=${sdk.dir}/tools/proguard/proguard-android.txt:%1$s` and then keep only project-specific configuration here", context.file.getName()));
                }
            }
        }
    }
}

