/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.plugincomponents;

import com.intellij.AppTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.MessageBus;
import org.editorconfig.configmanagement.DocumentSettingsManager;
import org.editorconfig.configmanagement.EditorSettingsManager;
import org.editorconfig.configmanagement.EncodingManager;
import org.editorconfig.configmanagement.LineEndingsManager;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.jetbrains.annotations.NotNull;

public class ConfigProjectComponent
implements StartupActivity,
DumbAware {
    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            ConfigProjectComponent.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final EditorFactory editorFactory = EditorFactory.getInstance();
        MessageBus bus = project.getMessageBus();
        DocumentSettingsManager documentSettingsManager = new DocumentSettingsManager(project);
        EncodingManager encodingManager = new EncodingManager(project);
        LineEndingsManager lineEndingsManager = new LineEndingsManager(project);
        final EditorSettingsManager editorSettingsManager = new EditorSettingsManager(project);
        bus.connect().subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)encodingManager);
        bus.connect().subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)documentSettingsManager);
        bus.connect().subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)lineEndingsManager);
        editorFactory.addEditorFactoryListener((EditorFactoryListener)editorSettingsManager, (Disposable)project);
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.updateOpenEditors(event);
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.updateOpenEditors(event);
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.updateOpenEditors(event);
            }

            private void updateOpenEditors(VirtualFileEvent event) {
                VirtualFile file = event.getFile();
                if (".editorconfig".equals(file.getName()) && (ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file) || !Registry.is((String)"editor.config.stop.at.project.root"))) {
                    SettingsProviderComponent.getInstance().incModificationCount();
                    for (Editor editor : editorFactory.getAllEditors()) {
                        if (editor.isDisposed()) continue;
                        editorSettingsManager.applyEditorSettings(editor);
                        ((EditorEx)editor).reinitSettings();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/editorconfig/plugincomponents/ConfigProjectComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentsChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/editorconfig/plugincomponents/ConfigProjectComponent", "runActivity"));
    }
}

