/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.InsertComponentProcessor;
import com.intellij.uiDesigner.inspections.FormInspectionUtil;
import com.intellij.uiDesigner.propertyInspector.DesignerToolWindowManager;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.BindingEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.quickFixes.CreateFieldFix;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.util.IncorrectOperationException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BindingProperty
extends Property<RadComponent, String> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.propertyInspector.properties.BindingProperty");
    private final PropertyRenderer<String> myRenderer = new LabelPropertyRenderer<String>(){

        @Override
        protected void customize(@NotNull String value) {
            if (value == null) {
                1.$$$reportNull$$$0(0);
            }
            this.setText(value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/uiDesigner/propertyInspector/properties/BindingProperty$1", "customize"));
        }
    };
    private final BindingEditor myEditor;
    @NonNls
    private static final String PREFIX_HTML = "<html>";

    public BindingProperty(Project project) {
        super(null, "field name");
        this.myEditor = new BindingEditor(project);
    }

    @Override
    public PropertyEditor<String> getEditor() {
        return this.myEditor;
    }

    @Override
    @NotNull
    public PropertyRenderer<String> getRenderer() {
        PropertyRenderer<String> propertyRenderer = this.myRenderer;
        if (propertyRenderer == null) {
            BindingProperty.$$$reportNull$$$0(0);
        }
        return propertyRenderer;
    }

    @Override
    public String getValue(RadComponent component) {
        return component.getBinding();
    }

    @Override
    protected void setValueImpl(RadComponent component, String value) throws Exception {
        if (Comparing.strEqual((String)value, (String)component.getBinding(), (boolean)true)) {
            return;
        }
        if (value.length() > 0 && !PsiNameHelper.getInstance((Project)component.getProject()).isIdentifier(value)) {
            throw new Exception("Value '" + value + "' is not a valid identifier");
        }
        RadRootContainer root = (RadRootContainer)FormEditingUtil.getRoot(component);
        String oldBinding = this.getValue(component);
        if (value.length() > 0) {
            if (!FormEditingUtil.isBindingUnique(component, value, root)) {
                throw new Exception(UIDesignerBundle.message("error.binding.not.unique", new Object[0]));
            }
            component.setBinding(value);
            component.setDefaultBinding(false);
        } else {
            if (component.isCustomCreateRequired()) {
                throw new Exception(UIDesignerBundle.message("error.custom.create.binding.required", new Object[0]));
            }
            component.setBinding(null);
            component.setCustomCreate(false);
        }
        BindingProperty.updateBoundFieldName(root, oldBinding, value, component.getComponentClassName());
    }

    public static void updateBoundFieldName(RadRootContainer root, String oldName, String newName, String fieldClassName) {
        int option;
        String classToBind = root.getClassToBind();
        if (classToBind == null) {
            return;
        }
        Project project = root.getProject();
        if (newName.length() == 0) {
            BindingProperty.checkRemoveUnusedField(root, oldName, FormEditingUtil.getNextSaveUndoGroupId(project));
            return;
        }
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(classToBind, GlobalSearchScope.allScope((Project)project));
        if (aClass == null) {
            return;
        }
        if (oldName == null) {
            if (aClass.findFieldByName(newName, true) == null) {
                CreateFieldFix.runImpl(project, root, aClass, fieldClassName, newName, false, FormEditingUtil.getNextSaveUndoGroupId(project));
            }
            return;
        }
        PsiField oldField = aClass.findFieldByName(oldName, true);
        if (oldField == null) {
            return;
        }
        if (aClass.findFieldByName(newName, true) != null) {
            BindingProperty.checkRemoveUnusedField(root, oldName, FormEditingUtil.getNextSaveUndoGroupId(project));
            return;
        }
        if (!BindingProperty.isFieldUnreferenced(oldField) && (option = Messages.showYesNoDialog((Project)project, (String)MessageFormat.format(UIDesignerBundle.message("message.rename.field", new Object[0]), oldName, newName), (String)UIDesignerBundle.message("title.rename", new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
            return;
        }
        GuiEditor editor = DesignerToolWindowManager.getInstance(project).getActiveFormEditor();
        if (editor != null) {
            editor.refreshAndSave(false);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)aClass)) {
            return;
        }
        RenameProcessor processor = new RenameProcessor(project, (PsiElement)oldField, newName, true, true);
        processor.run();
    }

    @Override
    public boolean isModified(RadComponent component) {
        return component.getBinding() != null;
    }

    @Override
    public void resetValue(RadComponent component) throws Exception {
        this.setValueImpl(component, "");
    }

    @Override
    public boolean appliesToSelection(List<RadComponent> selection) {
        return selection.size() == 1;
    }

    @Nullable
    public static PsiField findBoundField(@NotNull RadRootContainer root, String fieldName) {
        PsiField oldBindingField;
        PsiManager manager;
        PsiClass aClass;
        if (root == null) {
            BindingProperty.$$$reportNull$$$0(1);
        }
        Project project = root.getProject();
        String classToBind = root.getClassToBind();
        if (classToBind != null && (aClass = JavaPsiFacade.getInstance((Project)(manager = PsiManager.getInstance((Project)project)).getProject()).findClass(classToBind, GlobalSearchScope.allScope((Project)project))) != null && (oldBindingField = aClass.findFieldByName(fieldName, false)) != null) {
            return oldBindingField;
        }
        return null;
    }

    public static void checkRemoveUnusedField(RadRootContainer rootContainer, String fieldName, Object undoGroupId) {
        PsiField oldBindingField = BindingProperty.findBoundField(rootContainer, fieldName);
        if (oldBindingField == null) {
            return;
        }
        Project project = oldBindingField.getProject();
        PsiClass aClass = oldBindingField.getContainingClass();
        if (BindingProperty.isFieldUnreferenced(oldBindingField)) {
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)aClass)) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(project, () -> {
                try {
                    oldBindingField.delete();
                }
                catch (IncorrectOperationException e) {
                    Messages.showErrorDialog((Project)project, (String)UIDesignerBundle.message("error.cannot.delete.unused.field", e.getMessage()), (String)CommonBundle.getErrorTitle());
                }
            }, UIDesignerBundle.message("command.delete.unused.field", new Object[0]), undoGroupId));
        }
    }

    private static boolean isFieldUnreferenced(PsiField field) {
        try {
            return ReferencesSearch.search((PsiElement)field).forEach(t -> {
                PsiFile f = t.getElement().getContainingFile();
                if (f != null && f.getFileType().equals(StdFileTypes.GUI_DESIGNER_FORM)) {
                    return true;
                }
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)t.getElement(), PsiMethod.class);
                return method != null && method.getName().equals("$$$setupUI$$$");
            });
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    public static void checkCreateBindingFromText(RadComponent component, String text) {
        if (!component.isDefaultBinding()) {
            return;
        }
        RadRootContainer root = (RadRootContainer)FormEditingUtil.getRoot(component);
        PsiField boundField = BindingProperty.findBoundField(root, component.getBinding());
        if (boundField == null || !BindingProperty.isFieldUnreferenced(boundField)) {
            return;
        }
        String binding = BindingProperty.suggestBindingFromText(component, text);
        if (binding != null) {
            new BindingProperty(component.getProject()).setValueEx(component, binding);
            component.setDefaultBinding(true);
        }
    }

    @Nullable
    public static String suggestBindingFromText(RadComponent component, String text) {
        ArrayList words;
        if (StringUtil.startsWithIgnoreCase((String)text, (String)PREFIX_HTML)) {
            text = Pattern.compile("<.+?>").matcher(text).replaceAll("");
        }
        if ((words = new ArrayList(StringUtil.getWordsIn((String)text))).size() > 0) {
            StringBuilder nameBuilder = new StringBuilder(StringUtil.decapitalize((String)((String)words.get(0))));
            for (int i = 1; i < words.size() && i < 4; ++i) {
                nameBuilder.append(StringUtil.capitalize((String)((String)words.get(i))));
            }
            String shortClassName = StringUtil.capitalize((String)InsertComponentProcessor.getShortClassName(component.getComponentClassName()));
            if (shortClassName.equalsIgnoreCase(nameBuilder.toString())) {
                return null;
            }
            nameBuilder.append(shortClassName);
            RadRootContainer root = (RadRootContainer)FormEditingUtil.getRoot(component);
            Project project = root.getProject();
            String binding = JavaCodeStyleManager.getInstance((Project)project).propertyNameToVariableName(nameBuilder.toString(), VariableKind.FIELD);
            if (FormEditingUtil.findComponentWithBinding(root, binding, component) != null) {
                binding = InsertComponentProcessor.getUniqueBinding(root, nameBuilder.toString());
            }
            return binding;
        }
        return null;
    }

    public static String getDefaultBinding(RadComponent c) {
        RadRootContainer root = (RadRootContainer)FormEditingUtil.getRoot(c);
        String binding = null;
        String text = FormInspectionUtil.getText(c.getModule(), c);
        if (text != null) {
            binding = BindingProperty.suggestBindingFromText(c, text);
        }
        if (binding == null) {
            binding = InsertComponentProcessor.suggestBinding(root, c.getComponentClassName());
        }
        return binding;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/propertyInspector/properties/BindingProperty";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/propertyInspector/properties/BindingProperty";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findBoundField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

