/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.console.GroovyConsoleUtilKt;
import org.jetbrains.plugins.groovy.util.ModuleChooserUtil;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0001\u00a8\u0006\t"}, d2={"getAnyApplicableModule", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "getApplicableModules", "", "getWorkingDirectory", "", "module", "jetgroovy"})
public final class GroovyConsoleUtilKt {
    @NotNull
    public static final List<Module> getApplicableModules(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List modules = ArraysKt.toList((Object[])ModuleManager.getInstance((Project)project).getModules());
        return ModuleChooserUtil.filterGroovyCompatibleModules((Collection<? extends Module>)modules, (Function1<? super Module, Boolean>)((Function1)getApplicableModules.1.INSTANCE));
    }

    @Nullable
    public static final Module getAnyApplicableModule(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return (Module)CollectionsKt.firstOrNull(GroovyConsoleUtilKt.getApplicableModules(project));
    }

    @Nullable
    public static final String getWorkingDirectory(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Object object = (VirtualFile)ArraysKt.firstOrNull((Object[])ModuleRootManager.getInstance((Module)module).getContentRoots());
        if (object == null || (object = object.getPath()) == null) {
            object = module.getProject().getBasePath();
        }
        return object;
    }
}

