/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;

public class GrDummyIdentifierProvider {
    public static final String DUMMY_IDENTIFIER_DECAPITALIZED = StringUtil.decapitalize((String)"IntellijIdeaRulezzz ");
    private final CompletionInitializationContext myContext;

    public GrDummyIdentifierProvider(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            GrDummyIdentifierProvider.$$$reportNull$$$0(0);
        }
        this.myContext = context;
    }

    @Nullable
    public String getIdentifier() {
        if (this.myContext.getCompletionType() == CompletionType.BASIC && this.myContext.getFile() instanceof GroovyFile) {
            PsiElement position = this.myContext.getFile().findElementAt(this.myContext.getStartOffset());
            if (position != null && position.getParent() instanceof GrVariable && position == ((GrVariable)position.getParent()).getNameIdentifierGroovy() || position != null && position.getParent() instanceof GrAnnotationNameValuePair && position == ((GrAnnotationNameValuePair)position.getParent()).getNameIdentifierGroovy()) {
                return CompletionUtil.DUMMY_IDENTIFIER_TRIMMED;
            }
            if (this.isIdentifierBeforeLParenth()) {
                return this.setCorrectCase() + ";";
            }
            if (GroovyCompletionUtil.isInPossibleClosureParameter(position)) {
                return this.setCorrectCase() + "->";
            }
            if (this.isBeforeAssign()) {
                return CompletionUtil.DUMMY_IDENTIFIER_TRIMMED;
            }
            return this.setCorrectCase();
        }
        return null;
    }

    private boolean isBeforeAssign() {
        HighlighterIterator iterator = ((EditorEx)this.myContext.getEditor()).getHighlighter().createIterator(this.myContext.getStartOffset());
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getTokenType() == GroovyTokenTypes.mIDENT) {
            iterator.advance();
        }
        while (!iterator.atEnd() && TokenSets.WHITE_SPACES_OR_COMMENTS.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        return !iterator.atEnd() && iterator.getTokenType() == GroovyTokenTypes.mASSIGN;
    }

    @NotNull
    private String setCorrectCase() {
        PsiElement element = this.myContext.getFile().findElementAt(this.myContext.getStartOffset());
        if (element == null) {
            String string = DUMMY_IDENTIFIER_DECAPITALIZED;
            if (string == null) {
                GrDummyIdentifierProvider.$$$reportNull$$$0(1);
            }
            return string;
        }
        String text = element.getText();
        if (text.isEmpty()) {
            String string = DUMMY_IDENTIFIER_DECAPITALIZED;
            if (string == null) {
                GrDummyIdentifierProvider.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = Character.isUpperCase(text.charAt(0)) ? "IntellijIdeaRulezzz " : DUMMY_IDENTIFIER_DECAPITALIZED;
        if (string == null) {
            GrDummyIdentifierProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    private boolean isIdentifierBeforeLParenth() {
        HighlighterIterator iterator = ((EditorEx)this.myContext.getEditor()).getHighlighter().createIterator(this.myContext.getStartOffset());
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getTokenType() == GroovyTokenTypes.mIDENT) {
            iterator.advance();
        }
        while (!iterator.atEnd() && TokenSets.WHITE_SPACES_OR_COMMENTS.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        return !iterator.atEnd() && iterator.getTokenType() == GroovyTokenTypes.mLPAREN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/completion/GrDummyIdentifierProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/completion/GrDummyIdentifierProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "setCorrectCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

