/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTuple;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.InstanceOfInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ArgumentInstruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.DefinitionMap;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsDfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsSemilattice;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaState;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypesSemilattice;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.InferenceContext;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class TypeInferenceHelper {
    private static final ThreadLocal<InferenceContext> ourInferenceContext = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T doInference(@NotNull Map<String, PsiType> bindings, @NotNull Computable<T> computation) {
        if (bindings == null) {
            TypeInferenceHelper.$$$reportNull$$$0(0);
        }
        if (computation == null) {
            TypeInferenceHelper.$$$reportNull$$$0(1);
        }
        InferenceContext old = ourInferenceContext.get();
        ourInferenceContext.set(new InferenceContext.PartialContext(bindings));
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            ourInferenceContext.set(old);
        }
    }

    public static InferenceContext getCurrentContext() {
        InferenceContext context = ourInferenceContext.get();
        return context != null ? context : InferenceContext.TOP_CONTEXT;
    }

    @Nullable
    public static PsiType getInferredType(@NotNull GrReferenceExpression refExpr) {
        GrControlFlowOwner scope;
        if (refExpr == null) {
            TypeInferenceHelper.$$$reportNull$$$0(2);
        }
        if ((scope = ControlFlowUtils.findControlFlowOwner(refExpr)) == null) {
            return null;
        }
        String referenceName = refExpr.getReferenceName();
        if (referenceName == null) {
            return null;
        }
        ReadWriteVariableInstruction rwInstruction = ControlFlowUtils.findRWInstruction(refExpr, scope.getControlFlow());
        if (rwInstruction == null) {
            return null;
        }
        return TypeInferenceHelper.getInferenceCache(scope).getInferredType(referenceName, rwInstruction);
    }

    @Nullable
    public static PsiType getInferredType(@NotNull PsiElement place, @NotNull String variableName) {
        GrControlFlowOwner scope;
        if (place == null) {
            TypeInferenceHelper.$$$reportNull$$$0(3);
        }
        if (variableName == null) {
            TypeInferenceHelper.$$$reportNull$$$0(4);
        }
        if ((scope = ControlFlowUtils.findControlFlowOwner(place)) == null) {
            return null;
        }
        Instruction nearest = ControlFlowUtils.findNearestInstruction(place, scope.getControlFlow());
        if (nearest == null) {
            return null;
        }
        return TypeInferenceHelper.getInferenceCache(scope).getInferredType(variableName, nearest);
    }

    @NotNull
    private static InferenceCache getInferenceCache(@NotNull GrControlFlowOwner scope) {
        if (scope == null) {
            TypeInferenceHelper.$$$reportNull$$$0(5);
        }
        InferenceCache inferenceCache = (InferenceCache)CachedValuesManager.getCachedValue((PsiElement)scope, () -> {
            if (scope == null) {
                TypeInferenceHelper.$$$reportNull$$$0(9);
            }
            return CachedValueProvider.Result.create((Object)new InferenceCache(scope), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (inferenceCache == null) {
            TypeInferenceHelper.$$$reportNull$$$0(6);
        }
        return inferenceCache;
    }

    public static boolean isTooComplexTooAnalyze(@NotNull GrControlFlowOwner scope) {
        if (scope == null) {
            TypeInferenceHelper.$$$reportNull$$$0(7);
        }
        return TypeInferenceHelper.getDefUseMaps(scope) == null;
    }

    @Nullable
    private static Pair<ReachingDefinitionsDfaInstance, List<DefinitionMap>> getDefUseMaps(final @NotNull GrControlFlowOwner scope) {
        if (scope == null) {
            TypeInferenceHelper.$$$reportNull$$$0(8);
        }
        return (Pair)CachedValuesManager.getCachedValue((PsiElement)scope, (CachedValueProvider)new CachedValueProvider<Pair<ReachingDefinitionsDfaInstance, List<DefinitionMap>>>(){

            public CachedValueProvider.Result<Pair<ReachingDefinitionsDfaInstance, List<DefinitionMap>>> compute() {
                ReachingDefinitionsSemilattice lattice;
                ReachingDefinitionsDfaInstance dfaInstance;
                final Instruction[] flow = scope.getControlFlow();
                DFAEngine<DefinitionMap> engine = new DFAEngine<DefinitionMap>(flow, dfaInstance = new ReachingDefinitionsDfaInstance(flow){

                    @Override
                    public void fun(@NotNull DefinitionMap m, @NotNull Instruction instruction) {
                        if (m == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (instruction == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (instruction instanceof InstanceOfInstruction) {
                            int varIndex;
                            InstanceOfInstruction instanceOfInstruction = (InstanceOfInstruction)instruction;
                            ReadWriteVariableInstruction i = instanceOfInstruction.getInstructionToMixin(flow);
                            if (i != null && (varIndex = this.getVarIndex(i.getVariableName())) >= 0) {
                                m.registerDef(instruction, varIndex);
                            }
                        } else if (instruction instanceof ArgumentInstruction) {
                            String variableName = ((ArgumentInstruction)instruction).getVariableName();
                            if (variableName != null) {
                                m.registerDef(instruction, this.getVarIndex(variableName));
                            }
                        } else {
                            super.fun(m, instruction);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "m";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "instruction";
                                break;
                            }
                        }
                        objectArray[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeInferenceHelper$1$1";
                        objectArray[2] = "fun";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, lattice = new ReachingDefinitionsSemilattice());
                List<DefinitionMap> dfaResult = engine.performDFAWithTimeout();
                Pair result = dfaResult == null ? null : Pair.create((Object)dfaInstance, dfaResult);
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
    }

    @Nullable
    public static PsiType getInitializerType(PsiElement element) {
        if (element instanceof GrReferenceExpression && ((GrReferenceExpression)element).getQualifierExpression() == null) {
            return TypeInferenceHelper.getInitializerTypeFor(element);
        }
        if (element instanceof GrVariable) {
            return ((GrVariable)element).getTypeGroovy();
        }
        return null;
    }

    @Nullable
    public static PsiType getInitializerTypeFor(PsiElement element) {
        GrTuple list;
        GrTupleAssignmentExpression assignment;
        PsiElement parent = PsiUtil.skipParentheses(element.getParent(), true);
        if (parent instanceof GrAssignmentExpression) {
            if (element instanceof GrIndexProperty) {
                GrExpression rvalue = ((GrAssignmentExpression)parent).getRValue();
                return rvalue != null ? rvalue.getType() : null;
            }
            return ((GrAssignmentExpression)parent).getType();
        }
        if (parent instanceof GrTuple && (assignment = (list = (GrTuple)parent).getParent()) != null) {
            GrExpression rValue = assignment.getRValue();
            int idx = list.indexOf(element);
            if (idx >= 0 && rValue != null) {
                PsiType rType = rValue.getType();
                if (rType instanceof GrTupleType) {
                    PsiType[] componentTypes = ((GrTupleType)rType).getComponentTypes();
                    if (idx < componentTypes.length) {
                        return componentTypes[idx];
                    }
                    return null;
                }
                return com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)rType, (boolean)false);
            }
        }
        if (parent instanceof GrUnaryExpression && TokenSets.POSTFIX_UNARY_OP_SET.contains(((GrUnaryExpression)parent).getOperationTokenType())) {
            return ((GrUnaryExpression)parent).getType();
        }
        return null;
    }

    @Nullable
    public static GrExpression getInitializerFor(GrExpression lValue) {
        PsiElement parent = lValue.getParent();
        if (parent instanceof GrAssignmentExpression) {
            return ((GrAssignmentExpression)parent).getRValue();
        }
        if (parent instanceof GrTuple) {
            GrExpression[] initializers;
            int i = ((GrTuple)parent).indexOf(lValue);
            GrTupleAssignmentExpression pparent = ((GrTuple)parent).getParent();
            PsiUtil.LOG.assertTrue(pparent != null);
            GrExpression rValue = pparent.getRValue();
            if (rValue instanceof GrListOrMap && !((GrListOrMap)rValue).isMap() && (initializers = ((GrListOrMap)rValue).getInitializers()).length < i) {
                return initializers[i];
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeInferenceHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeInferenceHelper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferenceCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doInference";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInferredType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInferenceCache";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isTooComplexTooAnalyze";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDefUseMaps";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getInferenceCache$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InferenceCache {
        final GrControlFlowOwner scope;
        final Instruction[] flow;
        final AtomicReference<List<TypeDfaState>> varTypes;
        final Set<Instruction> tooComplex = ContainerUtil.newConcurrentSet();

        InferenceCache(GrControlFlowOwner scope) {
            this.scope = scope;
            this.flow = scope.getControlFlow();
            ArrayList<TypeDfaState> noTypes = new ArrayList<TypeDfaState>();
            for (int i = 0; i < this.flow.length; ++i) {
                noTypes.add(new TypeDfaState());
            }
            this.varTypes = new AtomicReference(noTypes);
        }

        @Nullable
        private PsiType getInferredType(@NotNull String variableName, @NotNull Instruction instruction) {
            DFAType dfaType;
            if (variableName == null) {
                InferenceCache.$$$reportNull$$$0(0);
            }
            if (instruction == null) {
                InferenceCache.$$$reportNull$$$0(1);
            }
            if (this.tooComplex.contains(instruction)) {
                return null;
            }
            TypeDfaState cache = this.varTypes.get().get(instruction.num());
            if (!cache.containsVariable(variableName)) {
                Pair defUse = TypeInferenceHelper.getDefUseMaps(this.scope);
                if (defUse == null) {
                    this.tooComplex.add(instruction);
                    return null;
                }
                Set<Instruction> interesting = this.collectRequiredInstructions(instruction, variableName, (Pair<ReachingDefinitionsDfaInstance, List<DefinitionMap>>)defUse);
                List<TypeDfaState> dfaResult = this.performTypeDfa(this.scope, this.flow, interesting);
                if (dfaResult == null) {
                    this.tooComplex.addAll(interesting);
                } else {
                    this.cacheDfaResult(dfaResult);
                }
            }
            return (dfaType = this.getCachedInferredType(variableName, instruction)) == null ? null : dfaType.getResultType();
        }

        @Nullable
        private List<TypeDfaState> performTypeDfa(@NotNull GrControlFlowOwner owner, @NotNull Instruction[] flow, @NotNull Set<Instruction> interesting) {
            if (owner == null) {
                InferenceCache.$$$reportNull$$$0(2);
            }
            if (flow == null) {
                InferenceCache.$$$reportNull$$$0(3);
            }
            if (interesting == null) {
                InferenceCache.$$$reportNull$$$0(4);
            }
            TypeDfaInstance dfaInstance = new TypeDfaInstance(owner, flow, interesting, this);
            TypesSemilattice semilattice = new TypesSemilattice(owner.getManager());
            return new DFAEngine<TypeDfaState>(flow, dfaInstance, semilattice).performDFAWithTimeout();
        }

        @Nullable
        DFAType getCachedInferredType(@NotNull String variableName, @NotNull Instruction instruction) {
            DFAType dfaType;
            if (variableName == null) {
                InferenceCache.$$$reportNull$$$0(5);
            }
            if (instruction == null) {
                InferenceCache.$$$reportNull$$$0(6);
            }
            return (dfaType = this.varTypes.get().get(instruction.num()).getVariableType(variableName)) == null ? null : dfaType.negate(instruction);
        }

        private Set<Instruction> collectRequiredInstructions(@NotNull Instruction instruction, @NotNull String variableName, @NotNull Pair<ReachingDefinitionsDfaInstance, List<DefinitionMap>> defUse) {
            if (instruction == null) {
                InferenceCache.$$$reportNull$$$0(7);
            }
            if (variableName == null) {
                InferenceCache.$$$reportNull$$$0(8);
            }
            if (defUse == null) {
                InferenceCache.$$$reportNull$$$0(9);
            }
            HashSet interesting = ContainerUtil.newHashSet((Object[])new Instruction[]{instruction});
            LinkedList queue = ContainerUtil.newLinkedList();
            queue.add(Pair.create((Object)instruction, (Object)variableName));
            while (!queue.isEmpty()) {
                Pair pair = (Pair)queue.removeFirst();
                for (Pair<Instruction, String> dep : this.findDependencies(defUse, (Instruction)pair.first, (String)pair.second)) {
                    if (!interesting.add(dep.first)) continue;
                    queue.addLast(dep);
                }
            }
            return interesting;
        }

        @NotNull
        private Set<Pair<Instruction, String>> findDependencies(@NotNull Pair<ReachingDefinitionsDfaInstance, List<DefinitionMap>> defUse, @NotNull Instruction insn, @NotNull String varName) {
            int varIndex;
            DefinitionMap definitionMap;
            int[] definitions;
            if (defUse == null) {
                InferenceCache.$$$reportNull$$$0(10);
            }
            if (insn == null) {
                InferenceCache.$$$reportNull$$$0(11);
            }
            if (varName == null) {
                InferenceCache.$$$reportNull$$$0(12);
            }
            if ((definitions = (definitionMap = (DefinitionMap)((List)defUse.second).get(insn.num())).getDefinitions(varIndex = ((ReachingDefinitionsDfaInstance)defUse.first).getVarIndex(varName))) == null) {
                Set<Pair<Instruction, String>> set = Collections.emptySet();
                if (set == null) {
                    InferenceCache.$$$reportNull$$$0(13);
                }
                return set;
            }
            LinkedHashSet pairs = ContainerUtil.newLinkedHashSet();
            for (int defIndex : definitions) {
                Instruction write = this.flow[defIndex];
                pairs.add(Pair.create((Object)write, (Object)varName));
                PsiElement statement = InferenceCache.findDependencyScope(write.getElement());
                if (statement == null) continue;
                pairs.addAll(this.findAllInstructionsInside(statement));
            }
            LinkedHashSet linkedHashSet = pairs;
            if (linkedHashSet == null) {
                InferenceCache.$$$reportNull$$$0(14);
            }
            return linkedHashSet;
        }

        @NotNull
        private List<Pair<Instruction, String>> findAllInstructionsInside(@NotNull PsiElement scope) {
            if (scope == null) {
                InferenceCache.$$$reportNull$$$0(15);
            }
            final ArrayList result = ContainerUtil.newArrayList();
            scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    String varName;
                    if (element instanceof GrReferenceExpression && !((GrReferenceExpression)element).isQualified() && (varName = ((GrReferenceExpression)element).getReferenceName()) != null) {
                        for (Instruction dependency : ControlFlowUtils.findAllInstructions(element, flow)) {
                            result.add(Pair.create((Object)dependency, (Object)varName));
                        }
                    }
                    super.visitElement(element);
                }
            });
            ArrayList arrayList = result;
            if (arrayList == null) {
                InferenceCache.$$$reportNull$$$0(16);
            }
            return arrayList;
        }

        @Nullable
        private static PsiElement findDependencyScope(@Nullable PsiElement element) {
            return PsiTreeUtil.findFirstParent((PsiElement)element, element1 -> PsiUtil.isExpressionStatement(element1) || !(element1.getParent() instanceof GrExpression));
        }

        private void cacheDfaResult(@NotNull List<TypeDfaState> dfaResult) {
            List<TypeDfaState> oldTypes;
            if (dfaResult == null) {
                InferenceCache.$$$reportNull$$$0(17);
            }
            while (!this.varTypes.compareAndSet(oldTypes = this.varTypes.get(), InferenceCache.addDfaResult(dfaResult, oldTypes))) {
            }
        }

        @NotNull
        private static List<TypeDfaState> addDfaResult(@NotNull List<TypeDfaState> dfaResult, @NotNull List<TypeDfaState> oldTypes) {
            if (dfaResult == null) {
                InferenceCache.$$$reportNull$$$0(18);
            }
            if (oldTypes == null) {
                InferenceCache.$$$reportNull$$$0(19);
            }
            ArrayList<TypeDfaState> newTypes = new ArrayList<TypeDfaState>(oldTypes);
            for (int i = 0; i < dfaResult.size(); ++i) {
                newTypes.set(i, ((TypeDfaState)newTypes.get(i)).mergeWith(dfaResult.get(i)));
            }
            ArrayList<TypeDfaState> arrayList = newTypes;
            if (arrayList == null) {
                InferenceCache.$$$reportNull$$$0(20);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 13: 
                case 14: 
                case 16: 
                case 20: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 13: 
                case 14: 
                case 16: 
                case 20: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variableName";
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instruction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interesting";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defUse";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insn";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "varName";
                    break;
                }
                case 13: 
                case 14: 
                case 16: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeInferenceHelper$InferenceCache";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dfaResult";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeInferenceHelper$InferenceCache";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findDependencies";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findAllInstructionsInside";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addDfaResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getInferredType";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "performTypeDfa";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getCachedInferredType";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "collectRequiredInstructions";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "findDependencies";
                    break;
                }
                case 13: 
                case 14: 
                case 16: 
                case 20: {
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "findAllInstructionsInside";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "cacheDfaResult";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "addDfaResult";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 13: 
                case 14: 
                case 16: 
                case 20: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class TypeDfaInstance
    implements DfaInstance<TypeDfaState> {
        private final GrControlFlowOwner myScope;
        private final Instruction[] myFlow;
        private final Set<Instruction> myInteresting;
        private final InferenceCache myCache;

        TypeDfaInstance(@NotNull GrControlFlowOwner scope, @NotNull Instruction[] flow, @NotNull Set<Instruction> interesting, @NotNull InferenceCache cache) {
            if (scope == null) {
                TypeDfaInstance.$$$reportNull$$$0(0);
            }
            if (flow == null) {
                TypeDfaInstance.$$$reportNull$$$0(1);
            }
            if (interesting == null) {
                TypeDfaInstance.$$$reportNull$$$0(2);
            }
            if (cache == null) {
                TypeDfaInstance.$$$reportNull$$$0(3);
            }
            this.myScope = scope;
            this.myFlow = flow;
            this.myInteresting = interesting;
            this.myCache = cache;
        }

        @Override
        public void fun(@NotNull TypeDfaState state, @NotNull Instruction instruction) {
            if (state == null) {
                TypeDfaInstance.$$$reportNull$$$0(4);
            }
            if (instruction == null) {
                TypeDfaInstance.$$$reportNull$$$0(5);
            }
            if (instruction instanceof ReadWriteVariableInstruction) {
                this.handleVariableWrite(state, (ReadWriteVariableInstruction)instruction);
            } else if (instruction instanceof MixinTypeInstruction) {
                this.handleMixin(state, (MixinTypeInstruction)instruction);
            }
        }

        private void handleMixin(@NotNull TypeDfaState state, @NotNull MixinTypeInstruction instruction) {
            String varName;
            if (state == null) {
                TypeDfaInstance.$$$reportNull$$$0(6);
            }
            if (instruction == null) {
                TypeDfaInstance.$$$reportNull$$$0(7);
            }
            if ((varName = instruction.getVariableName()) == null) {
                return;
            }
            this.updateVariableType(state, instruction, varName, (Computable<DFAType>)((NullableComputable)() -> {
                if (instruction == null) {
                    TypeDfaInstance.$$$reportNull$$$0(13);
                }
                if (state == null) {
                    TypeDfaInstance.$$$reportNull$$$0(14);
                }
                ReadWriteVariableInstruction originalInstr = instruction.getInstructionToMixin(this.myFlow);
                assert (originalInstr != null && !originalInstr.isWrite());
                DFAType original = state.getVariableType(varName);
                if (original == null) {
                    original = DFAType.create(null);
                }
                original = original.negate(originalInstr);
                original.addMixin(instruction.inferMixinType(), instruction.getConditionInstruction());
                return original;
            }));
        }

        private void handleVariableWrite(TypeDfaState state, ReadWriteVariableInstruction instruction) {
            PsiElement element = instruction.getElement();
            if (element != null && instruction.isWrite()) {
                this.updateVariableType(state, instruction, instruction.getVariableName(), (Computable<DFAType>)((Computable)() -> DFAType.create(TypeInferenceHelper.getInitializerType(element))));
            }
        }

        private void updateVariableType(@NotNull TypeDfaState state, @NotNull Instruction instruction, @NotNull String variableName, @NotNull Computable<DFAType> computation) {
            if (state == null) {
                TypeDfaInstance.$$$reportNull$$$0(8);
            }
            if (instruction == null) {
                TypeDfaInstance.$$$reportNull$$$0(9);
            }
            if (variableName == null) {
                TypeDfaInstance.$$$reportNull$$$0(10);
            }
            if (computation == null) {
                TypeDfaInstance.$$$reportNull$$$0(11);
            }
            if (!this.myInteresting.contains(instruction)) {
                state.removeBinding(variableName);
                return;
            }
            DFAType type = this.myCache.getCachedInferredType(variableName, instruction);
            if (type == null) {
                type = (DFAType)TypeInferenceHelper.doInference(state.getBindings(instruction), computation);
            }
            state.putType(variableName, type);
        }

        @Override
        @NotNull
        public TypeDfaState initial() {
            TypeDfaState typeDfaState = new TypeDfaState();
            if (typeDfaState == null) {
                TypeDfaInstance.$$$reportNull$$$0(12);
            }
            return typeDfaState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interesting";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cache";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instruction";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variableName";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "computation";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeInferenceHelper$TypeDfaInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeInferenceHelper$TypeDfaInstance";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "initial";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "fun";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "handleMixin";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "updateVariableType";
                    break;
                }
                case 12: {
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$handleMixin$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

