/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrCallImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;

public class GrConstructorInvocationImpl
extends GrCallImpl
implements GrConstructorInvocation {
    public GrConstructorInvocationImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrConstructorInvocationImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitConstructorInvocation(this);
    }

    public String toString() {
        return "Constructor invocation";
    }

    @Override
    public boolean isSuperCall() {
        return this.getKeywordType() == GroovyTokenTypes.kSUPER;
    }

    @Override
    public boolean isThisCall() {
        return this.getKeywordType() == GroovyTokenTypes.kTHIS;
    }

    @Nullable
    private IElementType getKeywordType() {
        GrReferenceExpression keyword = this.getInvokedExpression();
        PsiElement refElement = keyword.getReferenceNameElement();
        if (refElement == null) {
            return null;
        }
        return refElement.getNode().getElementType();
    }

    @Override
    @NotNull
    public GrReferenceExpression getInvokedExpression() {
        GrReferenceExpression grReferenceExpression = (GrReferenceExpression)this.findNotNullChildByClass(GrReferenceExpression.class);
        if (grReferenceExpression == null) {
            GrConstructorInvocationImpl.$$$reportNull$$$0(1);
        }
        return grReferenceExpression;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        PsiClass clazz = this.getDelegatedClass();
        if (clazz != null) {
            PsiSubstitutor substitutor;
            PsiType[] argTypes = PsiUtil.getArgumentTypes(this.getFirstChild(), false);
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
            if (this.isThisCall()) {
                substitutor = PsiSubstitutor.EMPTY;
            } else {
                PsiClass enclosing = PsiUtil.getContextClass(this);
                assert (enclosing != null);
                substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)clazz, (PsiClass)enclosing, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            }
            PsiClassType thisType = factory.createType(clazz, substitutor);
            MethodResolverProcessor processor = new MethodResolverProcessor(clazz.getName(), this, true, (PsiType)thisType, argTypes, PsiType.EMPTY_ARRAY, incompleteCode);
            ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, (Object)substitutor);
            clazz.processDeclarations((PsiScopeProcessor)processor, state, null, (PsiElement)this);
            ResolveUtil.processNonCodeMembers((PsiType)thisType, processor, this.getInvokedExpression(), state);
            GroovyResolveResult[] groovyResolveResultArray = processor.getCandidates();
            if (groovyResolveResultArray == null) {
                GrConstructorInvocationImpl.$$$reportNull$$$0(2);
            }
            return groovyResolveResultArray;
        }
        if (GroovyResolveResult.EMPTY_ARRAY == null) {
            GrConstructorInvocationImpl.$$$reportNull$$$0(3);
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }

    @Override
    public GroovyResolveResult[] multiResolveClass() {
        PsiClass aClass = this.getDelegatedClass();
        if (aClass == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        return new GroovyResolveResult[]{new GroovyResolveResultImpl((PsiElement)aClass, this, null, PsiSubstitutor.EMPTY, true, true)};
    }

    @Override
    @Nullable
    public PsiClass getDelegatedClass() {
        PsiClass typeDefinition = PsiUtil.getContextClass(this);
        if (typeDefinition != null) {
            return this.isThisCall() ? typeDefinition : typeDefinition.getSuperClass();
        }
        return null;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getCallVariants(@Nullable GrExpression upToArgument) {
        GroovyResolveResult[] groovyResolveResultArray = this.multiResolve(true);
        if (groovyResolveResultArray == null) {
            GrConstructorInvocationImpl.$$$reportNull$$$0(4);
        }
        return groovyResolveResultArray;
    }

    @Override
    @NotNull
    public GrArgumentList getArgumentList() {
        GrArgumentList grArgumentList = (GrArgumentList)this.findNotNullChildByClass(GrArgumentList.class);
        if (grArgumentList == null) {
            GrConstructorInvocationImpl.$$$reportNull$$$0(5);
        }
        return grArgumentList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrConstructorInvocationImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrConstructorInvocationImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvokedExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallVariants";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

