/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrSpreadArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.typing.GrTypeCalculator;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/DefaultListOrMapTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/typing/GrTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/GrListOrMap;", "()V", "getListTypeFromDiamond", "Lcom/intellij/psi/PsiType;", "expression", "getMapTypeFromDiamond", "getTupleType", "getType", "groovy-psi"})
public final class DefaultListOrMapTypeCalculator
implements GrTypeCalculator<GrListOrMap> {
    @Override
    @Nullable
    public PsiType getType(@NotNull GrListOrMap expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        if (expression.isMap()) {
            PsiType psiType = this.getMapTypeFromDiamond(expression);
            if (psiType == null) {
                psiType = (PsiType)GrMapType.createFromNamedArgs(expression, expression.getNamedArguments());
            }
            return psiType;
        }
        PsiType psiType = this.getListTypeFromDiamond(expression);
        if (psiType == null) {
            psiType = this.getTupleType(expression);
        }
        return psiType;
    }

    private final PsiType getMapTypeFromDiamond(GrListOrMap expression) {
        GrNamedArgument[] namedArgs = expression.getNamedArguments();
        Object[] objectArray = namedArgs;
        Object[] objectArray2 = objectArray;
        if (!(objectArray2.length == 0)) {
            return null;
        }
        PsiType psiType = PsiImplUtil.inferExpectedTypeForDiamond(expression);
        if (psiType == null) {
            return null;
        }
        PsiType lType = psiType;
        if (!(lType instanceof PsiClassType) || !InheritanceUtil.isInheritor((PsiType)lType, (String)"java.util.Map")) {
            return null;
        }
        GlobalSearchScope scope = expression.getResolveScope();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)expression.getProject());
        PsiClass psiClass = facade.findClass("java.util.LinkedHashMap", scope);
        if (psiClass == null) {
            return null;
        }
        PsiClass hashMap = psiClass;
        return (PsiType)facade.getElementFactory().createType(hashMap, new PsiType[]{PsiUtil.substituteTypeParameter((PsiType)lType, (String)"java.util.Map", (int)0, (boolean)false), PsiUtil.substituteTypeParameter((PsiType)lType, (String)"java.util.Map", (int)1, (boolean)false)});
    }

    private final PsiType getListTypeFromDiamond(GrListOrMap expression) {
        GrExpression[] initializers = expression.getInitializers();
        Object[] objectArray = initializers;
        Object[] objectArray2 = objectArray;
        if (!(objectArray2.length == 0)) {
            return null;
        }
        PsiType lType = PsiImplUtil.inferExpectedTypeForDiamond(expression);
        if (!(lType instanceof PsiClassType)) {
            return null;
        }
        GlobalSearchScope scope = expression.getResolveScope();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)expression.getProject());
        if (InheritanceUtil.isInheritor((PsiType)lType, (String)"java.util.List")) {
            PsiClass psiClass = facade.findClass("java.util.ArrayList", scope);
            if (psiClass == null) {
                psiClass = facade.findClass("java.util.List", scope);
            }
            if (psiClass == null) {
                return null;
            }
            PsiClass arrayList = psiClass;
            return (PsiType)facade.getElementFactory().createType(arrayList, PsiUtil.substituteTypeParameter((PsiType)lType, (String)"java.util.List", (int)0, (boolean)false));
        }
        if (InheritanceUtil.isInheritor((PsiType)lType, (String)"java.util.Set")) {
            PsiClass psiClass = facade.findClass("java.util.LinkedHashSet", scope);
            if (psiClass == null) {
                psiClass = facade.findClass("java.util.Set", scope);
            }
            if (psiClass == null) {
                return null;
            }
            PsiClass set = psiClass;
            return (PsiType)facade.getElementFactory().createType(set, PsiUtil.substituteTypeParameter((PsiType)lType, (String)"java.util.Set", (int)0, (boolean)false));
        }
        return null;
    }

    private final PsiType getTupleType(GrListOrMap expression) {
        GrExpression[] initializers = expression.getInitializers();
        return (PsiType)new GrTupleType(initializers, expression, expression.getResolveScope(), JavaPsiFacade.getInstance((Project)expression.getProject())){
            final /* synthetic */ GrExpression[] $initializers;
            final /* synthetic */ GrListOrMap $expression;

            /*
             * WARNING - void declaration
             */
            @NotNull
            protected PsiType[] inferComponents() {
                void $receiver$iv$iv;
                Object $receiver$iv = this.$initializers;
                Object[] objectArray = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                    GrExpression it;
                    void element$iv$iv = $receiver$iv$iv[i];
                    GrExpression grExpression = it = (GrExpression)element$iv$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)grExpression, (String)"it");
                    Collection<PsiType> collection = this.doGetComponentTypes(grExpression);
                    if (collection == null) {
                        Intrinsics.checkExpressionValueIsNotNull((Object)PsiType.EMPTY_ARRAY, (String)"PsiType.EMPTY_ARRAY");
                        return PsiType.EMPTY_ARRAY;
                    }
                    Iterable list$iv$iv = collection;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                Object thisCollection$iv = $receiver$iv;
                PsiType[] psiTypeArray = thisCollection$iv.toArray(new PsiType[thisCollection$iv.size()]);
                if (psiTypeArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                return psiTypeArray;
            }

            private final Collection<PsiType> doGetComponentTypes(GrExpression initializer) {
                return (Collection)RecursionManager.doPreventingRecursion((Object)initializer, (boolean)false, (Computable)((Computable)new Computable<T>(initializer){
                    final /* synthetic */ GrExpression $initializer;

                    @Nullable
                    public final List<PsiType> compute() {
                        List list;
                        if (this.$initializer instanceof GrSpreadArgument) {
                            PsiType[] psiTypeArray;
                            PsiType psiType = ((GrSpreadArgument)this.$initializer).getArgument().getType();
                            if (!(psiType instanceof GrTupleType)) {
                                psiType = null;
                            }
                            list = (psiTypeArray = (PsiType[])psiType) != null && (psiTypeArray = psiTypeArray.getComponentTypes()) != null ? ArraysKt.toList((Object[])psiTypeArray) : null;
                        } else {
                            PsiType psiType = TypesUtil.boxPrimitiveType(this.$initializer.getType(), this.$initializer.getManager(), this.$initializer.getResolveScope());
                            if (psiType != null) {
                                PsiType psiType2;
                                PsiType it = psiType2 = psiType;
                                list = CollectionsKt.listOf((Object)it);
                            } else {
                                list = null;
                            }
                        }
                        return list;
                    }
                    {
                        this.$initializer = grExpression;
                    }
                }));
            }

            public boolean isValid() {
                boolean bl;
                block1: {
                    Object[] $receiver$iv = this.$initializers;
                    for (int i = 0; i < $receiver$iv.length; ++i) {
                        Object element$iv = $receiver$iv[i];
                        GrExpression it = (GrExpression)element$iv;
                        if (it.isValid()) continue;
                        bl = false;
                        break block1;
                    }
                    bl = true;
                }
                return bl;
            }
            {
                this.$initializers = $captured_local_variable$0;
                this.$expression = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
    }
}

