/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public class MvcProjectWithoutLibraryNotificator
implements StartupActivity,
DumbAware {
    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            MvcProjectWithoutLibraryNotificator.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ProgressIndicatorUtils.scheduleWithWriteActionPriority((ReadTask)new ReadTask(){

            public void computeInReadAction(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project.isDisposed()) {
                    return;
                }
                Pair pair = MvcProjectWithoutLibraryNotificator.findModuleWithoutLibrary(project);
                if (pair == null) {
                    return;
                }
                MvcFramework framework = (MvcFramework)pair.second;
                final Module module = (Module)pair.first;
                String name = framework.getFrameworkName();
                final Map<String, Runnable> actions = framework.createConfigureActions(module);
                StringBuilder content = new StringBuilder().append("<html><body>").append("Module ").append('\'').append(module.getName()).append('\'').append(" has no ").append(name).append(" SDK.");
                if (!actions.isEmpty()) {
                    content.append("<br/>");
                }
                content.append(StringUtil.join(actions.keySet(), actionName -> String.format("<a href='%s'>%s</a>", actionName, actionName), (String)" "));
                content.append("</body></html>");
                new Notification(name + ".Configure", name + " SDK not found", content.toString(), NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

                    protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                        if (notification == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (e == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (module.isDisposed()) {
                            return;
                        }
                        Runnable runnable = (Runnable)actions.get(e.getDescription());
                        assert (runnable != null);
                        runnable.run();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "notification";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "e";
                                break;
                            }
                        }
                        objectArray[1] = "org/jetbrains/plugins/groovy/mvc/MvcProjectWithoutLibraryNotificator$1$1";
                        objectArray[2] = "hyperlinkActivated";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }).notify(project);
            }

            public ReadTask.Continuation runBackgroundProcess(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(1);
                }
                return (ReadTask.Continuation)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return this.performInReadAction(indicator);
                });
            }

            public void onCanceled(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!project.isDisposed()) {
                    ProgressIndicatorUtils.scheduleWithWriteActionPriority((ReadTask)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "indicator";
                objectArray2[1] = "org/jetbrains/plugins/groovy/mvc/MvcProjectWithoutLibraryNotificator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "computeInReadAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runBackgroundProcess";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onCanceled";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$runBackgroundProcess$1";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    private static Pair<Module, MvcFramework> findModuleWithoutLibrary(Project project) {
        MvcFramework[] frameworks = (MvcFramework[])MvcFramework.EP_NAME.getExtensions();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (MvcFramework framework : frameworks) {
                if (!framework.hasFrameworkStructure(module) || framework.hasFrameworkJar(module) || VfsUtil.findRelativeFile((VirtualFile)framework.findAppRoot(module), (String[])new String[]{"application.properties"}) == null) continue;
                return Pair.create((Object)module, (Object)framework);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/mvc/MvcProjectWithoutLibraryNotificator", "runActivity"));
    }
}

