/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.status;

import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.commandLine.SvnExceptionWrapper;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.status.PortableStatus;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.status.StatusConsumer;
import org.jetbrains.idea.svn.status.StatusType;
import org.jetbrains.idea.svn.status.SvnStatusHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CmdStatusClient
extends BaseSvnClient
implements StatusClient {
    @Override
    public long doStatus(@NotNull File path, @Nullable SVNRevision revision, @NotNull Depth depth, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, @NotNull StatusConsumer handler) throws SvnBindException {
        if (path == null) {
            CmdStatusClient.$$$reportNull$$$0(0);
        }
        if (depth == null) {
            CmdStatusClient.$$$reportNull$$$0(1);
        }
        if (handler == null) {
            CmdStatusClient.$$$reportNull$$$0(2);
        }
        File base = CommandUtil.requireExistingParent(path);
        Info infoBase = this.myFactory.createInfoClient().doInfo(base, revision);
        ArrayList parameters = ContainerUtil.newArrayList();
        CmdStatusClient.putParameters(parameters, path, depth, remote, reportAll, includeIgnored);
        CommandExecutor command = this.execute(this.myVcs, SvnTarget.fromFile((File)path), SvnCommandName.st, parameters, null);
        this.parseResult(path, revision, handler, base, infoBase, command);
        return 0L;
    }

    private void parseResult(@NotNull File path, @Nullable SVNRevision revision, @NotNull StatusConsumer handler, @NotNull File base, @Nullable Info infoBase, @NotNull CommandExecutor command) throws SvnBindException {
        String result;
        if (path == null) {
            CmdStatusClient.$$$reportNull$$$0(3);
        }
        if (handler == null) {
            CmdStatusClient.$$$reportNull$$$0(4);
        }
        if (base == null) {
            CmdStatusClient.$$$reportNull$$$0(5);
        }
        if (command == null) {
            CmdStatusClient.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmptyOrSpaces((String)(result = command.getOutput()))) {
            throw new SvnBindException("Status request returned nothing for command: " + command.getCommandText());
        }
        try {
            Ref parsingHandler = Ref.create();
            parsingHandler.set((Object)this.createStatusHandler(revision, handler, base, infoBase, () -> ((SvnStatusHandler)parsingHandler.get()).getPending()));
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse((InputStream)new ByteArrayInputStream(result.trim().getBytes(CharsetToolkit.UTF8_CHARSET)), (DefaultHandler)parsingHandler.get());
            if (!((SvnStatusHandler)parsingHandler.get()).isAnythingReported()) {
                if (!SvnUtil.isSvnVersioned(this.myVcs, path)) {
                    throw new SvnBindException(SVNErrorCode.WC_NOT_DIRECTORY, "Command - " + command.getCommandText() + ". Result - " + result);
                }
                PortableStatus status = new PortableStatus();
                status.setFile(path);
                status.setPath(path.getAbsolutePath());
                status.setContentsStatus(StatusType.STATUS_NORMAL);
                status.setInfoGetter((Getter<Info>)((Getter)() -> {
                    if (path == null) {
                        CmdStatusClient.$$$reportNull$$$0(19);
                    }
                    return (Info)this.createInfoGetter(null).convert((Object)path);
                }));
                handler.consume(status);
            }
        }
        catch (SvnExceptionWrapper e) {
            throw new SvnBindException(e.getCause());
        }
        catch (IOException | ParserConfigurationException e) {
            throw new SvnBindException(e);
        }
        catch (SAXException e) {
            command.logCommand();
            throw new SvnBindException(e);
        }
    }

    private static void putParameters(@NotNull List<String> parameters, @NotNull File path, @Nullable Depth depth, boolean remote, boolean reportAll, boolean includeIgnored) {
        if (parameters == null) {
            CmdStatusClient.$$$reportNull$$$0(7);
        }
        if (path == null) {
            CmdStatusClient.$$$reportNull$$$0(8);
        }
        CommandUtil.put(parameters, path);
        CommandUtil.put(parameters, depth);
        CommandUtil.put(parameters, remote, "-u");
        CommandUtil.put(parameters, reportAll, "--verbose");
        CommandUtil.put(parameters, includeIgnored, "--no-ignore");
        parameters.add("--xml");
    }

    @NotNull
    public SvnStatusHandler createStatusHandler(@Nullable SVNRevision revision, @NotNull StatusConsumer handler, @NotNull File base, @Nullable Info infoBase, @NotNull Supplier<PortableStatus> statusSupplier) {
        if (handler == null) {
            CmdStatusClient.$$$reportNull$$$0(9);
        }
        if (base == null) {
            CmdStatusClient.$$$reportNull$$$0(10);
        }
        if (statusSupplier == null) {
            CmdStatusClient.$$$reportNull$$$0(11);
        }
        SvnStatusHandler.ExternalDataCallback callback = CmdStatusClient.createStatusCallback(handler, base, infoBase, statusSupplier);
        SvnStatusHandler svnStatusHandler = new SvnStatusHandler(callback, base, this.createInfoGetter(revision));
        if (svnStatusHandler == null) {
            CmdStatusClient.$$$reportNull$$$0(12);
        }
        return svnStatusHandler;
    }

    @NotNull
    private Convertor<File, Info> createInfoGetter(@Nullable SVNRevision revision) {
        Convertor convertor = file -> {
            try {
                return this.myFactory.createInfoClient().doInfo((File)file, revision);
            }
            catch (SvnBindException e) {
                throw new SvnExceptionWrapper(e);
            }
        };
        if (convertor == null) {
            CmdStatusClient.$$$reportNull$$$0(13);
        }
        return convertor;
    }

    @NotNull
    public static SvnStatusHandler.ExternalDataCallback createStatusCallback(final @NotNull StatusConsumer handler, final @NotNull File base, final @Nullable Info infoBase, final @NotNull Supplier<PortableStatus> statusSupplier) {
        if (handler == null) {
            CmdStatusClient.$$$reportNull$$$0(14);
        }
        if (base == null) {
            CmdStatusClient.$$$reportNull$$$0(15);
        }
        if (statusSupplier == null) {
            CmdStatusClient.$$$reportNull$$$0(16);
        }
        final HashMap externalsMap = ContainerUtil.newHashMap();
        final Ref changelistName = Ref.create();
        SvnStatusHandler.ExternalDataCallback externalDataCallback = new SvnStatusHandler.ExternalDataCallback(){

            @Override
            public void switchPath() {
                PortableStatus pending = (PortableStatus)statusSupplier.get();
                pending.setChangelistName((String)changelistName.get());
                try {
                    Info baseInfo;
                    File pendingFile = new File(pending.getPath());
                    File externalsBase = (File)ContainerUtil.find(externalsMap.keySet(), file -> FileUtil.isAncestor((File)file, (File)pendingFile, (boolean)false));
                    File baseFile = (File)ObjectUtils.notNull((Object)externalsBase, (Object)base);
                    Info info = baseInfo = externalsBase != null ? (Info)externalsMap.get(externalsBase) : infoBase;
                    if (baseInfo != null) {
                        pending.setURL(pendingFile.isAbsolute() ? SvnUtil.append(baseInfo.getURL(), SvnUtil.getRelativePath(baseFile.getPath(), pending.getPath())) : SvnUtil.append(baseInfo.getURL(), FileUtil.toSystemIndependentName((String)pending.getPath())));
                    }
                    if (StatusType.STATUS_EXTERNAL.equals((Object)pending.getNodeStatus())) {
                        externalsMap.put(pending.getFile(), pending.getInfo());
                    }
                    handler.consume(pending);
                }
                catch (SvnBindException e) {
                    throw new SvnExceptionWrapper(e);
                }
            }

            @Override
            public void switchChangeList(String newList) {
                changelistName.set((Object)newList);
            }
        };
        if (externalDataCallback == null) {
            CmdStatusClient.$$$reportNull$$$0(17);
        }
        return externalDataCallback;
    }

    @Override
    public Status doStatus(@NotNull File path, boolean remote) throws SvnBindException {
        if (path == null) {
            CmdStatusClient.$$$reportNull$$$0(18);
        }
        Ref status = Ref.create();
        this.doStatus(path, SVNRevision.UNDEFINED, Depth.EMPTY, remote, false, false, false, arg_0 -> ((Ref)status).set(arg_0));
        return (Status)status.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depth";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 5: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusSupplier";
                break;
            }
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/status/CmdStatusClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/status/CmdStatusClient";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createStatusHandler";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createInfoGetter";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createStatusCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doStatus";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseResult";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putParameters";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createStatusHandler";
                break;
            }
            case 12: 
            case 13: 
            case 17: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createStatusCallback";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$parseResult$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

