/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importer.colors;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.containers.HashMap;
import java.awt.Color;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.eclipse.importer.colors.EclipseColorThemeElements;
import org.jetbrains.idea.eclipse.importer.colors.EclipseThemeReader;

public class EclipseThemeOptionHandler
implements EclipseThemeReader.OptionHandler,
EclipseColorThemeElements {
    private EditorColorsScheme myColorsScheme;
    private static final Map<String, TextAttributesKey> ECLIPSE_TO_IDEA_ATTR_MAP = new HashMap();

    public EclipseThemeOptionHandler(EditorColorsScheme colorsScheme) {
        this.myColorsScheme = colorsScheme;
    }

    @Override
    public void handleColorOption(@NotNull String name, @NotNull TextAttributes attributes) {
        if (name == null) {
            EclipseThemeOptionHandler.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            EclipseThemeOptionHandler.$$$reportNull$$$0(1);
        }
        if ("background".equals(name)) {
            this.updateAttributes(HighlighterColors.TEXT, attributes);
            this.myColorsScheme.setColor(EditorColors.GUTTER_BACKGROUND, attributes.getBackgroundColor());
            this.myColorsScheme.setColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY, attributes.getBackgroundColor());
        } else if ("foreground".equals(name)) {
            this.updateAttributes(HighlighterColors.TEXT, attributes);
            this.updateAttributes(DefaultLanguageHighlighterColors.IDENTIFIER, attributes);
        } else if ("currentLine".equals(name)) {
            this.myColorsScheme.setColor(EditorColors.CARET_ROW_COLOR, attributes.getForegroundColor());
        } else if ("selectionBackground".equals(name)) {
            this.myColorsScheme.setColor(EditorColors.SELECTION_BACKGROUND_COLOR, attributes.getBackgroundColor());
        } else if ("selectionForeground".equals(name)) {
            this.myColorsScheme.setColor(EditorColors.SELECTION_FOREGROUND_COLOR, attributes.getForegroundColor());
        } else if ("bracket".equals(name)) {
            this.myColorsScheme.setAttributes(DefaultLanguageHighlighterColors.BRACES, attributes);
            this.myColorsScheme.setAttributes(DefaultLanguageHighlighterColors.BRACKETS, attributes);
            this.myColorsScheme.setAttributes(DefaultLanguageHighlighterColors.PARENTHESES, attributes);
        } else if ("operator".equals(name)) {
            this.myColorsScheme.setAttributes(DefaultLanguageHighlighterColors.OPERATION_SIGN, attributes);
            this.myColorsScheme.setAttributes(DefaultLanguageHighlighterColors.COMMA, attributes);
            this.myColorsScheme.setAttributes(DefaultLanguageHighlighterColors.SEMICOLON, attributes);
            this.myColorsScheme.setAttributes(DefaultLanguageHighlighterColors.DOT, attributes);
        } else if ("lineNumber".equals(name)) {
            Color lineNumberColor = attributes.getForegroundColor();
            this.myColorsScheme.setColor(EditorColors.LINE_NUMBERS_COLOR, lineNumberColor);
            this.myColorsScheme.setColor(EditorColors.TEARLINE_COLOR, lineNumberColor);
            this.myColorsScheme.setColor(EditorColors.RIGHT_MARGIN_COLOR, lineNumberColor);
            this.myColorsScheme.setColor(EditorColors.CARET_COLOR, lineNumberColor);
        } else if ("localVariable".equals(name)) {
            this.myColorsScheme.setAttributes(DefaultLanguageHighlighterColors.LOCAL_VARIABLE, attributes);
            this.myColorsScheme.setAttributes(DefaultLanguageHighlighterColors.MARKUP_TAG, attributes);
        } else if ("localVariableDeclaration".equals(name)) {
            this.myColorsScheme.setAttributes(XmlHighlighterColors.HTML_TAG_NAME, attributes);
            this.myColorsScheme.setAttributes(XmlHighlighterColors.XML_TAG_NAME, attributes);
        } else if ("field".equals(name)) {
            this.myColorsScheme.setAttributes(DefaultLanguageHighlighterColors.INSTANCE_FIELD, attributes);
            this.myColorsScheme.setAttributes(XmlHighlighterColors.XML_ATTRIBUTE_NAME, attributes);
            this.myColorsScheme.setAttributes(XmlHighlighterColors.HTML_ATTRIBUTE_NAME, attributes);
        } else if ("occurrenceIndication".equals(name)) {
            this.myColorsScheme.setAttributes(EditorColors.IDENTIFIER_UNDER_CARET_ATTRIBUTES, EclipseThemeOptionHandler.toBackgroundAttributes(attributes));
        } else if ("writeOccurrenceIndication".equals(name)) {
            this.myColorsScheme.setAttributes(EditorColors.WRITE_IDENTIFIER_UNDER_CARET_ATTRIBUTES, EclipseThemeOptionHandler.toBackgroundAttributes(attributes));
        } else if ("searchResultIndication".equals(name)) {
            this.myColorsScheme.setAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES, EclipseThemeOptionHandler.toBackgroundAttributes(attributes));
        } else if ("filteredSearchResultIndication".equals(name)) {
            this.myColorsScheme.setAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES, EclipseThemeOptionHandler.toBackgroundAttributes(attributes));
        } else if ("string".equals(name)) {
            this.myColorsScheme.setAttributes(DefaultLanguageHighlighterColors.STRING, attributes);
            TextAttributes validEscapeAttrs = attributes.clone();
            validEscapeAttrs.setFontType(1);
            this.myColorsScheme.setAttributes(DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE, validEscapeAttrs);
        } else if ("keyword".equals(name)) {
            this.myColorsScheme.setAttributes(DefaultLanguageHighlighterColors.KEYWORD, attributes);
            this.myColorsScheme.setAttributes(DefaultLanguageHighlighterColors.MARKUP_ENTITY, attributes);
        } else if (ECLIPSE_TO_IDEA_ATTR_MAP.containsKey(name)) {
            this.myColorsScheme.setAttributes(ECLIPSE_TO_IDEA_ATTR_MAP.get(name), attributes);
        }
    }

    private void updateAttributes(@NotNull TextAttributesKey key, @NotNull TextAttributes attributes) {
        TextAttributes alreadyDefined;
        if (key == null) {
            EclipseThemeOptionHandler.$$$reportNull$$$0(2);
        }
        if (attributes == null) {
            EclipseThemeOptionHandler.$$$reportNull$$$0(3);
        }
        if (this.myColorsScheme instanceof AbstractColorsScheme && (alreadyDefined = ((AbstractColorsScheme)this.myColorsScheme).getDirectlyDefinedAttributes(key)) != null) {
            if (attributes.getForegroundColor() != null) {
                alreadyDefined.setForegroundColor(attributes.getForegroundColor());
            }
            if (attributes.getBackgroundColor() != null) {
                alreadyDefined.setBackgroundColor(attributes.getBackgroundColor());
            }
            return;
        }
        this.myColorsScheme.setAttributes(key, attributes);
    }

    private static TextAttributes toBackgroundAttributes(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            EclipseThemeOptionHandler.$$$reportNull$$$0(4);
        }
        TextAttributes backgroundAttrs = attributes.clone();
        backgroundAttrs.setBackgroundColor(attributes.getForegroundColor());
        backgroundAttrs.setForegroundColor(null);
        return backgroundAttrs;
    }

    static {
        ECLIPSE_TO_IDEA_ATTR_MAP.put("singleLineComment", DefaultLanguageHighlighterColors.LINE_COMMENT);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("multiLineComment", DefaultLanguageHighlighterColors.BLOCK_COMMENT);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("javadoc", DefaultLanguageHighlighterColors.DOC_COMMENT);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("javadocTag", DefaultLanguageHighlighterColors.DOC_COMMENT_MARKUP);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("javadocKeyword", DefaultLanguageHighlighterColors.DOC_COMMENT_TAG);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("class", DefaultLanguageHighlighterColors.CLASS_NAME);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("interface", DefaultLanguageHighlighterColors.INTERFACE_NAME);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("method", DefaultLanguageHighlighterColors.FUNCTION_CALL);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("methodDeclaration", DefaultLanguageHighlighterColors.FUNCTION_DECLARATION);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("number", DefaultLanguageHighlighterColors.NUMBER);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("annotation", DefaultLanguageHighlighterColors.METADATA);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("staticMethod", DefaultLanguageHighlighterColors.STATIC_METHOD);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("staticField", DefaultLanguageHighlighterColors.STATIC_FIELD);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("parameterVariable", DefaultLanguageHighlighterColors.PARAMETER);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("constant", DefaultLanguageHighlighterColors.CONSTANT);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("commentTaskTag", CodeInsightColors.TODO_DEFAULT_ATTRIBUTES);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("typeArgument", JavaHighlightingColors.TYPE_PARAMETER_NAME_ATTRIBUTES);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("enum", JavaHighlightingColors.ENUM_NAME_ATTRIBUTES);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("inheritedMethod", JavaHighlightingColors.INHERITED_METHOD_ATTRIBUTES);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("abstractMethod", JavaHighlightingColors.ABSTRACT_METHOD_ATTRIBUTES);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("staticFinalField", JavaHighlightingColors.STATIC_FINAL_FIELD_ATTRIBUTES);
        ECLIPSE_TO_IDEA_ATTR_MAP.put("deprecatedMember", CodeInsightColors.DEPRECATED_ATTRIBUTES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/eclipse/importer/colors/EclipseThemeOptionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleColorOption";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "toBackgroundAttributes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

