/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.CreateFileAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.xml.XmlFile;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.module.PluginModuleType;

public final class DevkitActionsUtil {
    private static final Logger LOG = Logger.getInstance(DevkitActionsUtil.class);

    private DevkitActionsUtil() {
    }

    @Nullable
    public static XmlFile choosePluginModuleDescriptor(PsiDirectory directory) {
        Project project = directory.getProject();
        Module module = DevkitActionsUtil.getModule(directory);
        XmlFile currentModulePluginXml = PluginModuleType.getPluginXml(module);
        if (currentModulePluginXml != null) {
            return currentModulePluginXml;
        }
        if (module != null) {
            List<Module> candidateModules = PluginModuleType.getCandidateModules(module);
            Iterator<Module> it = candidateModules.iterator();
            while (it.hasNext()) {
                Module m = it.next();
                if (PluginModuleType.getPluginXml(m) != null) continue;
                it.remove();
            }
            if (candidateModules.size() == 1) {
                return PluginModuleType.getPluginXml(candidateModules.get(0));
            }
            ChoosePluginModuleDialog chooseModulesDialog = new ChoosePluginModuleDialog(project, candidateModules, DevKitBundle.message("select.plugin.module.to.patch", new Object[0]), null);
            chooseModulesDialog.setSingleSelectionMode();
            chooseModulesDialog.show();
            List selectedModules = chooseModulesDialog.getChosenElements();
            if (selectedModules.isEmpty()) {
                return null;
            }
            assert (selectedModules.size() == 1);
            XmlFile pluginXml = PluginModuleType.getPluginXml((Module)selectedModules.get(0));
            if (pluginXml != null) {
                return pluginXml;
            }
        }
        Messages.showMessageDialog((Project)project, (String)DevKitBundle.message("error.no.plugin.xml", new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        return null;
    }

    public static PsiClass createSingleClass(String name, String classTemplateName, PsiDirectory directory) {
        return DevkitActionsUtil.createSingleClass(name, classTemplateName, directory, Collections.emptyMap());
    }

    public static PsiClass createSingleClass(String name, String classTemplateName, PsiDirectory directory, @NotNull Map<String, String> properties) {
        if (properties == null) {
            DevkitActionsUtil.$$$reportNull$$$0(0);
        }
        if (name.contains(".")) {
            String[] names = name.split("\\.");
            for (int i = 0; i < names.length - 1; ++i) {
                directory = CreateFileAction.findOrCreateSubdirectory((PsiDirectory)directory, (String)names[i]);
            }
            name = names[names.length - 1];
        }
        return JavaDirectoryService.getInstance().createClass(directory, name, classTemplateName, false, properties);
    }

    @Nullable
    private static Module getModule(PsiDirectory dir) {
        VirtualFile vFile;
        Project project = dir.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (fileIndex.isInLibrarySource(vFile = dir.getVirtualFile()) || fileIndex.isInLibraryClasses(vFile)) {
            List orderEntries = fileIndex.getOrderEntriesForFile(vFile);
            if (orderEntries.isEmpty()) {
                return null;
            }
            HashSet<Module> modules = new HashSet<Module>();
            for (OrderEntry orderEntry : orderEntries) {
                modules.add(orderEntry.getOwnerModule());
            }
            Module[] candidates = modules.toArray(new Module[modules.size()]);
            Arrays.sort(candidates, ModuleManager.getInstance((Project)project).moduleDependencyComparator());
            return candidates[0];
        }
        return fileIndex.getModuleForFile(vFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/idea/devkit/actions/DevkitActionsUtil", "createSingleClass"));
    }

    private static class ChoosePluginModuleDialog
    extends ChooseModulesDialog {
        public ChoosePluginModuleDialog(Project project, List<? extends Module> items, String title, @Nullable String description) {
            super(project, items, title, description);
        }

        protected String getItemLocation(Module item) {
            XmlFile pluginXml = PluginModuleType.getPluginXml(item);
            if (pluginXml == null) {
                return null;
            }
            VirtualFile virtualFile = pluginXml.getVirtualFile();
            VirtualFile projectPath = item.getProject().getBaseDir();
            boolean shouldReturnNull = false;
            if (virtualFile == null) {
                LOG.warn("Unexpected null plugin.xml VirtualFile for module: " + item);
                shouldReturnNull = true;
            }
            if (projectPath == null) {
                LOG.warn("Unexpected null project basedir VirtualFile for module: " + item);
                shouldReturnNull = true;
            }
            if (shouldReturnNull) {
                return null;
            }
            if (VfsUtilCore.isAncestor((VirtualFile)projectPath, (VirtualFile)virtualFile, (boolean)false)) {
                return VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)projectPath, (char)File.separatorChar);
            }
            return virtualFile.getPresentableUrl();
        }
    }
}

