/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;

public class QuickFixGetFamilyNameViolationInspection
extends DevKitInspectionBase {
    private static final Logger LOG = Logger.getInstance(QuickFixGetFamilyNameViolationInspection.class);
    private static final Set<String> BASE_CONTEXT_AWARE_CLASSES = ContainerUtil.newHashSet((Object[])new String[]{PsiElement.class.getName(), Navigatable.class.getName(), AreaInstance.class.getName(), VirtualFile.class.getName()});

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiClass aClass;
        if (method == null) {
            QuickFixGetFamilyNameViolationInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            QuickFixGetFamilyNameViolationInspection.$$$reportNull$$$0(1);
        }
        if ("getFamilyName".equals(method.getName()) && method.getParameterList().getParametersCount() == 0 && !method.hasModifierProperty("abstract") && InheritanceUtil.isInheritor((PsiClass)(aClass = method.getContainingClass()), (String)QuickFix.class.getName()) && QuickFixGetFamilyNameViolationInspection.doesMethodViolate(method, (Set<PsiMethod>)new THashSet())) {
            PsiIdentifier identifier = method.getNameIdentifier();
            LOG.assertTrue(identifier != null);
            return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)identifier, "QuickFix's getFamilyName() implementation must not depend on a specific context", (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true)};
        }
        return null;
    }

    private static boolean doesMethodViolate(PsiMethod method, Set<PsiMethod> processed) {
        if (!processed.add(method) || method.hasModifierProperty("static")) {
            return false;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return false;
        }
        if (QuickFixGetFamilyNameViolationInspection.isContextDependentType(method.getReturnType())) {
            return true;
        }
        Collection referenceIterator = PsiTreeUtil.findChildrenOfType((PsiElement)body, PsiJavaCodeReferenceElement.class);
        for (PsiJavaCodeReferenceElement reference : referenceIterator) {
            PsiElement resolved = reference.resolve();
            if (resolved instanceof PsiVariable && (!(resolved instanceof PsiField) || !((PsiField)resolved).hasModifierProperty("static")) && QuickFixGetFamilyNameViolationInspection.isContextDependentType(((PsiVariable)resolved).getType())) {
                return true;
            }
            if (!(resolved instanceof PsiMethod)) continue;
            PsiMethod resolvedMethod = (PsiMethod)resolved;
            PsiClass resolvedContainingClass = resolvedMethod.getContainingClass();
            PsiClass methodContainingClass = method.getContainingClass();
            if (resolvedContainingClass == null || methodContainingClass == null || methodContainingClass != resolvedContainingClass && !methodContainingClass.isInheritor(resolvedContainingClass, true) || !QuickFixGetFamilyNameViolationInspection.doesMethodViolate(resolvedMethod, processed)) continue;
            return true;
        }
        return false;
    }

    private static boolean isContextDependentType(@Nullable PsiType type) {
        if (type == null) {
            return false;
        }
        for (String aClass : BASE_CONTEXT_AWARE_CLASSES) {
            if (!InheritanceUtil.isInheritor((PsiType)type, (String)aClass)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "method";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/inspections/QuickFixGetFamilyNameViolationInspection";
        objectArray[2] = "checkMethod";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

