/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.uast.UastVisitorAdapter;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class UndesirableClassUsageInspection
extends DevKitUastInspectionBase {
    private static final Map<String, String> CLASSES = ContainerUtil.immutableMapBuilder().put((Object)JList.class.getName(), (Object)JBList.class.getName()).put((Object)JTable.class.getName(), (Object)JBTable.class.getName()).put((Object)JTree.class.getName(), (Object)Tree.class.getName()).put((Object)JScrollPane.class.getName(), (Object)JBScrollPane.class.getName()).put((Object)JTabbedPane.class.getName(), (Object)JBTabbedPane.class.getName()).put((Object)JComboBox.class.getName(), (Object)ComboBox.class.getName()).put((Object)QueryExecutor.class.getName(), (Object)QueryExecutorBase.class.getName()).put((Object)BufferedImage.class.getName(), (Object)"UIUtil.createImage()").build();

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UndesirableClassUsageInspection.$$$reportNull$$$0(0);
        }
        UastVisitorAdapter uastVisitorAdapter = new UastVisitorAdapter((UastVisitor)new AbstractUastVisitor(){

            public boolean visitCallExpression(@NotNull UCallExpression expression) {
                PsiClass psiClass;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (expression.getKind() == UastCallKind.CONSTRUCTOR_CALL && (psiClass = PsiTypesUtil.getPsiClass((PsiType)expression.getReturnType())) != null) {
                    String name = psiClass.getQualifiedName();
                    String replacement = (String)CLASSES.get(name);
                    if (replacement != null) {
                        holder.registerProblem((PsiElement)ObjectUtils.assertNotNull((Object)expression.getPsi()), "Please use '" + replacement + "' instead", ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/idea/devkit/inspections/internal/UndesirableClassUsageInspection$1", "visitCallExpression"));
            }
        });
        if (uastVisitorAdapter == null) {
            UndesirableClassUsageInspection.$$$reportNull$$$0(1);
        }
        return uastVisitorAdapter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/UndesirableClassUsageInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UndesirableClassUsageInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInternalVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildInternalVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

