/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.ArgsInfoImpl;
import org.jetbrains.kotlin.gradle.KotlinGradleModel;
import org.jetbrains.kotlin.gradle.KotlinGradleModelImpl;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0003J\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015*\u00020\u0016H\u0002J\f\u0010\u0019\u001a\u00020\u0006*\u00020\u0016H\u0002J\u0014\u0010\u001a\u001a\n \u001b*\u0004\u0018\u00010\u00060\u0006*\u00020\bH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/gradle/KotlinGradleModelBuilder;", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderService;", "()V", "buildAll", "Lorg/jetbrains/kotlin/gradle/KotlinGradleModelImpl;", "modelName", "", "project", "Lorg/gradle/api/Project;", "canBuild", "", "getCoroutines", "getErrorMessageBuilder", "Lorg/jetbrains/plugins/gradle/tooling/ErrorMessageBuilder;", "e", "Ljava/lang/Exception;", "getImplements", "transitiveCommonDependencies", "", "startingProject", "getCompilerArguments", "", "Lorg/gradle/api/Task;", "methodName", "getDependencyClasspath", "getSourceSetName", "pathOrName", "kotlin.jvm.PlatformType", "Companion", "kotlin-gradle-tooling"})
public final class KotlinGradleModelBuilder
implements ModelBuilderService {
    @NotNull
    private static final List<String> kotlinCompileTaskClasses;
    @NotNull
    private static final List<String> platformPluginIds;
    @NotNull
    private static final LinkedHashMap<String, String> pluginToPlatform;
    @NotNull
    private static final List<String> kotlinPluginIds;
    private static final String kotlinPlatformCommonPluginId = "kotlin-platform-common";
    private static final String ABSTRACT_KOTLIN_COMPILE_CLASS = "org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile";
    public static final Companion Companion;

    @NotNull
    public ErrorMessageBuilder getErrorMessageBuilder(@NotNull Project project, @NotNull Exception e) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        ErrorMessageBuilder errorMessageBuilder = ErrorMessageBuilder.create((Project)project, (Exception)e, (String)"Gradle import errors").withDescription("Unable to build Kotlin project configuration");
        Intrinsics.checkExpressionValueIsNotNull((Object)errorMessageBuilder, (String)"ErrorMessageBuilder.crea\u2026n project configuration\")");
        return errorMessageBuilder;
    }

    public boolean canBuild(@Nullable String modelName) {
        return Intrinsics.areEqual((Object)modelName, (Object)KotlinGradleModel.class.getName());
    }

    /*
     * WARNING - void declaration
     */
    private final Project getImplements(Project project) {
        ProjectDependency implementsProjectDependency;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Configuration configuration = (Configuration)project.getConfigurations().findByName("implement");
        if (configuration == null) {
            return null;
        }
        Configuration implementsConfiguration = configuration;
        Iterable iterable = $receiver$iv = (Iterable)implementsConfiguration.getDependencies();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof ProjectDependency)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ProjectDependency projectDependency = implementsProjectDependency = (ProjectDependency)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        return projectDependency != null ? projectDependency.getDependencyProject() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> transitiveCommonDependencies(Project startingProject) {
        Collection collection;
        LinkedList<Project> toProcess = new LinkedList<Project>();
        toProcess.add(startingProject);
        HashSet<String> processed = new HashSet<String>();
        HashSet<String> result = new HashSet<String>();
        result.add(this.pathOrName(startingProject));
        while (!(collection = (Collection)toProcess).isEmpty()) {
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Configuration compileConfiguration;
            Project project = (Project)toProcess.pollFirst();
            processed.add(project.getPath());
            if (!project.getPlugins().hasPlugin(KotlinGradleModelBuilder.Companion.getKotlinPlatformCommonPluginId())) continue;
            result.add(this.pathOrName(project));
            if ((Configuration)project.getConfigurations().findByName("compile") == null) {
                continue;
            }
            Iterable iterable = (Iterable)compileConfiguration.getDependencies();
            Iterator iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof ProjectDependency)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ProjectDependency $i$f$filterIsInstanceTo = (ProjectDependency)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                Project project2 = it.getDependencyProject();
                collection2.add(project2);
            }
            List dependencies = (List)destination$iv$iv;
            for (Project dep : dependencies) {
                if (processed.contains(dep.getPath())) continue;
                toProcess.add(dep);
            }
        }
        return result;
    }

    private final String pathOrName(@NotNull Project $receiver) {
        return Intrinsics.areEqual((Object)$receiver.getPath(), (Object)":") ? $receiver.getName() : $receiver.getPath();
    }

    private final List<String> getCompilerArguments(@NotNull Task $receiver, String methodName) {
        List list;
        try {
            Object object = $receiver.getClass().getDeclaredMethod(methodName, new Class[0]).invoke((Object)$receiver, new Object[0]);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
            }
            list = (List)object;
        }
        catch (NoSuchMethodException e) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getDependencyClasspath(@NotNull Task $receiver) {
        try {
            void $receiver$iv$iv;
            Class<?> abstractKotlinCompileClass = $receiver.getClass().getClassLoader().loadClass(KotlinGradleModelBuilder.Companion.getABSTRACT_KOTLIN_COMPILE_CLASS());
            Method method = abstractKotlinCompileClass.getDeclaredMethod("getCompileClasspath", new Class[0]);
            Object $receiver2 = method;
            ((Method)$receiver2).setAccessible(true);
            Method getCompileClasspath = method;
            Object object = getCompileClasspath.invoke((Object)$receiver, new Object[0]);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<java.io.File>");
            }
            Iterable $receiver$iv = (Collection)object;
            $receiver2 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string = it.getPath();
                collection.add(string);
            }
            return (List)destination$iv$iv;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return CollectionsKt.emptyList();
    }

    private final String getCoroutines(Project project) {
        Object object;
        Object object2 = project.getExtensions().findByName("kotlin");
        if (object2 == null) {
            return null;
        }
        Object kotlinExtension = object2;
        try {
            object = kotlinExtension.getClass().getMethod("getExperimental", new Class[0]).invoke(kotlinExtension, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        Object experimentalExtension = object;
        try {
            Object object3 = experimentalExtension.getClass().getMethod("getCoroutines", new Class[0]).invoke(experimentalExtension, new Object[0]);
            object = object3 != null ? object3.toString() : null;
        }
        catch (NoSuchMethodException e) {
            object = null;
        }
        return object;
    }

    private final String getSourceSetName(@NotNull Task $receiver) {
        String string;
        String string2;
        try {
            Object object;
            block5: {
                Object[] $receiver$iv = $receiver.getClass().getMethods();
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object[] objectArray;
                    Object element$iv = $receiver$iv[i];
                    Method it = (Method)element$iv;
                    if (!(StringsKt.startsWith$default((String)it.getName(), (String)"getSourceSetName", (boolean)false, (int)2, null) && (objectArray = (Object[])it.getParameterTypes()).length == 0)) continue;
                    object = element$iv;
                    break block5;
                }
                object = null;
            }
            Method method = (Method)object;
            Object object2 = method != null ? method.invoke((Object)$receiver, new Object[0]) : null;
            if (!(object2 instanceof String)) {
                object2 = null;
            }
            string2 = (String)object2;
        }
        catch (InvocationTargetException e) {
            string2 = null;
        }
        if ((string = string2) == null) {
            string = "main";
        }
        return string;
    }

    @NotNull
    public KotlinGradleModelImpl buildAll(@Nullable String modelName, @NotNull Project project) {
        Project project2;
        Project it;
        Object object;
        String platform;
        String string;
        Object v1;
        String kotlinPluginId;
        block11: {
            Object v0;
            block10: {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Iterable $receiver$iv = Companion.getKotlinPluginIds();
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $receiver$iv) {
                    String it2 = (String)element$iv;
                    if (!(project.getPlugins().findPlugin(it2) != null)) continue;
                    if (found$iv) {
                        v0 = null;
                        break block10;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            kotlinPluginId = v0;
            Iterable $receiver$iv = Companion.getPlatformPluginIds();
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv) {
                String it3 = (String)element$iv;
                if (!(project.getPlugins().findPlugin(it3) != null)) continue;
                if (found$iv) {
                    v1 = null;
                    break block11;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        String platformPluginId = v1;
        LinkedHashMap compilerArgumentsBySourceSet = new LinkedHashMap();
        Set set = (Set)project.getAllTasks(false).get(project);
        if (set != null) {
            Iterable $receiver$iv = set;
            for (Object element$iv : $receiver$iv) {
                Task compileTask = (Task)element$iv;
                if (!Companion.getKotlinCompileTaskClasses().contains(compileTask.getClass().getName())) continue;
                String sourceSetName = this.getSourceSetName(compileTask);
                List<String> currentArguments = this.getCompilerArguments(compileTask, "getSerializedCompilerArguments");
                List<String> defaultArguments = this.getCompilerArguments(compileTask, "getDefaultSerializedCompilerArguments");
                List<String> dependencyClasspath = this.getDependencyClasspath(compileTask);
                Map map = compilerArgumentsBySourceSet;
                ArgsInfoImpl argsInfoImpl = new ArgsInfoImpl(currentArguments, defaultArguments, dependencyClasspath);
                map.put(sourceSetName, argsInfoImpl);
            }
        }
        if ((string = platformPluginId) == null) {
            Object v4;
            block12: {
                Iterable $receiver$iv = Companion.getPluginToPlatform().entrySet();
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $receiver$iv) {
                    Map.Entry it4 = (Map.Entry)element$iv;
                    if (!(project.getPlugins().findPlugin((String)it4.getKey()) != null)) continue;
                    if (found$iv) {
                        v4 = null;
                        break block12;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v4 = !found$iv ? null : single$iv;
            }
            Map.Entry entry = v4;
            string = platform = entry != null ? (String)entry.getValue() : null;
        }
        if ((object = this.getImplements(project)) == null || (object = this.transitiveCommonDependencies(it = (project2 = object))) == null) {
            object = SetsKt.emptySet();
        }
        Object transitiveCommon = object;
        return new KotlinGradleModelImpl(kotlinPluginId != null || platformPluginId != null, compilerArgumentsBySourceSet, this.getCoroutines(project), platform, (Set<String>)transitiveCommon);
    }

    static {
        Companion = new Companion(null);
        kotlinCompileTaskClasses = CollectionsKt.listOf((Object[])new String[]{"org.jetbrains.kotlin.gradle.tasks.KotlinCompile_Decorated", "org.jetbrains.kotlin.gradle.tasks.Kotlin2JsCompile_Decorated"});
        platformPluginIds = CollectionsKt.listOf((Object[])new String[]{"kotlin-platform-jvm", "kotlin-platform-js", kotlinPlatformCommonPluginId});
        pluginToPlatform = MapsKt.linkedMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"kotlin", (Object)"kotlin-platform-jvm"), TuplesKt.to((Object)"kotlin2js", (Object)"kotlin-platform-js")});
        kotlinPluginIds = CollectionsKt.listOf((Object[])new String[]{"kotlin", "kotlin2js", "kotlin-android"});
        kotlinPlatformCommonPluginId = kotlinPlatformCommonPluginId;
        ABSTRACT_KOTLIN_COMPILE_CLASS = ABSTRACT_KOTLIN_COMPILE_CLASS;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR-\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0012j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/KotlinGradleModelBuilder$Companion;", "", "()V", "ABSTRACT_KOTLIN_COMPILE_CLASS", "", "getABSTRACT_KOTLIN_COMPILE_CLASS", "()Ljava/lang/String;", "kotlinCompileTaskClasses", "", "getKotlinCompileTaskClasses", "()Ljava/util/List;", "kotlinPlatformCommonPluginId", "getKotlinPlatformCommonPluginId", "kotlinPluginIds", "getKotlinPluginIds", "platformPluginIds", "getPlatformPluginIds", "pluginToPlatform", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "getPluginToPlatform", "()Ljava/util/LinkedHashMap;", "kotlin-gradle-tooling"})
    public static final class Companion {
        @NotNull
        public final List<String> getKotlinCompileTaskClasses() {
            return kotlinCompileTaskClasses;
        }

        @NotNull
        public final List<String> getPlatformPluginIds() {
            return platformPluginIds;
        }

        @NotNull
        public final LinkedHashMap<String, String> getPluginToPlatform() {
            return pluginToPlatform;
        }

        @NotNull
        public final List<String> getKotlinPluginIds() {
            return kotlinPluginIds;
        }

        private final String getKotlinPlatformCommonPluginId() {
            return kotlinPlatformCommonPluginId;
        }

        private final String getABSTRACT_KOTLIN_COMPILE_CLASS() {
            return ABSTRACT_KOTLIN_COMPILE_CLASS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

