/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.atomic;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemoveObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemovePropertyJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNode;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;

public class RemoveNodeJob
extends Job {
    private final Job subJob;

    public RemoveNodeJob(FXOMNode targetNode, EditorController editorController) {
        super(editorController);
        assert (targetNode instanceof FXOMObject || targetNode instanceof FXOMProperty);
        if (targetNode instanceof FXOMObject) {
            this.subJob = new RemoveObjectJob((FXOMObject)targetNode, editorController);
        } else {
            assert (targetNode instanceof FXOMProperty);
            this.subJob = new RemovePropertyJob((FXOMProperty)targetNode, editorController);
        }
    }

    @Override
    public boolean isExecutable() {
        return this.subJob.isExecutable();
    }

    @Override
    public void execute() {
        this.subJob.execute();
    }

    @Override
    public void undo() {
        this.subJob.undo();
    }

    @Override
    public void redo() {
        this.subJob.redo();
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName();
    }
}

