/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.psi.impl;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.streams.psi.DebuggerPositionResolver;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XDebugSession;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerPositionResolverImpl
implements DebuggerPositionResolver {
    @Override
    @Nullable
    public PsiElement getNearestElementToBreakpoint(@NotNull XDebugSession session) {
        Document document;
        if (session == null) {
            DebuggerPositionResolverImpl.$$$reportNull$$$0(0);
        }
        Project project = session.getProject();
        DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx((Project)session.getProject()).getContext();
        SourcePosition position = debuggerContext.getSourcePosition();
        if (position == null) {
            return null;
        }
        int line = position.getLine();
        PsiFile psiFile = position.getFile();
        VirtualFile file = psiFile.getVirtualFile();
        if (line >= 0 && file != null && (document = FileDocumentManager.getInstance().getDocument(file)) != null && line < document.getLineCount()) {
            int offset = document.getLineStartOffset(line);
            return DebuggerUtilsEx.findElementAt((PsiFile)PsiDocumentManager.getInstance((Project)project).getPsiFile(document), (int)offset);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/debugger/streams/psi/impl/DebuggerPositionResolverImpl", "getNearestElementToBreakpoint"));
    }
}

