/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.psi.impl;

import com.intellij.debugger.streams.psi.ChainTransformer;
import com.intellij.debugger.streams.psi.PsiUtil;
import com.intellij.debugger.streams.psi.StreamApiUtil;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.StreamChainBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifiableCodeBlock;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStreamChainBuilder
implements StreamChainBuilder {
    private final MyStreamChainExistenceChecker myExistenceChecker;
    private final ChainTransformer.Java myChainTransformer;
    @NotNull
    private final String mySupportedPackage;

    public JavaStreamChainBuilder(@NotNull ChainTransformer.Java transformer, @NotNull String supportedPackage) {
        if (transformer == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(0);
        }
        if (supportedPackage == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(1);
        }
        this.myExistenceChecker = new MyStreamChainExistenceChecker();
        this.myChainTransformer = transformer;
        this.mySupportedPackage = supportedPackage;
    }

    @Override
    public boolean isChainExists(@NotNull PsiElement startElement) {
        if (startElement == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(2);
        }
        PsiElement current = JavaStreamChainBuilder.getLatestElementInCurrentScope(PsiUtil.ignoreWhiteSpaces(startElement));
        while (current != null) {
            this.myExistenceChecker.reset();
            current.accept((PsiElementVisitor)this.myExistenceChecker);
            if (this.myExistenceChecker.found()) {
                return true;
            }
            current = JavaStreamChainBuilder.toUpperLevel(current);
        }
        return false;
    }

    @Override
    @NotNull
    public List<StreamChain> build(@NotNull PsiElement startElement) {
        if (startElement == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(3);
        }
        MyChainCollectorVisitor visitor2 = new MyChainCollectorVisitor();
        PsiElement current = JavaStreamChainBuilder.getLatestElementInCurrentScope(PsiUtil.ignoreWhiteSpaces(startElement));
        while (current != null) {
            current.accept((PsiElementVisitor)visitor2);
            current = JavaStreamChainBuilder.toUpperLevel(current);
        }
        List<List<PsiMethodCallExpression>> chains = visitor2.getPsiChains();
        List<StreamChain> list2 = this.buildChains(chains, startElement);
        if (list2 == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Nullable
    private static PsiElement toUpperLevel(@NotNull PsiElement element) {
        if (element == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(5);
        }
        for (element = element.getParent(); element != null && !(element instanceof PsiLambdaExpression) && !(element instanceof PsiAnonymousClass); element = element.getParent()) {
        }
        return JavaStreamChainBuilder.getLatestElementInCurrentScope(element);
    }

    @Nullable
    @Contract(value="null -> null")
    private static PsiElement getLatestElementInCurrentScope(@Nullable PsiElement element) {
        PsiElement parent;
        PsiElement current = element;
        while (!(current == null || (parent = current.getParent()) instanceof PsiModifiableCodeBlock || parent instanceof PsiLambdaExpression || parent instanceof PsiStatement)) {
            current = parent;
        }
        return current;
    }

    @NotNull
    private List<StreamChain> buildChains(@NotNull List<List<PsiMethodCallExpression>> chains, @NotNull PsiElement context) {
        if (chains == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(6);
        }
        if (context == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(7);
        }
        List<StreamChain> list2 = chains.stream().map(x -> {
            if (context == null) {
                JavaStreamChainBuilder.$$$reportNull$$$0(13);
            }
            return this.myChainTransformer.transform(x, context);
        }).collect(Collectors.toList());
        if (list2 == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private boolean isPackageSupported(@NotNull String packageName) {
        if (packageName == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(9);
        }
        return packageName.startsWith(this.mySupportedPackage);
    }

    @NotNull
    private static String getPackageName(@NotNull PsiMethodCallExpression expression) {
        PsiClass psiClass;
        String className;
        PsiMethod psiMethod;
        if (expression == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(10);
        }
        if ((psiMethod = expression.resolveMethod()) != null && (className = (psiClass = (PsiClass)psiMethod.getParent()).getQualifiedName()) != null) {
            String string = StringUtil.getPackageName((String)className);
            if (string == null) {
                JavaStreamChainBuilder.$$$reportNull$$$0(11);
            }
            return string;
        }
        if ("" == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(12);
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedPackage";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/psi/impl/JavaStreamChainBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chains";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/psi/impl/JavaStreamChainBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChains";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isChainExists";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toUpperLevel";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildChains";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPackageSupported";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildChains$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyVisitorBase
    extends JavaRecursiveElementVisitor {
        private MyVisitorBase() {
        }

        public void visitCodeBlock(PsiCodeBlock block2) {
        }

        public void visitLambdaExpression(PsiLambdaExpression expression) {
        }
    }

    private static class MyChainCollectorVisitor
    extends MyVisitorBase {
        private final Set<PsiMethodCallExpression> myTerminationCalls = new HashSet<PsiMethodCallExpression>();
        private final Map<PsiMethodCallExpression, PsiMethodCallExpression> myPreviousCalls = new HashMap<PsiMethodCallExpression, PsiMethodCallExpression>();

        private MyChainCollectorVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            if (!this.myPreviousCalls.containsKey(expression) && StreamApiUtil.isStreamCall(expression)) {
                this.updateCallTree(expression);
            }
        }

        private void updateCallTree(@NotNull PsiMethodCallExpression expression) {
            PsiElement parent;
            if (expression == null) {
                MyChainCollectorVisitor.$$$reportNull$$$0(0);
            }
            if (StreamApiUtil.isTerminationStreamCall(expression)) {
                this.myTerminationCalls.add(expression);
            }
            if ((parent = expression.getParent()) == null || !(parent instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement parentCall = parent.getParent();
            if (parentCall instanceof PsiMethodCallExpression && StreamApiUtil.isStreamCall((PsiMethodCallExpression)parentCall)) {
                PsiMethodCallExpression parentCallExpression = (PsiMethodCallExpression)parentCall;
                this.myPreviousCalls.put(parentCallExpression, expression);
                this.updateCallTree(parentCallExpression);
            }
        }

        @NotNull
        List<List<PsiMethodCallExpression>> getPsiChains() {
            ArrayList<List<PsiMethodCallExpression>> chains = new ArrayList<List<PsiMethodCallExpression>>();
            for (PsiMethodCallExpression terminationCall : this.myTerminationCalls) {
                ArrayList<PsiMethodCallExpression> chain = new ArrayList<PsiMethodCallExpression>();
                PsiMethodCallExpression current = terminationCall;
                while (current != null && !StreamApiUtil.isProducerStreamCall(current)) {
                    chain.add(current);
                    current = this.myPreviousCalls.get(current);
                }
                Collections.reverse(chain);
                chains.add(chain);
            }
            ArrayList<List<PsiMethodCallExpression>> arrayList = chains;
            if (arrayList == null) {
                MyChainCollectorVisitor.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/streams/psi/impl/JavaStreamChainBuilder$MyChainCollectorVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/streams/psi/impl/JavaStreamChainBuilder$MyChainCollectorVisitor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPsiChains";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "updateCallTree";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyStreamChainExistenceChecker
    extends MyVisitorBase {
        private boolean myFound = false;

        private MyStreamChainExistenceChecker() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (this.myFound) {
                return;
            }
            super.visitMethodCallExpression(expression);
            if (!this.myFound && StreamApiUtil.isTerminationStreamCall(expression) && JavaStreamChainBuilder.this.isPackageSupported(JavaStreamChainBuilder.getPackageName(expression))) {
                this.myFound = true;
            }
        }

        void reset() {
            this.myFound = false;
        }

        boolean found() {
            return this.myFound;
        }
    }
}

