/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.dsl.impl.java;

import com.intellij.debugger.streams.trace.dsl.Types;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaTypes;
import com.intellij.debugger.streams.trace.impl.handler.type.ArrayType;
import com.intellij.debugger.streams.trace.impl.handler.type.ArrayTypeImpl;
import com.intellij.debugger.streams.trace.impl.handler.type.ClassTypeImpl;
import com.intellij.debugger.streams.trace.impl.handler.type.GenericType;
import com.intellij.debugger.streams.trace.impl.handler.type.GenericTypeImpl;
import com.intellij.debugger.streams.trace.impl.handler.type.ListType;
import com.intellij.debugger.streams.trace.impl.handler.type.ListTypeImpl;
import com.intellij.debugger.streams.trace.impl.handler.type.MapType;
import com.intellij.debugger.streams.trace.impl.handler.type.MapTypeImpl;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0004H\u0016J\u000e\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020'J\u0010\u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020\u0004H\u0003J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004H\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0004H\u0016J\u0018\u00103\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004H\u0016J!\u00104\u001a\u00020\u00042\u0017\u00105\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000406\u00a2\u0006\u0002\b7H\u0016J\u000e\u00108\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R2\u0010\u0011\u001a&\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00040\u0004 \u0013*\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0014\u0010\u0019\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/debugger/streams/trace/dsl/impl/java/JavaTypes;", "Lcom/intellij/debugger/streams/trace/dsl/Types;", "()V", "ANY", "Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;", "getANY", "()Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;", "BOOLEAN", "getBOOLEAN", "DOUBLE", "getDOUBLE", "EXCEPTION", "getEXCEPTION", "INT", "getINT", "LONG", "getLONG", "OPTIONAL_TYPES", "", "kotlin.jvm.PlatformType", "", "STRING", "getSTRING", "TIME", "getTIME", "VOID", "getVOID", "optional", "optionalDouble", "optionalInt", "optionalLong", "array", "Lcom/intellij/debugger/streams/trace/impl/handler/type/ArrayType;", "elementType", "fromPsiClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "fromPsiType", "type", "Lcom/intellij/psi/PsiType;", "fromStreamPsiType", "streamPsiType", "isOptional", "", "linkedMap", "Lcom/intellij/debugger/streams/trace/impl/handler/type/MapType;", "keyType", "valueType", "list", "Lcom/intellij/debugger/streams/trace/impl/handler/type/ListType;", "elementsType", "map", "nullable", "typeSelector", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "unwrapOptional", "stream-debugger"})
public final class JavaTypes
implements Types {
    @NotNull
    private static final GenericType ANY;
    @NotNull
    private static final GenericType INT;
    @NotNull
    private static final GenericType BOOLEAN;
    @NotNull
    private static final GenericType DOUBLE;
    @NotNull
    private static final GenericType EXCEPTION;
    @NotNull
    private static final GenericType VOID;
    @NotNull
    private static final GenericType TIME;
    @NotNull
    private static final GenericType STRING;
    @NotNull
    private static final GenericType LONG;
    private static final GenericType optional;
    private static final GenericType optionalInt;
    private static final GenericType optionalLong;
    private static final GenericType optionalDouble;
    private static final Set<GenericType> OPTIONAL_TYPES;
    public static final JavaTypes INSTANCE;

    @Override
    @NotNull
    public GenericType getANY() {
        return ANY;
    }

    @Override
    @NotNull
    public GenericType getINT() {
        return INT;
    }

    @Override
    @NotNull
    public GenericType getBOOLEAN() {
        return BOOLEAN;
    }

    @Override
    @NotNull
    public GenericType getDOUBLE() {
        return DOUBLE;
    }

    @Override
    @NotNull
    public GenericType getEXCEPTION() {
        return EXCEPTION;
    }

    @Override
    @NotNull
    public GenericType getVOID() {
        return VOID;
    }

    @Override
    @NotNull
    public GenericType getTIME() {
        return TIME;
    }

    @Override
    @NotNull
    public GenericType getSTRING() {
        return STRING;
    }

    @Override
    @NotNull
    public GenericType getLONG() {
        return LONG;
    }

    @Override
    @NotNull
    public ArrayType array(@NotNull GenericType elementType) {
        Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
        return new ArrayTypeImpl(elementType, (Function1<? super String, String>)((Function1)array.1.INSTANCE), (Function1<? super String, String>)((Function1)new Function1<String, String>(elementType){
            final /* synthetic */ GenericType $elementType;

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return "new " + this.$elementType.getVariableTypeName() + '[' + it + ']';
            }
            {
                this.$elementType = genericType;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    public MapType map(@NotNull GenericType keyType, @NotNull GenericType valueType) {
        Intrinsics.checkParameterIsNotNull((Object)keyType, (String)"keyType");
        Intrinsics.checkParameterIsNotNull((Object)valueType, (String)"valueType");
        return new MapTypeImpl(keyType, valueType, (Function2<? super String, ? super String, String>)((Function2)map.1.INSTANCE), "new java.util.HashMap<>()");
    }

    @Override
    @NotNull
    public MapType linkedMap(@NotNull GenericType keyType, @NotNull GenericType valueType) {
        Intrinsics.checkParameterIsNotNull((Object)keyType, (String)"keyType");
        Intrinsics.checkParameterIsNotNull((Object)valueType, (String)"valueType");
        return new MapTypeImpl(keyType, valueType, (Function2<? super String, ? super String, String>)((Function2)linkedMap.1.INSTANCE), "new java.util.LinkedHashMap<>()");
    }

    @Override
    @NotNull
    public ListType list(@NotNull GenericType elementsType) {
        Intrinsics.checkParameterIsNotNull((Object)elementsType, (String)"elementsType");
        return new ListTypeImpl(elementsType, (Function1<? super String, String>)((Function1)list.1.INSTANCE), "new java.util.ArrayList<>()");
    }

    @Override
    @NotNull
    public GenericType nullable(@NotNull Function1<? super Types, ? extends GenericType> typeSelector) {
        Intrinsics.checkParameterIsNotNull(typeSelector, (String)"typeSelector");
        return (GenericType)typeSelector.invoke((Object)this);
    }

    @NotNull
    public final GenericType fromStreamPsiType(@NotNull PsiType streamPsiType) {
        Intrinsics.checkParameterIsNotNull((Object)streamPsiType, (String)"streamPsiType");
        return InheritanceUtil.isInheritor((PsiType)streamPsiType, (String)"java.util.stream.IntStream") ? this.getINT() : (InheritanceUtil.isInheritor((PsiType)streamPsiType, (String)"java.util.stream.LongStream") ? this.getLONG() : (InheritanceUtil.isInheritor((PsiType)streamPsiType, (String)"java.util.stream.DoubleStream") ? this.getDOUBLE() : (Intrinsics.areEqual((Object)PsiType.VOID, (Object)streamPsiType) ? this.getVOID() : this.getANY())));
    }

    @NotNull
    public final GenericType fromPsiClass(@NotNull PsiClass psiClass) {
        Intrinsics.checkParameterIsNotNull((Object)psiClass, (String)"psiClass");
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.stream.IntStream") ? this.getINT() : (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.stream.LongStream") ? this.getLONG() : (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.stream.DoubleStream") ? this.getDOUBLE() : this.getANY()));
    }

    @NotNull
    public final GenericType fromPsiType(@NotNull PsiType type) {
        GenericType genericType;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        PsiType psiType = type;
        if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.VOID)) {
            genericType = this.getVOID();
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.INT)) {
            genericType = this.getINT();
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.DOUBLE)) {
            genericType = this.getDOUBLE();
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.LONG)) {
            genericType = this.getLONG();
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.BOOLEAN)) {
            genericType = this.getBOOLEAN();
        } else {
            String string = TypeConversionUtil.erasure((PsiType)type).getCanonicalText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TypeConversionUtil.erasure(type).canonicalText");
            genericType = new ClassTypeImpl(string, null, 2, null);
        }
        return genericType;
    }

    @Contract(pure=true)
    private final boolean isOptional(GenericType type) {
        return OPTIONAL_TYPES.contains(type);
    }

    @NotNull
    public final GenericType unwrapOptional(@NotNull GenericType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        boolean bl = this.isOptional(type);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        GenericType genericType = type;
        return Intrinsics.areEqual((Object)genericType, (Object)optionalInt) ? this.getINT() : (Intrinsics.areEqual((Object)genericType, (Object)optionalLong) ? this.getLONG() : (Intrinsics.areEqual((Object)genericType, (Object)optionalDouble) ? this.getDOUBLE() : this.getANY()));
    }

    private JavaTypes() {
        INSTANCE = this;
        ANY = new ClassTypeImpl("java.lang.Object", "new java.lang.Object()");
        INT = new GenericTypeImpl("int", "java.lang.Integer", "0");
        BOOLEAN = new GenericTypeImpl("boolean", "java.lang.Boolean", "false");
        DOUBLE = new GenericTypeImpl("double", "java.lang.Double", "0.");
        EXCEPTION = new ClassTypeImpl("java.lang.Throwable", null, 2, null);
        VOID = new GenericTypeImpl("void", "java.lang.Void", "null");
        TIME = new ClassTypeImpl("java.util.concurrent.atomic.AtomicInteger", "new java.util.concurrent.atomic.AtomicInteger()");
        STRING = new ClassTypeImpl("java.lang.String", "\"\"");
        LONG = new GenericTypeImpl("long", "java.lang.Long", "0L");
        optional = new ClassTypeImpl("java.util.Optional", null, 2, null);
        optionalInt = new ClassTypeImpl("java.util.OptionalInt", null, 2, null);
        optionalLong = new ClassTypeImpl("java.util.OptionalLong", null, 2, null);
        optionalDouble = new ClassTypeImpl("java.util.OptionalDouble", null, 2, null);
        OPTIONAL_TYPES = StreamEx.of((Object[])new GenericType[]{optional, optionalInt, optionalLong, optionalDouble}).toSet();
    }

    static {
        new JavaTypes();
    }
}

