/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.ui.impl;

import com.intellij.debugger.streams.ui.PaintingListener;
import com.intellij.debugger.streams.ui.ValuesPositionsListener;
import com.intellij.debugger.streams.ui.impl.CollectionTree;
import com.intellij.debugger.streams.ui.impl.CollectionView;
import com.intellij.debugger.streams.ui.impl.ValueWithPositionImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import java.awt.Rectangle;
import java.util.EventListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ\b\u0010\u0010\u001a\u00020\u000eH\u0002J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J,\u0010\u0014\u001a\u00020\u0012*\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/debugger/streams/ui/impl/PositionsAwareCollectionView;", "Lcom/intellij/debugger/streams/ui/impl/CollectionView;", "header", "", "tree", "Lcom/intellij/debugger/streams/ui/impl/CollectionTree;", "values", "", "Lcom/intellij/debugger/streams/ui/impl/ValueWithPositionImpl;", "(Ljava/lang/String;Lcom/intellij/debugger/streams/ui/impl/CollectionTree;Ljava/util/List;)V", "myDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/debugger/streams/ui/ValuesPositionsListener;", "addValuesPositionsListener", "", "listener", "updateValues", "invalidate", "", "modified", "set", "pos", "", "visible", "highlighted", "stream-debugger"})
public class PositionsAwareCollectionView
extends CollectionView {
    private final EventDispatcher<ValuesPositionsListener> myDispatcher;
    private final List<ValueWithPositionImpl> values;

    public final void addValuesPositionsListener(@NotNull ValuesPositionsListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.myDispatcher.addListener((EventListener)listener);
    }

    private final void updateValues() {
        boolean changed = false;
        Rectangle visibleRect = this.getInstancesTree().getVisibleRect();
        for (ValueWithPositionImpl value : this.values) {
            Rectangle rect = this.getInstancesTree().getRectByValue(value.getTraceElement());
            changed = rect == null ? this.invalidate(value, changed) : this.set(value, changed, rect.y + rect.height / 2 - visibleRect.y, visibleRect.intersects(rect), this.getInstancesTree().isHighlighted(value.getTraceElement()));
        }
        if (changed) {
            ApplicationManager.getApplication().invokeLater(new Runnable(this){
                final /* synthetic */ PositionsAwareCollectionView this$0;

                public final void run() {
                    ((ValuesPositionsListener)PositionsAwareCollectionView.access$getMyDispatcher$p(this.this$0).getMulticaster()).valuesPositionsChanged();
                }
                {
                    this.this$0 = positionsAwareCollectionView;
                }
            });
        }
    }

    private final boolean invalidate(@NotNull ValueWithPositionImpl $receiver, boolean modified) {
        boolean bl;
        boolean bl2 = modified;
        if (bl2) {
            $receiver.setInvalid();
            bl = true;
        } else if (!bl2) {
            bl = $receiver.updateToInvalid();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private final boolean set(@NotNull ValueWithPositionImpl $receiver, boolean modified, int pos, boolean visible, boolean highlighted) {
        boolean bl;
        boolean bl2 = modified;
        if (bl2) {
            $receiver.setProperties(pos, visible, highlighted);
            bl = true;
        } else if (!bl2) {
            bl = $receiver.updateProperties(pos, visible, highlighted);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public PositionsAwareCollectionView(@NotNull String header, @NotNull CollectionTree tree, @NotNull List<ValueWithPositionImpl> values) {
        Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
        Intrinsics.checkParameterIsNotNull((Object)tree, (String)"tree");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        super(header, tree);
        this.values = values;
        EventDispatcher eventDispatcher = EventDispatcher.create(ValuesPositionsListener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"EventDispatcher.create(V\u2026ionsListener::class.java)");
        this.myDispatcher = eventDispatcher;
        Disposer.register((Disposable)this, (Disposable)this.getInstancesTree());
        this.getInstancesTree().addPaintingListener(new PaintingListener(){

            @Override
            public void componentPainted() {
                this.updateValues();
            }
        });
    }

    @NotNull
    public static final /* synthetic */ EventDispatcher access$getMyDispatcher$p(PositionsAwareCollectionView $this) {
        return $this.myDispatcher;
    }
}

