/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.actions.CreateNewClassDialogValidatorEx;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiNameHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateNewClassDialogValidatorExImpl
implements CreateNewClassDialogValidatorEx {
    public static final String INVALID_PACKAGE_MESSAGE = "This is not a valid Java package name";
    public static final String INVALID_QUALIFIED_NAME = "This is not a valid Java qualified name";
    private Project myProject;

    public CreateNewClassDialogValidatorExImpl(Project project) {
        this.myProject = project;
    }

    public static boolean isValidJavaIdentifier(String identifier) {
        return StringUtil.isJavaIdentifier((String)identifier) && !JavaLexer.isKeyword((String)identifier, (LanguageLevel)LanguageLevel.HIGHEST);
    }

    @Override
    public boolean checkSuperclass(@NotNull String inputString) {
        if (inputString == null) {
            CreateNewClassDialogValidatorExImpl.$$$reportNull$$$0(0);
        }
        return CreateNewClassDialogValidatorExImpl.checkQualifiedName(inputString);
    }

    @Override
    public boolean checkInterface(@NotNull String inputString) {
        if (inputString == null) {
            CreateNewClassDialogValidatorExImpl.$$$reportNull$$$0(1);
        }
        return CreateNewClassDialogValidatorExImpl.checkQualifiedName(inputString);
    }

    @Override
    public boolean checkPackage(@NotNull String inputString) {
        if (inputString == null) {
            CreateNewClassDialogValidatorExImpl.$$$reportNull$$$0(2);
        }
        return CharMatcher.WHITESPACE.matchesAllOf((CharSequence)inputString) || CreateNewClassDialogValidatorExImpl.checkList(inputString, ".");
    }

    @Nullable
    public String getErrorText(String inputString) {
        if (!inputString.isEmpty() && !PsiNameHelper.getInstance((Project)this.myProject).isQualifiedName(inputString)) {
            return INVALID_QUALIFIED_NAME;
        }
        return null;
    }

    @Override
    @NotNull
    public String getSuperclassErrorText(@Nullable String inputString) {
        if (INVALID_QUALIFIED_NAME == null) {
            CreateNewClassDialogValidatorExImpl.$$$reportNull$$$0(3);
        }
        return INVALID_QUALIFIED_NAME;
    }

    @Override
    @NotNull
    public String getInterfacesErrorText(@Nullable String inputString) {
        if (INVALID_QUALIFIED_NAME == null) {
            CreateNewClassDialogValidatorExImpl.$$$reportNull$$$0(4);
        }
        return INVALID_QUALIFIED_NAME;
    }

    @Override
    @NotNull
    public String getPackageErrorText(@Nullable String inputString) {
        if (INVALID_PACKAGE_MESSAGE == null) {
            CreateNewClassDialogValidatorExImpl.$$$reportNull$$$0(5);
        }
        return INVALID_PACKAGE_MESSAGE;
    }

    public boolean checkInput(String inputString) {
        String name = inputString.trim();
        return !CharMatcher.WHITESPACE.matchesAllOf((CharSequence)name) && this.getErrorText(name) == null;
    }

    public boolean canClose(String inputString) {
        return !CharMatcher.WHITESPACE.matchesAllOf((CharSequence)inputString) && this.getErrorText(inputString) == null;
    }

    private static boolean checkQualifiedName(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            CreateNewClassDialogValidatorExImpl.$$$reportNull$$$0(6);
        }
        return CharMatcher.WHITESPACE.matchesAllOf((CharSequence)qualifiedName) || CreateNewClassDialogValidatorExImpl.checkList(qualifiedName, ".");
    }

    private static boolean checkList(@NotNull String inputString, @NotNull String delimiter) {
        if (inputString == null) {
            CreateNewClassDialogValidatorExImpl.$$$reportNull$$$0(7);
        }
        if (delimiter == null) {
            CreateNewClassDialogValidatorExImpl.$$$reportNull$$$0(8);
        }
        for (String identifier : Splitter.on((String)delimiter).trimResults().split((CharSequence)inputString)) {
            if (CreateNewClassDialogValidatorExImpl.isValidJavaIdentifier(identifier)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputString";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/actions/CreateNewClassDialogValidatorExImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delimiter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/actions/CreateNewClassDialogValidatorExImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperclassErrorText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfacesErrorText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageErrorText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperclass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkInterface";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkPackage";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkQualifiedName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

