/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.actions.PsiClassNavigation;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class EditMultipleSourcesAction
extends AnAction {
    public EditMultipleSourcesAction() {
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(ActionsBundle.actionText((String)"EditSource"));
        presentation.setIcon(AllIcons.Actions.EditSource);
        presentation.setDescription(ActionsBundle.actionDescription((String)"EditSource"));
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Navigatable[] navigatables = (Navigatable[])e.getData(CommonDataKeys.NAVIGATABLE_ARRAY);
        if (navigatables != null && navigatables.length > 0) {
            e.getPresentation().setEnabled(true);
            if (navigatables.length > 1) {
                e.getPresentation().setText(ActionsBundle.actionText((String)"EditSource") + "...");
            } else {
                e.getPresentation().setText(ActionsBundle.actionText((String)"EditSource"));
            }
        } else {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setText(ActionsBundle.actionText((String)"EditSource"));
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        final Navigatable[] files = (Navigatable[])e.getData(CommonDataKeys.NAVIGATABLE_ARRAY);
        assert (files != null && files.length > 0);
        if (files.length > 1) {
            DefaultListModel<PsiFile> listModel = new DefaultListModel<PsiFile>();
            for (int i = 0; i < files.length; ++i) {
                assert (files[i] instanceof PsiClassNavigation);
                listModel.add(i, ((PsiClassNavigation)files[i]).getPsiFile());
            }
            final JBList list = new JBList(listModel);
            int width = WindowManager.getInstance().getFrame((Project)project).getSize().width;
            list.setCellRenderer((ListCellRenderer)new GotoFileCellRenderer(width));
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Target File").setItemChoosenCallback(new Runnable(){

                @Override
                public void run() {
                    Object selectedValue = list.getSelectedValue();
                    PsiClassNavigation navigationWrapper = null;
                    for (Navigatable file : files) {
                        if (selectedValue != ((PsiClassNavigation)file).getPsiFile()) continue;
                        navigationWrapper = (PsiClassNavigation)file;
                        break;
                    }
                    assert (navigationWrapper != null);
                    if (navigationWrapper.canNavigate()) {
                        navigationWrapper.navigate(true);
                    }
                }
            }).createPopup();
            if (e.getInputEvent().getSource() instanceof ActionButton) {
                popup.showUnderneathOf((Component)((ActionButton)e.getInputEvent().getSource()));
            } else {
                popup.showInBestPositionFor(e.getDataContext());
            }
        } else {
            assert (files[0] instanceof PsiClassNavigation);
            PsiClassNavigation file = (PsiClassNavigation)files[0];
            if (file.canNavigate()) {
                file.navigate(true);
            }
        }
    }
}

