/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.LightBrClass;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BrShortNamesCache
extends PsiShortNamesCache {
    private final DataBindingProjectComponent myComponent;
    private CachedValue<String[]> myAllFieldNamesCache;
    private static final String[] BR_CLASS_NAME_LIST = new String[]{"BR"};

    public BrShortNamesCache(DataBindingProjectComponent dataBindingProjectComponent) {
        this.myComponent = dataBindingProjectComponent;
        this.myAllFieldNamesCache = CachedValuesManager.getManager((Project)this.myComponent.getProject()).createCachedValue(() -> {
            String[] result;
            AndroidFacet[] facets = this.myComponent.getDataBindingEnabledFacets();
            if (facets.length == 0) {
                result = ArrayUtil.EMPTY_STRING_ARRAY;
            } else {
                java.util.HashSet allFields = Sets.newHashSet();
                for (AndroidFacet facet : facets) {
                    LightBrClass brClass = DataBindingUtil.getOrCreateBrClassFor(facet);
                    Collections.addAll(allFields, brClass.getAllFieldNames());
                }
                result = ArrayUtil.toStringArray((Collection)allFields);
            }
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{this.myComponent});
        }, false);
    }

    private boolean isMyScope(GlobalSearchScope scope) {
        if (!this.isEnabled()) {
            return false;
        }
        if (scope.getProject() == null) {
            return false;
        }
        return this.myComponent.getProject().equals(scope.getProject());
    }

    @NotNull
    public PsiClass[] getClassesByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            BrShortNamesCache.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            BrShortNamesCache.$$$reportNull$$$0(1);
        }
        if (!this.isMyScope(scope)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                BrShortNamesCache.$$$reportNull$$$0(2);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (!"BR".equals(name)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                BrShortNamesCache.$$$reportNull$$$0(3);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        AndroidFacet[] facets = this.myComponent.getDataBindingEnabledFacets();
        PsiClass[] psiClassArray = BrShortNamesCache.filterByScope(facets, scope);
        if (psiClassArray == null) {
            BrShortNamesCache.$$$reportNull$$$0(4);
        }
        return psiClassArray;
    }

    @NotNull
    public String[] getAllClassNames() {
        if (!this.isEnabled()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                BrShortNamesCache.$$$reportNull$$$0(5);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (BR_CLASS_NAME_LIST == null) {
            BrShortNamesCache.$$$reportNull$$$0(6);
        }
        return BR_CLASS_NAME_LIST;
    }

    public void getAllClassNames(@NotNull HashSet<String> dest) {
        if (dest == null) {
            BrShortNamesCache.$$$reportNull$$$0(7);
        }
        if (!this.isEnabled()) {
            return;
        }
        dest.add((Object)"BR");
    }

    @NotNull
    public PsiMethod[] getMethodsByName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            BrShortNamesCache.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            BrShortNamesCache.$$$reportNull$$$0(9);
        }
        if (PsiMethod.EMPTY_ARRAY == null) {
            BrShortNamesCache.$$$reportNull$$$0(10);
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    public PsiMethod[] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            BrShortNamesCache.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            BrShortNamesCache.$$$reportNull$$$0(12);
        }
        if (PsiMethod.EMPTY_ARRAY == null) {
            BrShortNamesCache.$$$reportNull$$$0(13);
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    public PsiField[] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        PsiField[] fields;
        if (name == null) {
            BrShortNamesCache.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            BrShortNamesCache.$$$reportNull$$$0(15);
        }
        if ((fields = this.getFieldsByName(name, scope)).length > maxCount) {
            if (PsiField.EMPTY_ARRAY == null) {
                BrShortNamesCache.$$$reportNull$$$0(16);
            }
            return PsiField.EMPTY_ARRAY;
        }
        if (fields == null) {
            BrShortNamesCache.$$$reportNull$$$0(17);
        }
        return fields;
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiMethod> processor) {
        if (name == null) {
            BrShortNamesCache.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            BrShortNamesCache.$$$reportNull$$$0(19);
        }
        if (processor == null) {
            BrShortNamesCache.$$$reportNull$$$0(20);
        }
        return true;
    }

    @NotNull
    public String[] getAllMethodNames() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            BrShortNamesCache.$$$reportNull$$$0(21);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public void getAllMethodNames(@NotNull HashSet<String> set) {
        if (set == null) {
            BrShortNamesCache.$$$reportNull$$$0(22);
        }
    }

    @NotNull
    public PsiField[] getFieldsByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            BrShortNamesCache.$$$reportNull$$$0(23);
        }
        if (scope == null) {
            BrShortNamesCache.$$$reportNull$$$0(24);
        }
        if (!this.isMyScope(scope)) {
            if (PsiField.EMPTY_ARRAY == null) {
                BrShortNamesCache.$$$reportNull$$$0(25);
            }
            return PsiField.EMPTY_ARRAY;
        }
        PsiClass[] psiClasses = BrShortNamesCache.filterByScope(this.myComponent.getDataBindingEnabledFacets(), scope);
        if (psiClasses.length == 0) {
            if (PsiField.EMPTY_ARRAY == null) {
                BrShortNamesCache.$$$reportNull$$$0(26);
            }
            return PsiField.EMPTY_ARRAY;
        }
        ArrayList result = Lists.newArrayList();
        for (PsiClass psiClass : psiClasses) {
            PsiField field = psiClass.findFieldByName(name, false);
            if (field == null) continue;
            result.add(field);
        }
        PsiField[] psiFieldArray = result.toArray(new PsiField[result.size()]);
        if (psiFieldArray == null) {
            BrShortNamesCache.$$$reportNull$$$0(27);
        }
        return psiFieldArray;
    }

    @NotNull
    public String[] getAllFieldNames() {
        if (!this.isEnabled()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                BrShortNamesCache.$$$reportNull$$$0(28);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = (String[])this.myAllFieldNamesCache.getValue();
        if (stringArray == null) {
            BrShortNamesCache.$$$reportNull$$$0(29);
        }
        return stringArray;
    }

    public void getAllFieldNames(@NotNull HashSet<String> set) {
        if (set == null) {
            BrShortNamesCache.$$$reportNull$$$0(30);
        }
        Collections.addAll(set, this.getAllFieldNames());
    }

    private static PsiClass[] filterByScope(AndroidFacet[] facets, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            BrShortNamesCache.$$$reportNull$$$0(31);
        }
        if (facets == null || facets.length == 0) {
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList selected = Lists.newArrayList();
        for (AndroidFacet facet : facets) {
            if (!scope.isSearchInModuleContent(facet.getModule())) continue;
            selected.add(DataBindingUtil.getOrCreateBrClassFor(facet));
        }
        if (selected.size() == 0) {
            return PsiClass.EMPTY_ARRAY;
        }
        return selected.toArray(new PsiClass[selected.size()]);
    }

    private boolean isEnabled() {
        return DataBindingUtil.inMemoryClassGenerationIsEnabled() && this.myComponent.hasAnyDataBindingEnabledFacet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 9: 
            case 12: 
            case 15: 
            case 19: 
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/databinding/BrShortNamesCache";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/databinding/BrShortNamesCache";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClassNames";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsByName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsByNameIfNotMoreThan";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsByNameIfNotMoreThan";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethodNames";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsByName";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFieldNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClassesByName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllClassNames";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsByName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsByNameIfNotMoreThan";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsByNameIfNotMoreThan";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processMethodsWithName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAllMethodNames";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsByName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAllFieldNames";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "filterByScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

