/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeAndroidProject;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.ProxyUtil;
import com.android.tools.idea.gradle.util.ui.ToolWindowAlikePanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternalAndroidModelView {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Tree myTree;

    public InternalAndroidModelView(@NotNull Project project) {
        if (project == null) {
            InternalAndroidModelView.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myTree = new Tree();
        GradleSyncState.subscribe(this.myProject, new GradleSyncListener.Adapter(){

            @Override
            public void syncStarted(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                InternalAndroidModelView.this.updateContents();
            }

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                InternalAndroidModelView.this.updateContents();
            }

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(3);
                }
                InternalAndroidModelView.this.updateContents();
            }

            @Override
            public void syncSkipped(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(4);
                }
                InternalAndroidModelView.this.updateContents();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/gradle/InternalAndroidModelView$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncSucceeded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncFailed";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncSkipped";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static InternalAndroidModelView getInstance(@NotNull Project project) {
        if (project == null) {
            InternalAndroidModelView.$$$reportNull$$$0(1);
        }
        return (InternalAndroidModelView)ServiceManager.getService((Project)project, InternalAndroidModelView.class);
    }

    public void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            InternalAndroidModelView.$$$reportNull$$$0(2);
        }
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        ToolWindowAlikePanel toolWindowPanel = ToolWindowAlikePanel.createTreePanel(this.myProject.getName(), (JTree)this.myTree);
        Content content = contentFactory.createContent((JComponent)toolWindowPanel, "", false);
        toolWindow.getContentManager().addContent(content);
        this.updateContents();
    }

    private void updateContents() {
        this.myTree.setRootVisible(true);
        if (GradleSyncState.getInstance(this.myProject).isSyncInProgress()) {
            this.myTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode("Gradle project sync in progress ...")));
            return;
        }
        this.myTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode("Loading ...")));
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(this.myProject.getName());
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                NdkModuleModel ndkModuleModel;
                AndroidModuleModel androidModel = AndroidModuleModel.get(module);
                if (androidModel != null) {
                    DefaultMutableTreeNode moduleNode = new DefaultMutableTreeNode(module.getName());
                    AndroidProject androidProject = androidModel.waitForAndGetProxyAndroidProject();
                    this.addProxyObject(moduleNode, androidProject);
                    rootNode.add(moduleNode);
                }
                if ((ndkModuleModel = NdkModuleModel.get(module)) == null) continue;
                String nodeName = androidModel == null ? module.getName() : module.getName() + " (native)";
                DefaultMutableTreeNode nativeModuleNode = new DefaultMutableTreeNode(nodeName);
                NativeAndroidProject nativeAndroidProject = ndkModuleModel.waitForAndGetProxyAndroidProject();
                this.addProxyObject(nativeModuleNode, nativeAndroidProject);
                rootNode.add(nativeModuleNode);
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
                renderer.setOpenIcon(AllIcons.Nodes.NewFolder);
                renderer.setClosedIcon(AllIcons.Nodes.NewFolder);
                renderer.setLeafIcon(AllIcons.ObjectBrowser.ShowModules);
                this.myTree.setCellRenderer((TreeCellRenderer)renderer);
                DefaultTreeModel model = new DefaultTreeModel(rootNode);
                this.myTree.setRootVisible(false);
                this.myTree.setModel((TreeModel)model);
            });
        });
    }

    void addProxyObject(@NotNull DefaultMutableTreeNode node, @NotNull Object obj) {
        if (node == null) {
            InternalAndroidModelView.$$$reportNull$$$0(3);
        }
        if (obj == null) {
            InternalAndroidModelView.$$$reportNull$$$0(4);
        }
        this.addProxyObject(node, obj, false);
    }

    private void addProxyObject(@NotNull DefaultMutableTreeNode node, @NotNull Object obj, boolean useDerivedNodeName) {
        if (node == null) {
            InternalAndroidModelView.$$$reportNull$$$0(5);
        }
        if (obj == null) {
            InternalAndroidModelView.$$$reportNull$$$0(6);
        }
        assert (ProxyUtil.isAndroidModelProxyObject(obj));
        String name = null;
        for (Map.Entry<String, Object> entry : ProxyUtil.getAndroidModelProxyValues(obj).entrySet()) {
            String property = entry.getKey();
            property = property.substring(0, property.lastIndexOf(40));
            property = property.substring(property.lastIndexOf(46) + 1, property.length());
            property = StringUtil.trimStart((String)property, (String)"get");
            Object value = entry.getValue();
            if (value != null && property.equals("Name")) {
                name = value.toString();
            }
            this.addPropertyNode(node, property, value);
        }
        if (useDerivedNodeName && name != null) {
            node.setUserObject(name);
        }
    }

    private void addPropertyNode(@NotNull DefaultMutableTreeNode node, @NotNull String property, @Nullable Object value) {
        if (node == null) {
            InternalAndroidModelView.$$$reportNull$$$0(7);
        }
        if (property == null) {
            InternalAndroidModelView.$$$reportNull$$$0(8);
        }
        DefaultMutableTreeNode propertyNode = new DefaultMutableTreeNode(property);
        if (value != null && ProxyUtil.isAndroidModelProxyObject(value)) {
            this.addProxyObject(propertyNode, value, property.isEmpty());
        } else if (value instanceof Collection && !((Collection)value).isEmpty()) {
            for (Object obj : (Collection)value) {
                this.addPropertyNode(propertyNode, "", obj);
            }
        } else if (value instanceof Map && !((Map)value).isEmpty()) {
            Map map = (Map)value;
            for (Object key : map.keySet()) {
                this.addPropertyNode(propertyNode, key.toString(), map.get(key));
            }
        } else if (value instanceof ProxyUtil.InvocationErrorValue) {
            Throwable exception = ((ProxyUtil.InvocationErrorValue)value).exception;
            propertyNode.setUserObject(InternalAndroidModelView.getNodeValue(property, "Error: " + exception.getClass().getName()));
        } else {
            propertyNode.setUserObject(InternalAndroidModelView.getNodeValue(property, this.getStringForValue(value)));
        }
        InternalAndroidModelView.addToNode(node, propertyNode);
    }

    @NotNull
    private String getStringForValue(@Nullable Object value) {
        if (value != null && value instanceof File) {
            String filePath = ((File)value).getPath();
            String basePath = this.myProject.getBasePath();
            if (basePath != null) {
                if (!(basePath = FileUtil.toSystemDependentName((String)basePath)).endsWith(File.separator)) {
                    basePath = basePath + File.separator;
                }
                if (filePath.startsWith(basePath)) {
                    String string = filePath.substring(basePath.length());
                    if (string == null) {
                        InternalAndroidModelView.$$$reportNull$$$0(9);
                    }
                    return string;
                }
            }
        }
        String string = value == null ? "null" : value.toString();
        if (string == null) {
            InternalAndroidModelView.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private static String getNodeValue(@NotNull String property, @NotNull String value) {
        if (property == null) {
            InternalAndroidModelView.$$$reportNull$$$0(11);
        }
        if (value == null) {
            InternalAndroidModelView.$$$reportNull$$$0(12);
        }
        String string = property.isEmpty() ? value : property + " -> " + value;
        if (string == null) {
            InternalAndroidModelView.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static void addToNode(@NotNull DefaultMutableTreeNode parent, @NotNull DefaultMutableTreeNode newChild) {
        if (parent == null) {
            InternalAndroidModelView.$$$reportNull$$$0(14);
        }
        if (newChild == null) {
            InternalAndroidModelView.$$$reportNull$$$0(15);
        }
        for (int i = 0; i < parent.getChildCount(); ++i) {
            DefaultMutableTreeNode existingChild = (DefaultMutableTreeNode)parent.getChildAt(i);
            if (InternalAndroidModelView.compareTo(existingChild, newChild) < 0) continue;
            parent.insert(newChild, i);
            return;
        }
        parent.add(newChild);
    }

    private static int compareTo(@NotNull DefaultMutableTreeNode node1, @NotNull DefaultMutableTreeNode node2) {
        if (node1 == null) {
            InternalAndroidModelView.$$$reportNull$$$0(16);
        }
        if (node2 == null) {
            InternalAndroidModelView.$$$reportNull$$$0(17);
        }
        if (node1.isLeaf() && !node2.isLeaf()) {
            return -1;
        }
        if (!node1.isLeaf() && node2.isLeaf()) {
            return 1;
        }
        return node1.getUserObject().toString().compareTo(node2.getUserObject().toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/InternalAndroidModelView";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/InternalAndroidModelView";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringForValue";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowContent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addProxyObject";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyNode";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNodeValue";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addToNode";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

