/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.ui;

import com.android.tools.idea.gradle.editor.entity.GradleEditorEntity;
import com.android.tools.idea.gradle.editor.metadata.StdGradleEditorEntityMetaData;
import com.android.tools.idea.gradle.editor.ui.GradleEditorCellComponent;
import com.android.tools.idea.gradle.editor.ui.GradleEditorCellComponentImpl;
import com.android.tools.idea.gradle.editor.ui.GradleEditorEntityTableModel;
import com.android.tools.idea.gradle.editor.ui.GradleEditorEntityUiRegistry;
import com.android.tools.idea.gradle.editor.ui.GradleEditorUiConstants;
import com.intellij.application.options.codeStyle.arrangement.util.IntObjectMap;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.AbstractTableCellEditor;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleEditorEntityTable
extends JBTable
implements DataProvider {
    private final IntObjectMap<GradleEditorCellComponent> myRendererComponents;
    private final IntObjectMap<GradleEditorCellComponent> myEditorComponents;
    @NotNull
    private final Project myProject;
    private int myEditingRow;
    private int myRowUnderMouse;

    public GradleEditorEntityTable(@NotNull Project project) {
        if (project == null) {
            GradleEditorEntityTable.$$$reportNull$$$0(0);
        }
        super((TableModel)new GradleEditorEntityTableModel());
        this.myRendererComponents = new IntObjectMap();
        this.myEditorComponents = new IntObjectMap();
        this.myEditingRow = -1;
        this.myRowUnderMouse = -1;
        this.myProject = project;
        this.setShowColumns(false);
        this.setShowGrid(false);
        this.setRowHeight(32);
        this.setDefaultRenderer(Object.class, new MyRenderer());
        this.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)((Object)new MyEditor()));
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                GradleEditorEntityTable.this.onMouseMoved(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                GradleEditorEntityTable.this.onMouseExited();
            }
        });
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                GradleEditorEntityTable.this.onTableChange(e);
            }
        });
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
    }

    @NotNull
    public GradleEditorEntityTableModel getModel() {
        GradleEditorEntityTableModel gradleEditorEntityTableModel = (GradleEditorEntityTableModel)super.getModel();
        if (gradleEditorEntityTableModel == null) {
            GradleEditorEntityTable.$$$reportNull$$$0(1);
        }
        return gradleEditorEntityTableModel;
    }

    public int getRowByComponent(@NotNull GradleEditorCellComponent component) {
        if (component == null) {
            GradleEditorEntityTable.$$$reportNull$$$0(2);
        }
        int max = this.getModel().getRowCount();
        for (int i = 0; i < max; ++i) {
            if (this.myRendererComponents.get(i) != component && this.myEditorComponents.get(i) != component) continue;
            return i;
        }
        return -1;
    }

    private void onTableChange(@NotNull TableModelEvent e) {
        int signum;
        if (e == null) {
            GradleEditorEntityTable.$$$reportNull$$$0(3);
        }
        switch (e.getType()) {
            case 1: {
                signum = 1;
                break;
            }
            case -1: {
                signum = -1;
                for (int i = e.getLastRow(); i >= e.getFirstRow(); --i) {
                    this.myRendererComponents.remove(i);
                    this.myEditorComponents.remove(i);
                }
                break;
            }
            default: {
                return;
            }
        }
        int shift = Math.abs(e.getFirstRow() - e.getLastRow() + 1) * signum;
        this.myRendererComponents.shiftKeys(e.getFirstRow(), shift);
        this.myEditorComponents.shiftKeys(e.getFirstRow(), shift);
        if (this.myRowUnderMouse >= e.getFirstRow()) {
            this.myRowUnderMouse = -1;
        }
        if (this.getModel().getRowCount() > 0) {
            this.repaintRows(0, this.getModel().getRowCount() - 1, false);
        }
    }

    private void onMouseMoved(@NotNull MouseEvent e) {
        GradleEditorCellComponent component;
        int i;
        if (e == null) {
            GradleEditorEntityTable.$$$reportNull$$$0(4);
        }
        if ((i = this.rowAtPoint(e.getPoint())) != this.myRowUnderMouse) {
            this.onMouseExited();
        }
        if (i < 0) {
            return;
        }
        if (i != this.myRowUnderMouse) {
            this.onMouseEntered(e);
        }
        GradleEditorCellComponent gradleEditorCellComponent = component = this.isEditing() ? (GradleEditorCellComponent)this.myEditorComponents.get(i) : (GradleEditorCellComponent)this.myRendererComponents.get(i);
        if (component == null) {
            return;
        }
        Rectangle rectangle = component.onMouseMove(e);
        if (rectangle != null) {
            this.repaintScreenBounds(rectangle);
        }
    }

    private void onMouseExited() {
        GradleEditorCellComponent c;
        if (this.myRowUnderMouse < 0) {
            return;
        }
        GradleEditorCellComponent gradleEditorCellComponent = c = this.isEditing() ? (GradleEditorCellComponent)this.myEditorComponents.get(this.myRowUnderMouse) : (GradleEditorCellComponent)this.myRendererComponents.get(this.myRowUnderMouse);
        if (c != null) {
            c.onMouseExited();
            this.repaintRows(this.myRowUnderMouse, this.myRowUnderMouse, false);
        }
        this.myRowUnderMouse = -1;
    }

    private void onMouseEntered(@NotNull MouseEvent e) {
        GradleEditorCellComponent c;
        if (e == null) {
            GradleEditorEntityTable.$$$reportNull$$$0(5);
        }
        this.myRowUnderMouse = this.rowAtPoint(e.getPoint());
        GradleEditorCellComponent gradleEditorCellComponent = c = this.isEditing() ? (GradleEditorCellComponent)this.myEditorComponents.get(this.myRowUnderMouse) : (GradleEditorCellComponent)this.myRendererComponents.get(this.myRowUnderMouse);
        if (c != null) {
            c.onMouseEntered(e);
            this.repaintRows(this.myRowUnderMouse, this.myRowUnderMouse, false);
        }
    }

    private void repaintScreenBounds(@NotNull Rectangle bounds) {
        if (bounds == null) {
            GradleEditorEntityTable.$$$reportNull$$$0(6);
        }
        Point location = bounds.getLocation();
        SwingUtilities.convertPointFromScreen(location, (Component)((Object)this));
        int x = location.x;
        int width = bounds.width;
        this.repaint(x, location.y, width, bounds.height);
    }

    public void repaintRows(int first, int last, boolean rowStructureChanged) {
        for (int i = first; i <= last; ++i) {
            if (!rowStructureChanged) continue;
            this.myRendererComponents.remove(i);
            this.myEditorComponents.remove(i);
        }
        this.getModel().fireTableRowsUpdated(first, last);
    }

    public void removeEditor() {
        super.removeEditor();
        GradleEditorCellComponent component = (GradleEditorCellComponent)this.myRendererComponents.get(this.myEditingRow);
        if (component != null) {
            component.onMouseExited();
            component.getValue(this.myProject);
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (GradleEditorUiConstants.ACTIVE_ENTITY_KEY.is(dataId)) {
            int row;
            if (this.isEditing() && (row = this.getEditingRow()) >= 0 && row < this.getRowCount()) {
                Object value = this.getValueAt(row, 0);
                return value instanceof GradleEditorEntity ? value : null;
            }
        } else if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        return null;
    }

    public boolean isCellEditable(int row, int column) {
        Object value = this.getValueAt(row, column);
        if (!(value instanceof GradleEditorEntity)) {
            return false;
        }
        GradleEditorEntity entity = (GradleEditorEntity)value;
        return !entity.getMetaData().contains(StdGradleEditorEntityMetaData.READ_ONLY) && ((GradleEditorEntityUiRegistry)ServiceManager.getService(GradleEditorEntityUiRegistry.class)).hasEntityUi(entity);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/editor/ui/GradleEditorEntityTable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/editor/ui/GradleEditorEntityTable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRowByComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onTableChange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onMouseMoved";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onMouseEntered";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "repaintScreenBounds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyEditor
    extends AbstractTableCellEditor {
        private MyEditor() {
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            GradleEditorEntityTable.this.myEditingRow = row;
            GradleEditorCellComponent component = (GradleEditorCellComponent)GradleEditorEntityTable.this.myEditorComponents.get(row);
            if (component == null) {
                component = new GradleEditorCellComponentImpl(GradleEditorEntityTable.this);
                GradleEditorEntityTable.this.myEditorComponents.set(row, (Object)component);
            }
            return component.bind(table, value, GradleEditorEntityTable.this.myProject, row, column, true, isSelected, true);
        }

        @Nullable
        public Object getCellEditorValue() {
            GradleEditorCellComponent component = (GradleEditorCellComponent)GradleEditorEntityTable.this.myEditorComponents.get(GradleEditorEntityTable.this.myEditingRow);
            return component == null ? null : component.getValue(GradleEditorEntityTable.this.myProject);
        }
    }

    private class MyRenderer
    implements TableCellRenderer {
        private MyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            GradleEditorCellComponent component = (GradleEditorCellComponent)GradleEditorEntityTable.this.myRendererComponents.get(row);
            if (component == null) {
                component = new GradleEditorCellComponentImpl(GradleEditorEntityTable.this);
                GradleEditorEntityTable.this.myRendererComponents.set(row, (Object)component);
            }
            return component.bind(table, value, GradleEditorEntityTable.this.myProject, row, column, false, isSelected, hasFocus);
        }
    }
}

