/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.collect.ImmutableList;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleProjectInfo {
    @NotNull
    private final Project myProject;
    @NotNull
    private final AndroidProjectInfo myProjectInfo;

    @NotNull
    public static GradleProjectInfo getInstance(@NotNull Project project) {
        if (project == null) {
            GradleProjectInfo.$$$reportNull$$$0(0);
        }
        GradleProjectInfo gradleProjectInfo = (GradleProjectInfo)ServiceManager.getService((Project)project, GradleProjectInfo.class);
        if (gradleProjectInfo == null) {
            GradleProjectInfo.$$$reportNull$$$0(1);
        }
        return gradleProjectInfo;
    }

    public GradleProjectInfo(@NotNull Project project, @NotNull AndroidProjectInfo projectInfo) {
        if (project == null) {
            GradleProjectInfo.$$$reportNull$$$0(2);
        }
        if (projectInfo == null) {
            GradleProjectInfo.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myProjectInfo = projectInfo;
    }

    public boolean hasTopLevelGradleBuildFile() {
        File projectFolderPath = Projects.getBaseDirPath(this.myProject);
        File buildFilePath = new File(projectFolderPath, "build.gradle");
        return buildFilePath.isFile();
    }

    public boolean isBuildWithGradle() {
        if (ProjectFacetManager.getInstance((Project)this.myProject).hasFacets(GradleFacet.getFacetTypeId())) {
            return true;
        }
        return GradleSyncState.getInstance(this.myProject).getSummary().getSyncTimestamp() != -1L;
    }

    @NotNull
    public List<Module> getAndroidModules() {
        ImmutableList.Builder modules = ImmutableList.builder();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            if (!Projects.isBuildWithGradle(module)) continue;
            modules.add((Object)module);
        }
        ImmutableList immutableList = modules.build();
        if (immutableList == null) {
            GradleProjectInfo.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    @Nullable
    public AndroidModuleModel findAndroidModelInModule(@NotNull VirtualFile file) {
        Module module;
        if (file == null) {
            GradleProjectInfo.$$$reportNull$$$0(5);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject)) == null) {
            VirtualFile rootFolder;
            if (this.myProjectInfo.requiresAndroidModel() && (rootFolder = this.myProject.getBaseDir()) != null) {
                for (VirtualFile parent = file.getParent(); parent != null && parent.equals(rootFolder) && (module = ModuleUtilCore.findModuleForFile((VirtualFile)parent, (Project)this.myProject)) == null; parent = parent.getParent()) {
                }
            }
            if (module == null) {
                return null;
            }
        }
        if (module.isDisposed()) {
            this.getLog().warn("Attempted to get an Android Facet from a disposed module");
            return null;
        }
        return AndroidModuleModel.get(module);
    }

    @NotNull
    private Logger getLog() {
        Logger logger = Logger.getInstance(this.getClass());
        if (logger == null) {
            GradleProjectInfo.$$$reportNull$$$0(6);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/GradleProjectInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/GradleProjectInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidModules";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findAndroidModelInModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

