/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.fd.FlightRecorder;
import com.android.tools.idea.fd.InstantRunBuildProgressListener;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.gradle.output.parser.BuildOutputParser;
import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.build.invoker.BuildStopper;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.build.invoker.TaskExecutionProgressIndicator;
import com.android.tools.idea.gradle.project.common.GradleInitScripts;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SelectSdkDialog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.ui.AppIcon;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import net.jcip.annotations.GuardedBy;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.events.ProgressListener;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

public abstract class GradleTasksExecutor
extends Task.Backgroundable {
    @NotNull
    public static final NotificationGroup LOGGING_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"Gradle Build (Logging)");
    @NotNull
    public static final NotificationGroup BALLOON_NOTIFICATION = NotificationGroup.balloonGroup((String)"Gradle Build (Balloon)");

    protected GradleTasksExecutor(@Nullable Project project) {
        super(project, "Gradle Build Running", true);
    }

    public abstract void queueAndWaitForCompletion();

    private static class GradleTasksExecutorImpl
    extends GradleTasksExecutor {
        private static final long ONE_MINUTE_MS = 60000L;
        @NonNls
        private static final String APP_ICON_ID = "compiler";
        private static final String GRADLE_RUNNING_MSG_TITLE = "Gradle Running";
        private static final String PASSWORD_KEY_SUFFIX = ".password=";
        public static final String ANDROID_ADDITIONAL_PLUGINS = "android.additional.plugins";
        public static final String COM_ANDROID_TOOLS_PROFILER = "com.android.tools.profiler";
        @NotNull
        private final Object myCompletionLock;
        @NotNull
        private final GradleBuildInvoker.Request myRequest;
        @NotNull
        private final BuildStopper myBuildStopper;
        @GuardedBy(value="myCompletionLock")
        private int myCompletionCounter;
        @NotNull
        private final GradleExecutionHelper myHelper;
        private volatile int myErrorCount;
        private volatile int myWarningCount;
        @NotNull
        private volatile ProgressIndicator myProgressIndicator;
        private CloseListener myCloseListener;

        @VisibleForTesting
        GradleTasksExecutorImpl(@NotNull GradleBuildInvoker.Request request, @NotNull BuildStopper buildStopper) {
            if (request == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(0);
            }
            if (buildStopper == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(1);
            }
            super(request.getProject());
            this.myCompletionLock = new Object();
            this.myHelper = new GradleExecutionHelper();
            this.myProgressIndicator = new EmptyProgressIndicator();
            this.myRequest = request;
            this.myBuildStopper = buildStopper;
        }

        public String getProcessId() {
            return "GradleTaskInvocation";
        }

        @Nullable
        public Task.NotificationInfo getNotificationInfo() {
            return new Task.NotificationInfo(this.myErrorCount > 0 ? "Gradle Invocation (errors)" : "Gradle Invocation (success)", "Gradle Invocation Finished", this.myErrorCount + " Errors, " + this.myWarningCount + " Warnings", true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(2);
            }
            if (IdeInfo.getInstance().isAndroidStudio()) {
                GradleUtil.clearStoredGradleJvmArgs(this.getProject());
            }
            this.myProgressIndicator = indicator;
            Project project = this.myRequest.getProject();
            this.myCloseListener = new CloseListener();
            MessageBusConnection busConnection = project.getMessageBus().connect();
            busConnection.subscribe(ProjectManager.TOPIC, (Object)this.myCloseListener);
            Semaphore semaphore = ((CompilerManagerImpl)CompilerManager.getInstance((Project)project)).getCompilationSemaphore();
            boolean acquired = false;
            try {
                try {
                    while (!acquired) {
                        acquired = semaphore.tryAcquire(300L, TimeUnit.MILLISECONDS);
                        if (!this.myProgressIndicator.isCanceled()) continue;
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.addIndicatorDelegate();
                this.invokeGradleTasks();
            }
            finally {
                try {
                    this.myProgressIndicator.stop();
                    busConnection.disconnect();
                }
                finally {
                    if (acquired) {
                        semaphore.release();
                    }
                }
            }
        }

        private void addIndicatorDelegate() {
            if (this.myProgressIndicator instanceof ProgressIndicatorEx) {
                ProgressIndicatorEx indicator = (ProgressIndicatorEx)this.myProgressIndicator;
                indicator.addStateDelegate((ProgressIndicatorEx)new ProgressIndicatorStateDelegate(this.myRequest.getTaskId(), this.myBuildStopper));
            }
        }

        private void invokeGradleTasks() {
            Application application;
            Runnable task;
            Project project = this.myRequest.getProject();
            GradleExecutionSettings executionSettings = GradleUtil.getOrCreateGradleExecutionSettings(project, this.myRequest.isUseEmbeddedGradle());
            Function executeTasksFunction = connection -> {
                block27: {
                    String testOutput;
                    ExternalSystemTaskId id;
                    InstantRunBuildProgressListener instantRunProgressListener;
                    Throwable buildError;
                    StringBuilder output;
                    Stopwatch stopwatch;
                    block25: {
                        ExternalSystemTaskNotificationListener taskListener;
                        block30: {
                            block26: {
                                stopwatch = Stopwatch.createStarted();
                                List<String> gradleTasks = this.myRequest.getGradleTasks();
                                String executingTasksText = "Executing tasks: " + gradleTasks;
                                this.addToEventLog(executingTasksText, MessageType.INFO);
                                output = new StringBuilder();
                                buildError = null;
                                instantRunProgressListener = null;
                                id = this.myRequest.getTaskId();
                                taskListener = this.myRequest.getTaskListener();
                                CancellationTokenSource cancellationTokenSource = this.myBuildStopper.createAndRegisterTokenSource(id);
                                if (taskListener != null) {
                                    taskListener.onStart(id, this.myRequest.getBuildFilePath().getPath());
                                    taskListener.onTaskOutput(id, executingTasksText + SystemProperties.getLineSeparator() + SystemProperties.getLineSeparator(), true);
                                }
                                try {
                                    String logMessage;
                                    AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(project);
                                    ArrayList commandLineArguments = Lists.newArrayList((Object[])buildConfiguration.getCommandLineOptions());
                                    if (buildConfiguration.USE_CONFIGURATION_ON_DEMAND && !commandLineArguments.contains("--configure-on-demand")) {
                                        commandLineArguments.add("--configure-on-demand");
                                    }
                                    if (!commandLineArguments.contains("--parallel") && CompilerWorkspaceConfiguration.getInstance((Project)project).PARALLEL_COMPILATION) {
                                        commandLineArguments.add("--parallel");
                                    }
                                    commandLineArguments.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.invoked.from.ide", (boolean)true));
                                    commandLineArguments.addAll(this.myRequest.getCommandLineArguments());
                                    GradleInitScripts initScripts = GradleInitScripts.getInstance();
                                    initScripts.addLocalMavenRepoInitScriptCommandLineArgTo(commandLineArguments);
                                    GradleUtil.attemptToUseEmbeddedGradle(project);
                                    if (System.getProperty("enable.experimental.profiling") != null) {
                                        initScripts.addProfilerClasspathInitScriptCommandLineArgTo(commandLineArguments);
                                        commandLineArguments.add(AndroidGradleSettings.createProjectProperty((String)ANDROID_ADDITIONAL_PLUGINS, (String)COM_ANDROID_TOOLS_PROFILER));
                                    }
                                    if ((logMessage = "Build command line options: " + commandLineArguments).contains(PASSWORD_KEY_SUFFIX)) {
                                        ArrayList<String> replaced = new ArrayList<String>(commandLineArguments.size());
                                        for (String option : commandLineArguments) {
                                            int index = option.indexOf(PASSWORD_KEY_SUFFIX);
                                            if (index == -1) {
                                                replaced.add(option);
                                                continue;
                                            }
                                            replaced.add(option.substring(0, index + PASSWORD_KEY_SUFFIX.length()) + "*********");
                                        }
                                        logMessage = ((Object)replaced).toString();
                                    }
                                    GradleTasksExecutorImpl.getLogger().info(logMessage);
                                    executionSettings.withVmOptions(this.myRequest.getJvmArguments()).withArguments((Collection)commandLineArguments).withEnvironmentVariables(this.myRequest.getEnv()).passParentEnvs(this.myRequest.isPassParentEnvs());
                                    BuildLauncher launcher = connection.newBuild();
                                    GradleExecutionHelper.prepare((LongRunningOperation)launcher, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)new ExternalSystemTaskNotificationListenerAdapter(){

                                        public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                                            if (event == null) {
                                                1.$$$reportNull$$$0(0);
                                            }
                                            if (taskListener != null && myBuildStopper.contains(id)) {
                                                taskListener.onStatusChange(event);
                                            }
                                        }

                                        public void onTaskOutput(@NotNull ExternalSystemTaskId id2, @NotNull String text, boolean stdOut) {
                                            if (id2 == null) {
                                                1.$$$reportNull$$$0(1);
                                            }
                                            if (text == null) {
                                                1.$$$reportNull$$$0(2);
                                            }
                                            output.append(text);
                                            if (taskListener != null && myBuildStopper.contains(id2)) {
                                                taskListener.onTaskOutput(id2, text, stdOut);
                                            }
                                        }

                                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                            Object[] objectArray;
                                            Object[] objectArray2;
                                            Object[] objectArray3 = new Object[3];
                                            switch (n) {
                                                default: {
                                                    objectArray2 = objectArray3;
                                                    objectArray3[0] = "event";
                                                    break;
                                                }
                                                case 1: {
                                                    objectArray2 = objectArray3;
                                                    objectArray3[0] = "id";
                                                    break;
                                                }
                                                case 2: {
                                                    objectArray2 = objectArray3;
                                                    objectArray3[0] = "text";
                                                    break;
                                                }
                                            }
                                            objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutor$GradleTasksExecutorImpl$1";
                                            switch (n) {
                                                default: {
                                                    objectArray = objectArray2;
                                                    objectArray2[2] = "onStatusChange";
                                                    break;
                                                }
                                                case 1: 
                                                case 2: {
                                                    objectArray = objectArray2;
                                                    objectArray2[2] = "onTaskOutput";
                                                    break;
                                                }
                                            }
                                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                                        }
                                    }, (ProjectConnection)connection);
                                    File javaHome = IdeSdks.getInstance().getJdkPath();
                                    if (javaHome != null) {
                                        launcher.setJavaHome(javaHome);
                                    }
                                    launcher.forTasks(ArrayUtil.toStringArray(gradleTasks));
                                    launcher.withCancellationToken(cancellationTokenSource.token());
                                    if (InstantRunSettings.isInstantRunEnabled() && InstantRunSettings.isRecorderEnabled()) {
                                        instantRunProgressListener = new InstantRunBuildProgressListener();
                                        launcher.addProgressListener((ProgressListener)instantRunProgressListener);
                                    }
                                    launcher.run();
                                    if (!this.myBuildStopper.contains(id) || taskListener == null) break block25;
                                    if (buildError == null) break block26;
                                }
                                catch (BuildException e) {
                                    buildError = e;
                                    break block27;
                                }
                                catch (Throwable e2) {
                                    String testOutput2;
                                    block28: {
                                        block31: {
                                            block29: {
                                                buildError = e2;
                                                this.handleTaskExecutionError(e2);
                                                if (!this.myBuildStopper.contains(id) || taskListener == null) break block28;
                                                if (buildError == null) break block29;
                                                {
                                                    catch (Throwable throwable) {
                                                        throw throwable;
                                                    }
                                                }
                                                Throwable rootCause = ExceptionUtil.getRootCause((Throwable)buildError);
                                                taskListener.onFailure(id, (Exception)new ExternalSystemException(ExceptionUtil.getMessage((Throwable)rootCause)));
                                                break block31;
                                            }
                                            taskListener.onSuccess(id);
                                        }
                                        taskListener.onEnd(id);
                                    }
                                    this.myBuildStopper.remove(id);
                                    String gradleOutput = output.toString();
                                    if (instantRunProgressListener != null) {
                                        FlightRecorder.get(this.myProject).saveBuildOutput(gradleOutput, instantRunProgressListener);
                                    }
                                    Application application = ApplicationManager.getApplication();
                                    if (AndroidPlugin.isGuiTestingMode() && StringUtil.isNotEmpty((String)(testOutput2 = (String)application.getUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY)))) {
                                        gradleOutput = testOutput2;
                                        application.putUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY, null);
                                    }
                                    this.executeAfterGradleTasks(gradleOutput, stopwatch, buildError);
                                    break block27;
                                }
                                finally {
                                    String testOutput3;
                                    if (this.myBuildStopper.contains(id) && taskListener != null) {
                                        if (buildError != null) {
                                            Throwable rootCause = ExceptionUtil.getRootCause((Throwable)buildError);
                                            taskListener.onFailure(id, (Exception)new ExternalSystemException(ExceptionUtil.getMessage((Throwable)rootCause)));
                                        } else {
                                            taskListener.onSuccess(id);
                                        }
                                        taskListener.onEnd(id);
                                    }
                                    this.myBuildStopper.remove(id);
                                    String gradleOutput = output.toString();
                                    if (instantRunProgressListener != null) {
                                        FlightRecorder.get(this.myProject).saveBuildOutput(gradleOutput, instantRunProgressListener);
                                    }
                                    Application application = ApplicationManager.getApplication();
                                    if (AndroidPlugin.isGuiTestingMode() && StringUtil.isNotEmpty((String)(testOutput3 = (String)application.getUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY)))) {
                                        gradleOutput = testOutput3;
                                        application.putUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY, null);
                                    }
                                    this.executeAfterGradleTasks(gradleOutput, stopwatch, buildError);
                                }
                                Throwable rootCause = ExceptionUtil.getRootCause((Throwable)buildError);
                                taskListener.onFailure(id, (Exception)new ExternalSystemException(ExceptionUtil.getMessage((Throwable)rootCause)));
                                break block30;
                            }
                            taskListener.onSuccess(id);
                        }
                        taskListener.onEnd(id);
                    }
                    this.myBuildStopper.remove(id);
                    String gradleOutput = output.toString();
                    if (instantRunProgressListener != null) {
                        FlightRecorder.get(this.myProject).saveBuildOutput(gradleOutput, instantRunProgressListener);
                    }
                    Application application = ApplicationManager.getApplication();
                    if (AndroidPlugin.isGuiTestingMode() && StringUtil.isNotEmpty((String)(testOutput = (String)application.getUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY)))) {
                        gradleOutput = testOutput;
                        application.putUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY, null);
                    }
                    this.executeAfterGradleTasks(gradleOutput, stopwatch, buildError);
                }
                return null;
            };
            if (AndroidPlugin.isGuiTestingMode() && (task = (Runnable)(application = ApplicationManager.getApplication()).getUserData(AndroidPlugin.EXECUTE_BEFORE_PROJECT_BUILD_IN_GUI_TEST_KEY)) != null) {
                application.putUserData(AndroidPlugin.EXECUTE_BEFORE_PROJECT_BUILD_IN_GUI_TEST_KEY, null);
                task.run();
            }
            this.myHelper.execute(this.myRequest.getBuildFilePath().getPath(), executionSettings, executeTasksFunction);
        }

        private void executeAfterGradleTasks(@NotNull String gradleOutput, @NotNull Stopwatch stopwatch, @Nullable Throwable buildError) {
            if (gradleOutput == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(3);
            }
            if (stopwatch == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(4);
            }
            Application application = ApplicationManager.getApplication();
            ArrayList<Message> buildMessages = new ArrayList<Message>();
            GradleTasksExecutorImpl.collectMessages(gradleOutput, buildMessages).doWhenDone(() -> {
                if (stopwatch == null) {
                    GradleTasksExecutorImpl.$$$reportNull$$$0(18);
                }
                stopwatch.stop();
                this.add(buildMessages);
                application.invokeLater(() -> {
                    if (stopwatch == null) {
                        GradleTasksExecutorImpl.$$$reportNull$$$0(19);
                    }
                    this.notifyGradleInvocationCompleted(stopwatch.elapsed(TimeUnit.MILLISECONDS));
                });
                if (this.getProject().isDisposed()) {
                    return;
                }
                boolean buildSuccessful = buildError == null;
                GradleInvocationResult result = new GradleInvocationResult(this.myRequest.getGradleTasks(), buildMessages, buildSuccessful);
                for (GradleBuildInvoker.AfterGradleInvocationTask task : GradleBuildInvoker.getInstance(this.getProject()).getAfterInvocationTasks()) {
                    task.execute(result);
                }
            });
        }

        @NotNull
        private static ActionCallback collectMessages(@NotNull String gradleOutput, @NotNull List<Message> messages) {
            if (gradleOutput == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(5);
            }
            if (messages == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(6);
            }
            ActionCallback callback = new ActionCallback();
            Runnable task = () -> {
                if (gradleOutput == null) {
                    GradleTasksExecutorImpl.$$$reportNull$$$0(16);
                }
                if (messages == null) {
                    GradleTasksExecutorImpl.$$$reportNull$$$0(17);
                }
                Iterable parsers = JpsServiceManager.getInstance().getExtensions(PatternAwareOutputParser.class);
                List compilerMessages = new BuildOutputParser(parsers).parseGradleOutput(gradleOutput, true);
                messages.addAll(compilerMessages);
                callback.setDone();
            };
            Application application = ApplicationManager.getApplication();
            if (application.isUnitTestMode()) {
                task.run();
            } else {
                application.executeOnPooledThread(task);
            }
            ActionCallback actionCallback = callback;
            if (actionCallback == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(7);
            }
            return actionCallback;
        }

        private void add(@NotNull List<Message> buildMessages) {
            if (buildMessages == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(8);
            }
            Runnable addMessageTask = () -> {
                if (buildMessages == null) {
                    GradleTasksExecutorImpl.$$$reportNull$$$0(15);
                }
                for (Message message : buildMessages) {
                    this.incrementErrorOrWarningCount(message);
                }
            };
            ApplicationManager.getApplication().invokeLater(addMessageTask, ModalityState.NON_MODAL);
        }

        private void handleTaskExecutionError(@NotNull Throwable e) {
            if (e == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(9);
            }
            if (this.myProgressIndicator.isCanceled()) {
                GradleTasksExecutorImpl.getLogger().info("Failed to complete Gradle execution. Project may be closing or already closed.", e);
                return;
            }
            Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
            String error = Strings.nullToEmpty((String)rootCause.getMessage());
            if (error.contains("Build cancelled")) {
                return;
            }
            Runnable showErrorTask = () -> {
                String msg = "Failed to complete Gradle execution.";
                msg = StringUtil.isEmpty((String)error) ? msg + " Cause: unknown." : msg + "\n\nCause:\n" + error;
                this.incrementErrorOrWarningCount(new Message(Message.Kind.ERROR, msg, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]));
                if (IdeInfo.getInstance().isAndroidStudio() && error.startsWith("Supplied javaHome is not a valid folder")) {
                    IdeSdks ideSdks = IdeSdks.getInstance();
                    File androidHome = ideSdks.getAndroidSdkPath();
                    String androidSdkPath = androidHome != null ? androidHome.getPath() : null;
                    SelectSdkDialog selectSdkDialog = new SelectSdkDialog(null, androidSdkPath);
                    selectSdkDialog.setModal(true);
                    if (selectSdkDialog.showAndGet()) {
                        String jdkHome = selectSdkDialog.getJdkHome();
                        UIUtil.invokeLaterIfNeeded(() -> ApplicationManager.getApplication().runWriteAction(() -> ideSdks.setJdkPath(new File(jdkHome))));
                    }
                }
            };
            AppUIUtil.invokeLaterIfProjectAlive((Project)this.myRequest.getProject(), (Runnable)showErrorTask);
        }

        private void incrementErrorOrWarningCount(@NotNull Message message) {
            Message.Kind kind;
            if (message == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(10);
            }
            if ((kind = message.getKind()) == Message.Kind.WARNING) {
                ++this.myWarningCount;
            } else if (kind == Message.Kind.ERROR) {
                ++this.myErrorCount;
            }
        }

        @NotNull
        private static Logger getLogger() {
            Logger logger = Logger.getInstance(GradleBuildInvoker.class);
            if (logger == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(11);
            }
            return logger;
        }

        private void notifyGradleInvocationCompleted(long durationMillis) {
            Project project = this.myRequest.getProject();
            if (!project.isDisposed()) {
                MessageType messageType;
                String statusMsg = this.createStatusMessage(durationMillis);
                MessageType messageType2 = this.myErrorCount > 0 ? MessageType.ERROR : (messageType = this.myWarningCount > 0 ? MessageType.WARNING : MessageType.INFO);
                if (durationMillis > 60000L) {
                    BALLOON_NOTIFICATION.createNotification(statusMsg, messageType).notify(project);
                } else {
                    this.addToEventLog(statusMsg, messageType);
                }
            }
        }

        @NotNull
        private String createStatusMessage(long durationMillis) {
            String message = "Gradle build finished";
            if (this.myErrorCount > 0) {
                message = this.myWarningCount > 0 ? message + String.format(" with %d error(s) and %d warning(s)", this.myErrorCount, this.myWarningCount) : message + String.format(" with %d error(s)", this.myErrorCount);
            } else if (this.myWarningCount > 0) {
                message = message + String.format(" with %d warnings(s)", this.myWarningCount);
            }
            String string = message = message + " in " + StringUtil.formatDuration((long)durationMillis);
            if (string == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(12);
            }
            return string;
        }

        private void addToEventLog(@NotNull String message, @NotNull MessageType type) {
            if (message == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(13);
            }
            if (type == null) {
                GradleTasksExecutorImpl.$$$reportNull$$$0(14);
            }
            LOGGING_NOTIFICATION.createNotification(message, type).notify(this.myProject);
        }

        private void attemptToStopBuild() {
            this.myBuildStopper.attemptToStopBuild(this.myRequest.getTaskId(), this.myProgressIndicator);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void queueAndWaitForCompletion() {
            int counterBefore;
            Object object = this.myCompletionLock;
            synchronized (object) {
                counterBefore = this.myCompletionCounter;
            }
            UIUtil.invokeLaterIfNeeded(() -> ((GradleTasksExecutorImpl)this).queue());
            object = this.myCompletionLock;
            synchronized (object) {
                while (this.myCompletionCounter <= counterBefore) {
                    try {
                        this.myCompletionLock.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
        }

        public void onSuccess() {
            super.onSuccess();
            this.onCompletion();
        }

        public void onCancel() {
            super.onCancel();
            this.onCompletion();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onCompletion() {
            Object object = this.myCompletionLock;
            synchronized (object) {
                ++this.myCompletionCounter;
                this.myCompletionLock.notifyAll();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 11: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildStopper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: 
                case 5: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleOutput";
                    break;
                }
                case 4: 
                case 18: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stopwatch";
                    break;
                }
                case 6: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messages";
                    break;
                }
                case 7: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutor$GradleTasksExecutorImpl";
                    break;
                }
                case 8: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildMessages";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutor$GradleTasksExecutorImpl";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectMessages";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogger";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStatusMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "executeAfterGradleTasks";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "collectMessages";
                    break;
                }
                case 7: 
                case 11: 
                case 12: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "handleTaskExecutionError";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "incrementErrorOrWarningCount";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "addToEventLog";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$add$4";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$collectMessages$3";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$executeAfterGradleTasks$2";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$1";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class ProgressIndicatorStateDelegate
        extends TaskExecutionProgressIndicator {
            ProgressIndicatorStateDelegate(@NotNull ExternalSystemTaskId taskId, BuildStopper buildStopper) {
                if (taskId == null) {
                    ProgressIndicatorStateDelegate.$$$reportNull$$$0(0);
                }
                if (buildStopper == null) {
                    ProgressIndicatorStateDelegate.$$$reportNull$$$0(1);
                }
                super(taskId, buildStopper);
            }

            @Override
            void onCancel() {
                this.stopAppIconProgress();
            }

            public void stop() {
                super.stop();
                this.stopAppIconProgress();
            }

            private void stopAppIconProgress() {
                UIUtil.invokeLaterIfNeeded(() -> {
                    Project project;
                    AppIcon appIcon = AppIcon.getInstance();
                    if (appIcon.hideProgress(project = GradleTasksExecutorImpl.this.myRequest.getProject(), (Object)GradleTasksExecutorImpl.APP_ICON_ID)) {
                        if (GradleTasksExecutorImpl.this.myErrorCount > 0) {
                            appIcon.setErrorBadge(project, String.valueOf(GradleTasksExecutorImpl.this.myErrorCount));
                            appIcon.requestAttention(project, true);
                        } else {
                            appIcon.setOkBadge(project, true);
                            appIcon.requestAttention(project, false);
                        }
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "taskId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "buildStopper";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutor$GradleTasksExecutorImpl$ProgressIndicatorStateDelegate";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class CloseListener
        extends ContentManagerAdapter
        implements VetoableProjectManagerListener {
            private boolean myIsApplicationExitingOrProjectClosing;
            private boolean myUserAcceptedCancel;

            private CloseListener() {
            }

            public boolean canClose(@NotNull Project project) {
                if (project == null) {
                    CloseListener.$$$reportNull$$$0(0);
                }
                if (project != GradleTasksExecutorImpl.this.myProject) {
                    return true;
                }
                if (this.shouldPromptUser()) {
                    this.myUserAcceptedCancel = this.askUserToCancelGradleExecution();
                    if (!this.myUserAcceptedCancel) {
                        return false;
                    }
                    GradleTasksExecutorImpl.this.attemptToStopBuild();
                    return true;
                }
                return !GradleTasksExecutorImpl.this.myProgressIndicator.isRunning();
            }

            public void projectClosing(Project project) {
                if (project.equals(GradleTasksExecutorImpl.this.myProject)) {
                    this.myIsApplicationExitingOrProjectClosing = true;
                }
            }

            private boolean shouldPromptUser() {
                return !this.myUserAcceptedCancel && !this.myIsApplicationExitingOrProjectClosing && GradleTasksExecutorImpl.this.myProgressIndicator.isRunning();
            }

            private boolean askUserToCancelGradleExecution() {
                String msg = "Gradle is running. Proceed with Project closing?";
                int result = Messages.showYesNoDialog((Project)GradleTasksExecutorImpl.this.myProject, (String)msg, (String)GradleTasksExecutorImpl.GRADLE_RUNNING_MSG_TITLE, (Icon)Messages.getQuestionIcon());
                return result == 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutor$GradleTasksExecutorImpl$CloseListener", "canClose"));
            }
        }
    }

    static class Factory {
        Factory() {
        }

        @NotNull
        GradleTasksExecutor create(@NotNull GradleBuildInvoker.Request request, @NotNull BuildStopper buildStopper) {
            if (request == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (buildStopper == null) {
                Factory.$$$reportNull$$$0(1);
            }
            GradleTasksExecutorImpl gradleTasksExecutorImpl = new GradleTasksExecutorImpl(request, buildStopper);
            if (gradleTasksExecutorImpl == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return gradleTasksExecutorImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildStopper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutor$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleTasksExecutor$Factory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

