/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleContentRoot;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;

public class JavaModuleModel
implements ModuleModel {
    private static final long serialVersionUID = 1L;
    @NotNull
    private String myModuleName;
    @NotNull
    private Collection<JavaModuleContentRoot> myContentRoots;
    @NotNull
    private Collection<JavaModuleDependency> myJavaModuleDependencies;
    @NotNull
    private Collection<JarLibraryDependency> myJarLibraryDependencies;
    @NotNull
    private Map<String, Set<File>> myArtifactsByConfiguration;
    @NotNull
    private List<String> myConfigurations;
    @Nullable
    private ExtIdeaCompilerOutput myCompilerOutput;
    @Nullable
    private File myBuildFolderPath;
    @Nullable
    private String myLanguageLevel;
    private boolean myBuildable;
    private boolean myAndroidModuleWithoutVariants;

    public JavaModuleModel(@NotNull IdeaModule ideaModule, @Nullable ModuleExtendedModel javaModel, boolean androidModuleWithoutVariants) {
        if (ideaModule == null) {
            JavaModuleModel.$$$reportNull$$$0(0);
        }
        this(ideaModule.getName(), JavaModuleModel.getContentRoots(ideaModule, javaModel), JavaModuleModel.getDependencies(ideaModule), JavaModuleModel.getArtifactsByConfiguration(javaModel), JavaModuleModel.getCompilerOutput(javaModel), ideaModule.getGradleProject().getBuildDirectory(), JavaModuleModel.getLanguageLevel(javaModel), !androidModuleWithoutVariants && JavaModuleModel.isBuildable(ideaModule), androidModuleWithoutVariants);
    }

    @Nullable
    private static ExtIdeaCompilerOutput getCompilerOutput(@Nullable ModuleExtendedModel javaModel) {
        return javaModel != null ? javaModel.getCompilerOutput() : null;
    }

    @NotNull
    private static Collection<? extends IdeaContentRoot> getContentRoots(@NotNull IdeaModule ideaModule, @Nullable ModuleExtendedModel javaModel) {
        DomainObjectSet contentRoots;
        if (ideaModule == null) {
            JavaModuleModel.$$$reportNull$$$0(1);
        }
        DomainObjectSet domainObjectSet = contentRoots = javaModel != null ? javaModel.getContentRoots() : null;
        if (contentRoots == null) {
            contentRoots = ideaModule.getContentRoots();
        }
        Object object = contentRoots != null ? contentRoots : Collections.emptyList();
        if (object == null) {
            JavaModuleModel.$$$reportNull$$$0(2);
        }
        return object;
    }

    @NotNull
    private static Map<String, Set<File>> getArtifactsByConfiguration(@Nullable ModuleExtendedModel javaModel) {
        Map artifactsByConfiguration = Collections.emptyMap();
        if (javaModel != null) {
            artifactsByConfiguration = javaModel.getArtifactsByConfiguration();
        }
        Map map = artifactsByConfiguration;
        if (map == null) {
            JavaModuleModel.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    private static List<? extends IdeaDependency> getDependencies(@NotNull IdeaModule ideaModule) {
        List dependencies;
        if (ideaModule == null) {
            JavaModuleModel.$$$reportNull$$$0(4);
        }
        if ((dependencies = ideaModule.getDependencies().getAll()) != null) {
            List list = dependencies;
            if (list == null) {
                JavaModuleModel.$$$reportNull$$$0(5);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            JavaModuleModel.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static boolean isBuildable(@NotNull IdeaModule ideaModule) {
        if (ideaModule == null) {
            JavaModuleModel.$$$reportNull$$$0(7);
        }
        for (GradleTask task : ideaModule.getGradleProject().getTasks()) {
            if (!"compileJava".equals(task.getName())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String getLanguageLevel(@Nullable ModuleExtendedModel javaModel) {
        return javaModel != null ? javaModel.getJavaSourceCompatibility() : null;
    }

    public JavaModuleModel(@NotNull String name, @NotNull Collection<? extends IdeaContentRoot> contentRoots, @NotNull List<? extends IdeaDependency> dependencies, @Nullable Map<String, Set<File>> artifactsByConfiguration, @Nullable ExtIdeaCompilerOutput compilerOutput, @Nullable File buildFolderPath, @Nullable String languageLevel, boolean buildable, boolean androidModuleWithoutVariants) {
        if (name == null) {
            JavaModuleModel.$$$reportNull$$$0(8);
        }
        if (contentRoots == null) {
            JavaModuleModel.$$$reportNull$$$0(9);
        }
        if (dependencies == null) {
            JavaModuleModel.$$$reportNull$$$0(10);
        }
        this.myContentRoots = new ArrayList<JavaModuleContentRoot>();
        this.myJavaModuleDependencies = new ArrayList<JavaModuleDependency>();
        this.myJarLibraryDependencies = new ArrayList<JarLibraryDependency>();
        this.myModuleName = name;
        for (IdeaContentRoot ideaContentRoot : contentRoots) {
            if (ideaContentRoot == null) continue;
            this.myContentRoots.add(JavaModuleContentRoot.copy(ideaContentRoot));
        }
        for (IdeaDependency ideaDependency : dependencies) {
            JavaModuleDependency moduleDependency;
            if (ideaDependency instanceof IdeaSingleEntryLibraryDependency) {
                JarLibraryDependency libraryDependency = JarLibraryDependency.copy((IdeaSingleEntryLibraryDependency)ideaDependency);
                if (libraryDependency == null) continue;
                this.myJarLibraryDependencies.add(libraryDependency);
                continue;
            }
            if (!(ideaDependency instanceof IdeaModuleDependency) || (moduleDependency = JavaModuleDependency.copy((IdeaModuleDependency)ideaDependency)) == null) continue;
            this.myJavaModuleDependencies.add(moduleDependency);
        }
        this.myArtifactsByConfiguration = artifactsByConfiguration != null ? artifactsByConfiguration : Collections.emptyMap();
        this.myConfigurations = new ArrayList<String>(this.myArtifactsByConfiguration.keySet());
        Collections.sort(this.myConfigurations);
        this.myCompilerOutput = compilerOutput;
        this.myBuildFolderPath = buildFolderPath;
        this.myLanguageLevel = languageLevel;
        this.myBuildable = buildable;
        this.myAndroidModuleWithoutVariants = androidModuleWithoutVariants;
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            JavaModuleModel.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public Collection<JavaModuleContentRoot> getContentRoots() {
        Collection<JavaModuleContentRoot> collection = this.myContentRoots;
        if (collection == null) {
            JavaModuleModel.$$$reportNull$$$0(12);
        }
        return collection;
    }

    public boolean containsSourceFile(@NotNull File file) {
        if (file == null) {
            JavaModuleModel.$$$reportNull$$$0(13);
        }
        for (JavaModuleContentRoot contentRoot : this.getContentRoots()) {
            if (contentRoot == null || !JavaModuleModel.containsFile(contentRoot, file)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsFile(@NotNull JavaModuleContentRoot contentRoot, @NotNull File file) {
        if (contentRoot == null) {
            JavaModuleModel.$$$reportNull$$$0(14);
        }
        if (file == null) {
            JavaModuleModel.$$$reportNull$$$0(15);
        }
        return JavaModuleModel.containsFile(contentRoot.getSourceDirPaths(), file) || JavaModuleModel.containsFile(contentRoot.getTestDirPaths(), file) || JavaModuleModel.containsFile(contentRoot.getResourceDirPaths(), file) || JavaModuleModel.containsFile(contentRoot.getGenSourceDirPaths(), file) || JavaModuleModel.containsFile(contentRoot.getGenTestDirPaths(), file) || JavaModuleModel.containsFile(contentRoot.getTestResourceDirPaths(), file);
    }

    private static boolean containsFile(@NotNull Collection<File> folderPaths, @NotNull File file) {
        if (folderPaths == null) {
            JavaModuleModel.$$$reportNull$$$0(16);
        }
        if (file == null) {
            JavaModuleModel.$$$reportNull$$$0(17);
        }
        for (File path : folderPaths) {
            if (!FileUtil.isAncestor((File)path, (File)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Map<String, Set<File>> getArtifactsByConfiguration() {
        Map<String, Set<File>> map = this.myArtifactsByConfiguration;
        if (map == null) {
            JavaModuleModel.$$$reportNull$$$0(18);
        }
        return map;
    }

    @Nullable
    public ExtIdeaCompilerOutput getCompilerOutput() {
        return this.myCompilerOutput;
    }

    @Nullable
    public File getBuildFolderPath() {
        return this.myBuildFolderPath;
    }

    @NotNull
    public Collection<JavaModuleDependency> getJavaModuleDependencies() {
        Collection<JavaModuleDependency> collection = this.myJavaModuleDependencies;
        if (collection == null) {
            JavaModuleModel.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @NotNull
    public Collection<JarLibraryDependency> getJarLibraryDependencies() {
        Collection<JarLibraryDependency> collection = this.myJarLibraryDependencies;
        if (collection == null) {
            JavaModuleModel.$$$reportNull$$$0(20);
        }
        return collection;
    }

    public boolean isBuildable() {
        return this.myBuildable;
    }

    public boolean isAndroidModuleWithoutVariants() {
        return this.myAndroidModuleWithoutVariants;
    }

    @Nullable
    public LanguageLevel getJavaLanguageLevel() {
        if (this.myLanguageLevel != null) {
            return LanguageLevel.parse((String)this.myLanguageLevel);
        }
        return null;
    }

    @NotNull
    public List<String> getConfigurations() {
        List<String> list = this.myConfigurations;
        if (list == null) {
            JavaModuleModel.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaModule";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/model/JavaModuleModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoots";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/model/JavaModuleModel";
                break;
            }
            case 2: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 3: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactsByConfiguration";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaModuleDependencies";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarLibraryDependencies";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getContentRoots";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isBuildable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "containsSourceFile";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "containsFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

