/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.hyperlink.DisableOfflineModeHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallArtifactHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallRepositoryHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.ShowDependencyInProjectStructureHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.PositionInFile;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioSdkUtil;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NonNavigatable;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public class UnresolvedDependenciesReporter
extends BaseSyncIssuesReporter {
    @NotNull
    public static UnresolvedDependenciesReporter getInstance() {
        UnresolvedDependenciesReporter unresolvedDependenciesReporter = (UnresolvedDependenciesReporter)ServiceManager.getService(UnresolvedDependenciesReporter.class);
        if (unresolvedDependenciesReporter == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(0);
        }
        return unresolvedDependenciesReporter;
    }

    @Override
    int getSupportedIssueType() {
        return 2;
    }

    @Override
    void report(@NotNull SyncIssue syncIssue, @NotNull Module module, @Nullable VirtualFile buildFile) {
        if (syncIssue == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(1);
        }
        if (module == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(2);
        }
        String dependency = syncIssue.getData();
        assert (dependency != null);
        this.report(dependency, module, buildFile);
    }

    public void report(@NotNull Collection<String> unresolvedDependencies, @NotNull Module module) {
        if (unresolvedDependencies == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(3);
        }
        if (module == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(4);
        }
        if (unresolvedDependencies.isEmpty()) {
            return;
        }
        VirtualFile buildFile = GradleUtil.getGradleBuildFile(module);
        for (String dependency : unresolvedDependencies) {
            this.report(dependency, module, buildFile);
        }
        GradleSyncState.getInstance(module.getProject()).getSummary().setSyncErrorsFound(true);
    }

    private void report(@NotNull String dependency, @NotNull Module module, @Nullable VirtualFile buildFile) {
        SyncMessage message;
        if (dependency == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(5);
        }
        if (module == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(6);
        }
        String group = "Unresolved Android dependencies";
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)dependency);
        RepoPackage constraintPackage = null;
        if (coordinate != null) {
            StudioLoggerProgressIndicator indicator = new StudioLoggerProgressIndicator(this.getClass());
            StudioSdkUtil.reloadRemoteSdkWithModalProgress();
            Collection<RemotePackage> remotePackages = UnresolvedDependenciesReporter.getRemotePackages((ProgressIndicator)indicator);
            constraintPackage = SdkMavenRepository.findBestPackageMatching((GradleCoordinate)coordinate, remotePackages);
        }
        ArrayList<NotificationHyperlink> quickFixes = new ArrayList<NotificationHyperlink>();
        if (dependency.startsWith("com.android.support.constraint:constraint-layout:") && !UnresolvedDependenciesReporter.canGetConstraintLayoutFromSdkManager(module)) {
            quickFixes.add(new FixAndroidGradlePluginVersionHyperlink());
        } else if (constraintPackage != null) {
            quickFixes.add(new InstallArtifactHyperlink(constraintPackage.getPath()));
        } else if (dependency.startsWith("com.android.support")) {
            quickFixes.add(new InstallRepositoryHyperlink(SdkMavenRepository.ANDROID));
        } else if (dependency.startsWith("com.google.android")) {
            quickFixes.add(new InstallRepositoryHyperlink(SdkMavenRepository.GOOGLE));
        } else {
            group = "Unresolved dependencies";
            Project project = module.getProject();
            if (Projects.isOfflineBuildModeEnabled(project)) {
                quickFixes.add(new DisableOfflineModeHyperlink());
            }
        }
        String text = "Failed to resolve: " + dependency;
        if (buildFile != null) {
            PositionInFile position = UnresolvedDependenciesReporter.findDependencyPosition(dependency, buildFile);
            message = new SyncMessage(module.getProject(), group, MessageType.ERROR, position, text);
            String hyperlinkText = position.line > -1 ? "Show in File" : "Open File";
            quickFixes.add(new OpenFileHyperlink(buildFile.getPath(), hyperlinkText, position.line, position.column));
        } else {
            message = new SyncMessage(group, MessageType.ERROR, NonNavigatable.INSTANCE, text);
        }
        if (IdeInfo.getInstance().isAndroidStudio() && coordinate != null) {
            quickFixes.add(new ShowDependencyInProjectStructureHyperlink(module, coordinate));
        }
        message.add(quickFixes);
        this.getSyncMessages(module).report(message);
    }

    @NotNull
    private static PositionInFile findDependencyPosition(@NotNull String dependency, @NotNull VirtualFile buildFile) {
        TextRange textRange;
        if (dependency == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(7);
        }
        if (buildFile == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(8);
        }
        int line = -1;
        int column = -1;
        Document document = FileDocumentManager.getInstance().getDocument(buildFile);
        if (document != null && (textRange = UnresolvedDependenciesReporter.findDependency(dependency, document)) != null && (line = document.getLineNumber(textRange.getStartOffset())) > -1) {
            int lineStartOffset = document.getLineStartOffset(line);
            column = textRange.getStartOffset() - lineStartOffset;
        }
        PositionInFile positionInFile = new PositionInFile(buildFile, line, column);
        if (positionInFile == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(9);
        }
        return positionInFile;
    }

    @NotNull
    private static Collection<RemotePackage> getRemotePackages(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(10);
        }
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        RepositoryPackages packages = sdkHandler.getSdkManager(indicator).getPackages();
        Collection<RemotePackage> collection = packages.getRemotePackages().values();
        if (collection == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(11);
        }
        return collection;
    }

    private static boolean canGetConstraintLayoutFromSdkManager(@NotNull Module module) {
        AndroidModuleModel gradleModel;
        if (module == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(12);
        }
        return (gradleModel = AndroidModuleModel.get(module)) != null && gradleModel.getFeatures().isConstraintLayoutSdkLocationSupported();
    }

    @Nullable
    private static TextRange findDependency(@NotNull String dependency, @NotNull Document buildFile) {
        if (dependency == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(13);
        }
        if (buildFile == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(14);
        }
        Function consumer = pair -> {
            GroovyLexer lexer = (GroovyLexer)pair.getSecond();
            return TextRange.create((int)(lexer.getTokenStart() + 1), (int)(lexer.getTokenEnd() - 1));
        };
        GroovyLexer lexer = new GroovyLexer();
        lexer.start((CharSequence)buildFile.getText());
        while (lexer.getTokenType() != null) {
            String text;
            IElementType type = lexer.getTokenType();
            if (type == GroovyTokenTypes.mSTRING_LITERAL && (text = StringUtil.unquoteString((String)lexer.getTokenText())).startsWith(dependency)) {
                return (TextRange)consumer.fun((Object)Pair.create((Object)text, (Object)lexer));
            }
            lexer.advance();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/UnresolvedDependenciesReporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncIssue";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unresolvedDependencies";
                break;
            }
            case 5: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/UnresolvedDependenciesReporter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findDependencyPosition";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemotePackages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findDependencyPosition";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRemotePackages";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "canGetConstraintLayoutFromSdkManager";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

