/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.ddmlib.IDevice;
import com.android.resources.Density;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.ApkProjects;
import com.android.tools.idea.fd.InstantRunBuilder;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.run.BeforeRunBuilder;
import com.android.tools.idea.gradle.run.DefaultGradleBuilder;
import com.android.tools.idea.gradle.run.GradleEditTaskDialog;
import com.android.tools.idea.gradle.run.GradleModuleTasksProvider;
import com.android.tools.idea.gradle.run.GradleTaskRunner;
import com.android.tools.idea.gradle.run.MakeBeforeRunTask;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidRunConfigContext;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.PreferGradleMake;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfiguration;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import icons.AndroidIcons;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeBeforeRunTaskProvider
extends BeforeRunTaskProvider<MakeBeforeRunTask> {
    @NotNull
    public static final Key<MakeBeforeRunTask> ID = Key.create((String)"Android.Gradle.BeforeRunTask");
    private static final Logger LOG = Logger.getInstance(MakeBeforeRunTask.class);
    public static final String TASK_NAME = "Gradle-aware Make";
    @NotNull
    private final Project myProject;

    public MakeBeforeRunTaskProvider(@NotNull Project project) {
        if (project == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public Key<MakeBeforeRunTask> getId() {
        return ID;
    }

    @Nullable
    public Icon getIcon() {
        return AndroidIcons.Android;
    }

    @Nullable
    public Icon getTaskIcon(MakeBeforeRunTask task) {
        return AndroidIcons.Android;
    }

    public String getName() {
        return TASK_NAME;
    }

    public String getDescription(MakeBeforeRunTask task) {
        String goal = task.getGoal();
        return StringUtil.isEmpty((String)goal) ? TASK_NAME : "gradle " + goal;
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public MakeBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(1);
        }
        if (MakeBeforeRunTaskProvider.configurationTypeIsSupported(runConfiguration)) {
            MakeBeforeRunTask task = new MakeBeforeRunTask();
            if (runConfiguration instanceof PreferGradleMake) {
                task.setEnabled(true);
            }
            return task;
        }
        return null;
    }

    private static boolean configurationTypeIsSupported(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(2);
        }
        if (ApkProjects.isApkProject(runConfiguration.getProject())) {
            return false;
        }
        return runConfiguration instanceof PreferGradleMake || MakeBeforeRunTaskProvider.isUnitTestConfiguration(runConfiguration);
    }

    private static boolean isUnitTestConfiguration(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(3);
        }
        return runConfiguration instanceof JUnitConfiguration || runConfiguration.getClass().getSimpleName().equals("TestNGConfiguration");
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull MakeBeforeRunTask task) {
        if (runConfiguration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(4);
        }
        if (task == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(5);
        }
        GradleEditTaskDialog dialog = new GradleEditTaskDialog(this.myProject);
        dialog.setGoal(task.getGoal());
        dialog.setAvailableGoals(this.createAvailableTasks());
        if (!dialog.showAndGet()) {
            task.setInvalid();
            return false;
        }
        task.setGoal(dialog.getGoal());
        return true;
    }

    private List<String> createAvailableTasks() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        ArrayList gradleTasks = Lists.newArrayList();
        for (Module module : moduleManager.getModules()) {
            GradleModuleModel gradleModuleModel;
            GradleFacet facet = GradleFacet.getInstance(module);
            if (facet == null || (gradleModuleModel = facet.getGradleModuleModel()) == null) continue;
            gradleTasks.addAll(gradleModuleModel.getTaskNames());
        }
        return gradleTasks;
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull MakeBeforeRunTask task) {
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(6);
        }
        if (task == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(7);
        }
        return task.isValid();
    }

    public boolean executeTask(DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull MakeBeforeRunTask task) {
        String errorMsg;
        GradleSyncState syncState;
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(8);
        }
        if (env == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(9);
        }
        if (task == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(10);
        }
        if (!AndroidProjectInfo.getInstance(this.myProject).requiresAndroidModel() || !Projects.isDirectGradleInvocationEnabled(this.myProject)) {
            CompileStepBeforeRun regularMake = new CompileStepBeforeRun(this.myProject);
            return regularMake.executeTask(context, configuration, env, new CompileStepBeforeRun.MakeBeforeRunTask());
        }
        final AtomicReference errorMsgRef = new AtomicReference();
        if (AndroidGradleBuildConfiguration.getInstance((Project)this.myProject).SYNC_PROJECT_BEFORE_BUILD && (syncState = GradleSyncState.getInstance(this.myProject)).isSyncNeeded() != ThreeState.NO) {
            GradleSyncInvoker.Request request = new GradleSyncInvoker.Request().setRunInBackground(false);
            GradleSyncInvoker.getInstance().requestProjectSync(this.myProject, request, new GradleSyncListener.Adapter(){

                @Override
                public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (errorMessage == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    errorMsgRef.set(errorMessage);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray[1] = "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider$1";
                    objectArray[2] = "syncFailed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        if ((errorMsg = (String)errorMsgRef.get()) != null) {
            LOG.info("Unable to launch 'Gradle-aware Make' task. Project sync failed with message: " + errorMsg);
            return false;
        }
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (configuration instanceof RunConfigurationBase && ((RunConfigurationBase)configuration).excludeCompileBeforeLaunchOption()) {
            return true;
        }
        AndroidRunConfigContext runConfigContext = (AndroidRunConfigContext)env.getCopyableUserData(AndroidRunConfigContext.KEY);
        DeviceFutures deviceFutures = runConfigContext == null ? null : runConfigContext.getTargetDevices();
        List<AndroidDevice> targetDevices = deviceFutures == null ? Collections.emptyList() : deviceFutures.getDevices();
        List<String> cmdLineArgs = MakeBeforeRunTaskProvider.getCommonArguments(configuration, targetDevices);
        BeforeRunBuilder builder = MakeBeforeRunTaskProvider.createBuilder(env, MakeBeforeRunTaskProvider.getModules(this.myProject, context, configuration), configuration, runConfigContext, task.getGoal());
        try {
            boolean success = builder.build(GradleTaskRunner.newRunner(this.myProject), cmdLineArgs);
            LOG.info("Gradle invocation complete, success = " + success);
            return success;
        }
        catch (InvocationTargetException e) {
            LOG.info("Unexpected error while launching gradle before run tasks", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted while launching gradle before run tasks");
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @NotNull
    private static List<String> getCommonArguments(@NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices) {
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(11);
        }
        if (targetDevices == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(12);
        }
        ArrayList cmdLineArgs = Lists.newArrayList();
        cmdLineArgs.addAll(MakeBeforeRunTaskProvider.getDeviceSpecificArguments(targetDevices));
        cmdLineArgs.addAll(MakeBeforeRunTaskProvider.getProfilingOptions(configuration));
        ArrayList arrayList = cmdLineArgs;
        if (arrayList == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getDeviceSpecificArguments(@NotNull List<AndroidDevice> devices) {
        if (devices == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(14);
        }
        if (devices.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MakeBeforeRunTaskProvider.$$$reportNull$$$0(15);
            }
            return list;
        }
        ArrayList<String> properties = new ArrayList<String>(2);
        AndroidVersion minVersion = devices.get(0).getVersion();
        for (int i = 1; i < devices.size(); ++i) {
            AndroidDevice androidDevice = devices.get(i);
            if (androidDevice.getVersion().compareTo(minVersion) >= 0) continue;
            minVersion = androidDevice.getVersion();
        }
        properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.api", (String)Integer.toString(minVersion.getFeatureLevel())));
        if (devices.size() == 1) {
            List abis;
            AndroidDevice device = devices.get(0);
            Density density = Density.getEnum((int)device.getDensity());
            if (density != null) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.density", (String)density.getResourceValue()));
            }
            if (!(abis = device.getAbis().stream().map(Abi::toString).collect(Collectors.toList())).isEmpty()) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.abi", (String)Joiner.on((char)',').join(abis)));
            }
        }
        ArrayList<String> arrayList = properties;
        if (arrayList == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getProfilingOptions(@NotNull RunConfiguration configuration) {
        List<String> list;
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(17);
        }
        if (System.getProperty("enable.experimental.profiling") == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                MakeBeforeRunTaskProvider.$$$reportNull$$$0(18);
            }
            return list2;
        }
        if (!(configuration instanceof AndroidRunConfigurationBase)) {
            List<String> list3 = Collections.emptyList();
            if (list3 == null) {
                MakeBeforeRunTaskProvider.$$$reportNull$$$0(19);
            }
            return list3;
        }
        Properties profilerProperties = ((AndroidRunConfigurationBase)configuration).getProfilerState().toProperties();
        try {
            File propertiesFile = FileUtil.createTempFile((String)"profiler", (String)".properties");
            propertiesFile.deleteOnExit();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(propertiesFile), Charsets.UTF_8);
            profilerProperties.store(writer, "Android Studio Profiler Gradle Plugin Properties");
            ((Writer)writer).close();
            String profilingOption = AndroidGradleSettings.createProjectProperty((String)"android.profiler.properties", (String)propertiesFile.getAbsolutePath());
            list = Collections.singletonList(profilingOption);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
            List<String> list4 = Collections.emptyList();
            if (list4 == null) {
                MakeBeforeRunTaskProvider.$$$reportNull$$$0(21);
            }
            return list4;
        }
        if (list == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(20);
        }
        return list;
    }

    private static BeforeRunBuilder createBuilder(@NotNull ExecutionEnvironment env, @NotNull Module[] modules, @NotNull RunConfiguration configuration, @Nullable AndroidRunConfigContext runConfigContext, @Nullable String userGoal) {
        DeviceFutures deviceFutures;
        if (env == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(22);
        }
        if (modules == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(23);
        }
        if (configuration == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(24);
        }
        if (modules.length == 0) {
            throw new IllegalStateException("Unable to determine list of modules to build");
        }
        if (!StringUtil.isEmpty((String)userGoal)) {
            ArrayListMultimap tasks = ArrayListMultimap.create();
            ((StreamEx)StreamEx.of((Object[])modules).map(module -> ExternalSystemApiUtil.getExternalRootProjectPath((Module)module)).nonNull().distinct()).map(path -> Paths.get(path, new String[0])).forEach(arg_0 -> MakeBeforeRunTaskProvider.lambda$createBuilder$2((ListMultimap)tasks, userGoal, arg_0));
            return new DefaultGradleBuilder((ListMultimap<Path, String>)tasks, null);
        }
        GradleModuleTasksProvider gradleTasksProvider = new GradleModuleTasksProvider(modules);
        GradleBuildInvoker.TestCompileType testCompileType = GradleBuildInvoker.getTestCompileType(configuration.getType().getId());
        if (testCompileType == GradleBuildInvoker.TestCompileType.UNIT_TESTS) {
            BuildMode buildMode = BuildMode.COMPILE_JAVA;
            return new DefaultGradleBuilder(gradleTasksProvider.getUnitTestTasks(buildMode), buildMode);
        }
        InstantRunContext irContext = (InstantRunContext)env.getCopyableUserData(InstantRunContext.KEY);
        DeviceFutures deviceFutures2 = deviceFutures = runConfigContext == null ? null : runConfigContext.getTargetDevices();
        if (deviceFutures == null || irContext == null) {
            return new DefaultGradleBuilder(gradleTasksProvider.getTasksFor(BuildMode.ASSEMBLE, testCompileType), BuildMode.ASSEMBLE);
        }
        List<AndroidDevice> targetDevices = deviceFutures.getDevices();
        assert (targetDevices.size() == 1) : "instant run context available, but deploying to > 1 device";
        return new InstantRunBuilder(MakeBeforeRunTaskProvider.getLaunchedDevice(targetDevices.get(0)), irContext, runConfigContext, gradleTasksProvider);
    }

    @NotNull
    private static Module[] getModules(@NotNull Project project, @Nullable DataContext context, @Nullable RunConfiguration configuration) {
        if (project == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(25);
        }
        if (configuration instanceof ModuleRunProfile) {
            if (configuration instanceof AndroidJUnitConfiguration) {
                Module[] moduleArray = ((AndroidJUnitConfiguration)configuration).getModulesToCompile();
                if (moduleArray == null) {
                    MakeBeforeRunTaskProvider.$$$reportNull$$$0(26);
                }
                return moduleArray;
            }
            Module[] moduleArray = ((ModuleRunProfile)configuration).getModules();
            if (moduleArray == null) {
                MakeBeforeRunTaskProvider.$$$reportNull$$$0(27);
            }
            return moduleArray;
        }
        Module[] moduleArray = Projects.getModulesToBuildFromSelection(project, context);
        if (moduleArray == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(28);
        }
        return moduleArray;
    }

    @Nullable
    public static IDevice getLaunchedDevice(@NotNull AndroidDevice device) {
        if (device == null) {
            MakeBeforeRunTaskProvider.$$$reportNull$$$0(29);
        }
        if (!device.getLaunchedDevice().isDone()) {
            return null;
        }
        try {
            return (IDevice)device.getLaunchedDevice().get(1L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException | TimeoutException e) {
            return null;
        }
    }

    private static /* synthetic */ void lambda$createBuilder$2(ListMultimap tasks, @Nullable String userGoal, Path path) {
        tasks.put((Object)path, (Object)userGoal);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 9: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDevices";
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProvider";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonArguments";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceSpecificArguments";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilingOptions";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "configurationTypeIsSupported";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnitTestConfiguration";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configureTask";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canExecuteTask";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCommonArguments";
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceSpecificArguments";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProfilingOptions";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getModules";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getLaunchedDevice";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

