/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Library;
import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsModelCollection;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsParsedDependencies;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsLibraryAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsModuleAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsVariant;
import com.android.tools.idea.gradle.structure.model.pom.MavenPoms;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsAndroidDependencyCollection
implements PsModelCollection<PsAndroidDependency> {
    @NotNull
    private final PsAndroidModule myParent;
    @NotNull
    private final Map<String, PsModuleAndroidDependency> myModuleDependenciesByGradlePath;
    @NotNull
    private final Map<String, PsLibraryAndroidDependency> myLibraryDependenciesBySpec;

    PsAndroidDependencyCollection(@NotNull PsAndroidModule parent) {
        if (parent == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(0);
        }
        this.myModuleDependenciesByGradlePath = Maps.newHashMap();
        this.myLibraryDependenciesBySpec = Maps.newHashMap();
        this.myParent = parent;
        parent.forEachVariant(this::addDependencies);
    }

    private void addDependencies(@NotNull PsVariant variant) {
        if (variant == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(1);
        }
        variant.forEachArtifact(this::collectDependencies);
    }

    private void collectDependencies(@NotNull PsAndroidArtifact artifact) {
        BaseArtifact resolvedArtifact;
        if (artifact == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(2);
        }
        if ((resolvedArtifact = artifact.getResolvedModel()) == null) {
            return;
        }
        AndroidModuleModel gradleModel = artifact.getGradleModel();
        Dependencies dependencies = GradleUtil.getDependencies(resolvedArtifact, gradleModel.getModelVersion());
        for (AndroidLibrary androidLibrary : dependencies.getLibraries()) {
            String gradlePath = androidLibrary.getProject();
            if (gradlePath != null) {
                String projectVariant = androidLibrary.getProjectVariant();
                this.addModule(gradlePath, artifact, projectVariant);
                continue;
            }
            this.addLibrary((Library)androidLibrary, artifact);
        }
        for (JavaLibrary javaLibrary : dependencies.getJavaLibraries()) {
            this.addLibrary((Library)javaLibrary, artifact);
        }
    }

    private void addModule(@NotNull String gradlePath, @NotNull PsAndroidArtifact artifact, @Nullable String projectVariant) {
        PsModuleAndroidDependency dependency;
        if (gradlePath == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(3);
        }
        if (artifact == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(4);
        }
        PsParsedDependencies parsedDependencies = this.myParent.getParsedDependencies();
        ModuleDependencyModel matchingParsedDependency = parsedDependencies.findModuleDependency(gradlePath, artifact::contains);
        Module resolvedModule = null;
        PsModule module = this.myParent.getParent().findModuleByGradlePath(gradlePath);
        if (module != null) {
            resolvedModule = module.getResolvedModel();
        }
        if ((dependency = (PsModuleAndroidDependency)this.findElement(gradlePath, PsModuleAndroidDependency.class)) == null) {
            dependency = new PsModuleAndroidDependency(this.myParent, gradlePath, artifact, projectVariant, resolvedModule, matchingParsedDependency);
            this.myModuleDependenciesByGradlePath.put(gradlePath, dependency);
        }
        PsAndroidDependencyCollection.updateDependency(dependency, artifact, matchingParsedDependency);
    }

    @Nullable
    private PsAndroidDependency addLibrary(@NotNull Library library, @NotNull PsAndroidArtifact artifact) {
        if (library == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(5);
        }
        if (artifact == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(6);
        }
        PsParsedDependencies parsedDependencies = this.myParent.getParsedDependencies();
        MavenCoordinates coordinates = library.getResolvedCoordinates();
        if (coordinates != null) {
            PsArtifactDependencySpec spec = PsArtifactDependencySpec.create(coordinates);
            ArtifactDependencyModel matchingParsedDependency = parsedDependencies.findLibraryDependency(coordinates, artifact::contains);
            if (matchingParsedDependency != null) {
                String parsedVersionValue = (String)matchingParsedDependency.version().value();
                if (parsedVersionValue != null) {
                    GradleVersion parsedVersion = GradleVersion.tryParse((String)parsedVersionValue);
                    GradleVersion versionFromGradle = GradleVersion.parse((String)coordinates.getVersion());
                    if (parsedVersion != null && PsAndroidDependencyCollection.compare(parsedVersion, versionFromGradle) == 0) {
                        return this.addLibrary(library, spec, artifact, matchingParsedDependency);
                    }
                    PsLibraryAndroidDependency potentialDuplicate = null;
                    for (PsLibraryAndroidDependency dependency : this.myLibraryDependenciesBySpec.values()) {
                        if (!dependency.getParsedModels().contains((Object)matchingParsedDependency)) continue;
                        potentialDuplicate = dependency;
                        break;
                    }
                    if (potentialDuplicate != null) {
                        // empty if block
                    }
                    this.addLibrary(library, spec, artifact, matchingParsedDependency);
                    return this.addLibrary(library, spec, artifact, null);
                }
            } else {
                return this.addLibrary(library, spec, artifact, null);
            }
        }
        return null;
    }

    @Nullable
    private PsAndroidDependency addLibrary(@NotNull Library library, @NotNull PsArtifactDependencySpec resolvedSpec, @NotNull PsAndroidArtifact artifact, @Nullable ArtifactDependencyModel parsedModel) {
        if (library == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(7);
        }
        if (resolvedSpec == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(8);
        }
        if (artifact == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(9);
        }
        if (library instanceof AndroidLibrary) {
            AndroidLibrary androidLibrary = (AndroidLibrary)library;
            return this.addAndroidLibrary(androidLibrary, resolvedSpec, artifact, parsedModel);
        }
        if (library instanceof JavaLibrary) {
            JavaLibrary javaLibrary = (JavaLibrary)library;
            return this.addJavaLibrary(javaLibrary, resolvedSpec, artifact, parsedModel);
        }
        return null;
    }

    @NotNull
    private PsAndroidDependency addAndroidLibrary(@NotNull AndroidLibrary androidLibrary, @NotNull PsArtifactDependencySpec resolvedSpec, @NotNull PsAndroidArtifact artifact, @Nullable ArtifactDependencyModel parsedModel) {
        if (androidLibrary == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(10);
        }
        if (resolvedSpec == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(11);
        }
        if (artifact == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(12);
        }
        PsAndroidDependency dependency = this.getOrCreateDependency(resolvedSpec, (Library)androidLibrary, artifact, parsedModel);
        for (Library library : androidLibrary.getLibraryDependencies()) {
            this.addTransitive(library, artifact, dependency);
        }
        PsAndroidDependencyCollection.updateDependency(dependency, artifact, parsedModel);
        PsAndroidDependency psAndroidDependency = dependency;
        if (psAndroidDependency == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(13);
        }
        return psAndroidDependency;
    }

    @NotNull
    private PsAndroidDependency addJavaLibrary(@NotNull JavaLibrary javaLibrary, @NotNull PsArtifactDependencySpec resolvedSpec, @NotNull PsAndroidArtifact artifact, @Nullable ArtifactDependencyModel parsedModel) {
        if (javaLibrary == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(14);
        }
        if (resolvedSpec == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(15);
        }
        if (artifact == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(16);
        }
        PsAndroidDependency dependency = this.getOrCreateDependency(resolvedSpec, (Library)javaLibrary, artifact, parsedModel);
        for (Library library : javaLibrary.getDependencies()) {
            this.addTransitive(library, artifact, dependency);
        }
        PsAndroidDependencyCollection.updateDependency(dependency, artifact, parsedModel);
        PsAndroidDependency psAndroidDependency = dependency;
        if (psAndroidDependency == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(17);
        }
        return psAndroidDependency;
    }

    private void addTransitive(@NotNull Library transitiveDependency, @NotNull PsAndroidArtifact artifact, @NotNull PsAndroidDependency dependency) {
        PsAndroidDependency transitive;
        if (transitiveDependency == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(18);
        }
        if (artifact == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(19);
        }
        if (dependency == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(20);
        }
        if ((transitive = this.addLibrary(transitiveDependency, artifact)) != null && dependency instanceof PsLibraryAndroidDependency) {
            PsLibraryAndroidDependency libraryDependency = (PsLibraryAndroidDependency)dependency;
            libraryDependency.addTransitiveDependency(transitive.toText(PsDependency.TextType.PLAIN_TEXT));
        }
    }

    @VisibleForTesting
    static int compare(@NotNull GradleVersion parsedVersion, @NotNull GradleVersion versionFromGradle) {
        int result;
        if (parsedVersion == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(21);
        }
        if (versionFromGradle == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(22);
        }
        if ((result = versionFromGradle.compareTo(parsedVersion)) == 0) {
            return result;
        }
        if (result < 0) {
            if (parsedVersion.getMajorSegment().acceptsGreaterValue()) {
                return 0;
            }
            if (parsedVersion.getMinorSegment() != null && parsedVersion.getMinorSegment().acceptsGreaterValue()) {
                return parsedVersion.getMajor() - versionFromGradle.getMajor();
            }
            if (parsedVersion.getMicroSegment() != null && parsedVersion.getMicroSegment().acceptsGreaterValue()) {
                result = parsedVersion.getMajor() - versionFromGradle.getMajor();
                if (result != 0) {
                    return result;
                }
                return parsedVersion.getMinor() - versionFromGradle.getMinor();
            }
        }
        return result;
    }

    @NotNull
    private PsAndroidDependency getOrCreateDependency(@NotNull PsArtifactDependencySpec resolvedSpec, @NotNull Library library, @NotNull PsAndroidArtifact artifact, @Nullable ArtifactDependencyModel parsedModel) {
        String compactNotation;
        PsLibraryAndroidDependency dependency;
        if (resolvedSpec == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(23);
        }
        if (library == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(24);
        }
        if (artifact == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(25);
        }
        if ((dependency = this.myLibraryDependenciesBySpec.get(compactNotation = resolvedSpec.toString())) == null) {
            dependency = new PsLibraryAndroidDependency(this.myParent, resolvedSpec, artifact, library, parsedModel);
            this.myLibraryDependenciesBySpec.put(compactNotation, dependency);
            File libraryPath = null;
            if (library instanceof AndroidLibrary) {
                libraryPath = ((AndroidLibrary)library).getBundle();
            } else if (library instanceof JavaLibrary) {
                libraryPath = ((JavaLibrary)library).getJarFile();
            }
            List<PsArtifactDependencySpec> pomDependencies = Collections.emptyList();
            if (libraryPath != null) {
                pomDependencies = MavenPoms.findDependenciesInPomFile(libraryPath);
            }
            dependency.setDependenciesFromPomFile(pomDependencies);
        } else if (parsedModel != null) {
            dependency.addParsedModel(parsedModel);
        }
        PsLibraryAndroidDependency psLibraryAndroidDependency = dependency;
        if (psLibraryAndroidDependency == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(26);
        }
        return psLibraryAndroidDependency;
    }

    @Nullable
    PsLibraryAndroidDependency findElement(PsArtifactDependencySpec spec) {
        PsLibraryAndroidDependency dependency = (PsLibraryAndroidDependency)this.findElement(spec.toString(), PsLibraryAndroidDependency.class);
        if (dependency != null) {
            return dependency;
        }
        if (StringUtil.isEmpty((String)spec.version)) {
            ArrayList found = Lists.newArrayList();
            for (String specText : this.myLibraryDependenciesBySpec.keySet()) {
                PsArtifactDependencySpec storedSpec = PsArtifactDependencySpec.create(specText);
                if (storedSpec == null || !Objects.equals(storedSpec.group, spec.group) || !Objects.equals(storedSpec.name, spec.name)) continue;
                found.add(specText);
            }
            if (found.size() == 1) {
                return this.myLibraryDependenciesBySpec.get(found.get(0));
            }
        }
        return null;
    }

    @Override
    @Nullable
    public <S extends PsAndroidDependency> S findElement(@NotNull String name, @Nullable Class<S> type) {
        if (name == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(27);
        }
        if (PsModuleAndroidDependency.class.equals(type)) {
            return (S)((PsAndroidDependency)type.cast(this.myModuleDependenciesByGradlePath.get(name)));
        }
        if (PsLibraryAndroidDependency.class.equals(type)) {
            return (S)((PsAndroidDependency)type.cast(this.myLibraryDependenciesBySpec.get(name)));
        }
        return null;
    }

    @Override
    public void forEach(@NotNull Consumer<PsAndroidDependency> consumer) {
        if (consumer == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(28);
        }
        PsAndroidDependencyCollection.forEachDependency(this.myLibraryDependenciesBySpec, consumer);
        PsAndroidDependencyCollection.forEachDependency(this.myModuleDependenciesByGradlePath, consumer);
    }

    private static void forEachDependency(@NotNull Map<String, ? extends PsAndroidDependency> dependenciesBySpec, @NotNull Consumer<PsAndroidDependency> consumer) {
        if (dependenciesBySpec == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(29);
        }
        if (consumer == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(30);
        }
        dependenciesBySpec.values().forEach(consumer);
    }

    void forEachDeclaredDependency(@NotNull Consumer<PsAndroidDependency> consumer) {
        if (consumer == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(31);
        }
        PsAndroidDependencyCollection.forEachDeclaredDependency(this.myLibraryDependenciesBySpec, consumer);
        PsAndroidDependencyCollection.forEachDeclaredDependency(this.myModuleDependenciesByGradlePath, consumer);
    }

    private static void forEachDeclaredDependency(@NotNull Map<String, ? extends PsAndroidDependency> dependenciesBySpec, @NotNull Consumer<PsAndroidDependency> consumer) {
        if (dependenciesBySpec == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(32);
        }
        if (consumer == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(33);
        }
        dependenciesBySpec.values().stream().filter(PsDependency::isDeclared).forEach(consumer);
    }

    void forEachModuleDependency(@NotNull Consumer<PsModuleAndroidDependency> consumer) {
        if (consumer == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(34);
        }
        this.myModuleDependenciesByGradlePath.values().forEach(consumer);
    }

    void addLibraryDependency(@NotNull PsArtifactDependencySpec spec, @NotNull PsAndroidArtifact artifact, @Nullable ArtifactDependencyModel parsedModel) {
        PsLibraryAndroidDependency dependency;
        if (spec == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(35);
        }
        if (artifact == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(36);
        }
        if ((dependency = this.myLibraryDependenciesBySpec.get(spec.toString())) == null) {
            dependency = new PsLibraryAndroidDependency(this.myParent, spec, artifact, null, parsedModel);
            this.myLibraryDependenciesBySpec.put(spec.toString(), dependency);
        } else {
            PsAndroidDependencyCollection.updateDependency(dependency, artifact, parsedModel);
        }
    }

    private static void updateDependency(@NotNull PsAndroidDependency dependency, @NotNull PsAndroidArtifact artifact, @Nullable DependencyModel parsedModel) {
        if (dependency == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(37);
        }
        if (artifact == null) {
            PsAndroidDependencyCollection.$$$reportNull$$$0(38);
        }
        if (parsedModel != null) {
            dependency.addParsedModel(parsedModel);
        }
        dependency.addContainer(artifact);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 17: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 17: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 25: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 5: 
            case 7: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 8: 
            case 11: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedSpec";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidLibrary";
                break;
            }
            case 13: 
            case 17: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/android/PsAndroidDependencyCollection";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaLibrary";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transitiveDependency";
                break;
            }
            case 20: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedVersion";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionFromGradle";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesBySpec";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/android/PsAndroidDependencyCollection";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "addAndroidLibrary";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "addJavaLibrary";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addDependencies";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectDependencies";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addModule";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addLibrary";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addAndroidLibrary";
                break;
            }
            case 13: 
            case 17: 
            case 26: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addJavaLibrary";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addTransitive";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDependency";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "forEachDependency";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "forEachDeclaredDependency";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "forEachModuleDependency";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryDependency";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "updateDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 17: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

