/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.java;

import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsModelCollection;
import com.android.tools.idea.gradle.structure.model.PsParsedDependencies;
import com.android.tools.idea.gradle.structure.model.java.PsJavaDependency;
import com.android.tools.idea.gradle.structure.model.java.PsJavaModule;
import com.android.tools.idea.gradle.structure.model.java.PsLibraryJavaDependency;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Consumer;
import org.gradle.tooling.model.GradleModuleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsJavaDependencyCollection
implements PsModelCollection<PsJavaDependency> {
    @NotNull
    private final PsJavaModule myParent;
    @NotNull
    private final Map<String, PsLibraryJavaDependency> myLibraryDependenciesBySpec;

    PsJavaDependencyCollection(@NotNull PsJavaModule parent) {
        if (parent == null) {
            PsJavaDependencyCollection.$$$reportNull$$$0(0);
        }
        this.myLibraryDependenciesBySpec = Maps.newHashMap();
        this.myParent = parent;
        this.addDependencies();
    }

    private void addDependencies() {
        PsParsedDependencies parsedDependencies = this.myParent.getParsedDependencies();
        JavaModuleModel gradleModel = this.myParent.getGradleModel();
        for (JarLibraryDependency libraryDependency : gradleModel.getJarLibraryDependencies()) {
            GradleModuleVersion moduleVersion = libraryDependency.getModuleVersion();
            if (moduleVersion == null) continue;
            PsArtifactDependencySpec spec = PsArtifactDependencySpec.create(moduleVersion);
            ArtifactDependencyModel parsed = parsedDependencies.findLibraryDependency(moduleVersion);
            PsLibraryJavaDependency dependency = new PsLibraryJavaDependency(this.myParent, spec, libraryDependency, parsed);
            this.myLibraryDependenciesBySpec.put(spec.toString(), dependency);
        }
    }

    @Override
    @Nullable
    public <S extends PsJavaDependency> S findElement(@NotNull String name, @NotNull Class<S> type) {
        if (name == null) {
            PsJavaDependencyCollection.$$$reportNull$$$0(1);
        }
        if (type == null) {
            PsJavaDependencyCollection.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Override
    public void forEach(@NotNull Consumer<PsJavaDependency> consumer) {
        if (consumer == null) {
            PsJavaDependencyCollection.$$$reportNull$$$0(3);
        }
        PsJavaDependencyCollection.forEachDependency(this.myLibraryDependenciesBySpec, consumer);
    }

    private static void forEachDependency(@NotNull Map<String, ? extends PsJavaDependency> dependenciesBySpec, @NotNull Consumer<PsJavaDependency> consumer) {
        if (dependenciesBySpec == null) {
            PsJavaDependencyCollection.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            PsJavaDependencyCollection.$$$reportNull$$$0(5);
        }
        dependenciesBySpec.values().forEach(consumer);
    }

    void forEachDeclaredDependency(@NotNull Consumer<PsJavaDependency> consumer) {
        if (consumer == null) {
            PsJavaDependencyCollection.$$$reportNull$$$0(6);
        }
        PsJavaDependencyCollection.forEachDeclaredDependency(this.myLibraryDependenciesBySpec, consumer);
    }

    private static void forEachDeclaredDependency(@NotNull Map<String, ? extends PsJavaDependency> dependenciesBySpec, @NotNull Consumer<PsJavaDependency> consumer) {
        if (dependenciesBySpec == null) {
            PsJavaDependencyCollection.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            PsJavaDependencyCollection.$$$reportNull$$$0(8);
        }
        dependenciesBySpec.values().stream().filter(PsDependency::isDeclared).forEach(consumer);
    }

    void addLibraryDependency(@NotNull PsArtifactDependencySpec spec, @Nullable ArtifactDependencyModel parsedModel) {
        PsLibraryJavaDependency dependency;
        if (spec == null) {
            PsJavaDependencyCollection.$$$reportNull$$$0(9);
        }
        if ((dependency = this.myLibraryDependenciesBySpec.get(spec.toString())) == null) {
            dependency = new PsLibraryJavaDependency(this.myParent, spec, null, parsedModel);
            this.myLibraryDependenciesBySpec.put(spec.toString(), dependency);
        } else {
            PsJavaDependencyCollection.updateDependency(dependency, parsedModel);
        }
    }

    private static void updateDependency(@NotNull PsJavaDependency dependency, @Nullable DependencyModel parsedModel) {
        if (dependency == null) {
            PsJavaDependencyCollection.$$$reportNull$$$0(10);
        }
        if (parsedModel != null) {
            dependency.addParsedModel(parsedModel);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesBySpec";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/structure/model/java/PsJavaDependencyCollection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "forEach";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "forEachDependency";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "forEachDeclaredDependency";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addLibraryDependency";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "updateDependency";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

