/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.tools.idea.logcat.AndroidLogcatFilter;
import com.android.tools.idea.logcat.PersistentAndroidLogFilters;
import com.android.tools.idea.logcat.RegexFilterComponent;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultAndroidLogcatFilter
implements AndroidLogcatFilter {
    @NotNull
    private final String myName;
    @Nullable
    private final Pattern myMessagePattern;
    @Nullable
    private final Pattern myTagPattern;
    @Nullable
    private final Pattern myPkgNamePattern;
    @Nullable
    private final String myPid;
    @Nullable
    private final Log.LogLevel myLogLevel;

    private DefaultAndroidLogcatFilter(@NotNull String name, @Nullable Pattern messagePattern, @Nullable Pattern tagPattern, @Nullable Pattern pkgNamePattern, @Nullable String pid, @Nullable Log.LogLevel logLevel) {
        if (name == null) {
            DefaultAndroidLogcatFilter.$$$reportNull$$$0(0);
        }
        this.myName = name;
        this.myMessagePattern = messagePattern;
        this.myTagPattern = tagPattern;
        this.myPkgNamePattern = pkgNamePattern;
        this.myPid = pid;
        this.myLogLevel = logLevel;
    }

    @Override
    public boolean isApplicable(@NotNull String message, @NotNull String tag, @NotNull String pkg, int pid, @NotNull Log.LogLevel logLevel) {
        if (message == null) {
            DefaultAndroidLogcatFilter.$$$reportNull$$$0(1);
        }
        if (tag == null) {
            DefaultAndroidLogcatFilter.$$$reportNull$$$0(2);
        }
        if (pkg == null) {
            DefaultAndroidLogcatFilter.$$$reportNull$$$0(3);
        }
        if (logLevel == null) {
            DefaultAndroidLogcatFilter.$$$reportNull$$$0(4);
        }
        if (this.myLogLevel != null && logLevel.getPriority() < this.myLogLevel.getPriority()) {
            return false;
        }
        if (this.myMessagePattern != null && !this.myMessagePattern.matcher(message).find()) {
            return false;
        }
        if (this.myTagPattern != null && !this.myTagPattern.matcher(tag).find()) {
            return false;
        }
        if (this.myPkgNamePattern != null && !this.myPkgNamePattern.matcher(pkg).find()) {
            return false;
        }
        return this.myPid == null || this.myPid.length() <= 0 || this.myPid.equals(Integer.toString(pid));
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            DefaultAndroidLogcatFilter.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static DefaultAndroidLogcatFilter compile(@NotNull PersistentAndroidLogFilters.FilterData filterData, @NotNull String name) {
        if (filterData == null) {
            DefaultAndroidLogcatFilter.$$$reportNull$$$0(6);
        }
        if (name == null) {
            DefaultAndroidLogcatFilter.$$$reportNull$$$0(7);
        }
        Pattern logMessagePattern = RegexFilterComponent.pattern(filterData.getLogMessagePattern(), filterData.getLogMessageIsRegex());
        Pattern logTagPattern = RegexFilterComponent.pattern(filterData.getLogTagPattern(), filterData.getLogTagIsRegex());
        Pattern pkgNamePattern = RegexFilterComponent.pattern(filterData.getPackageNamePattern(), filterData.getPackageNameIsRegex());
        String pid = filterData.getPid();
        Log.LogLevel logLevel = null;
        String logLevelStr = filterData.getLogLevel();
        if (logLevelStr != null && logLevelStr.length() > 0) {
            logLevel = Log.LogLevel.getByString((String)logLevelStr);
        }
        DefaultAndroidLogcatFilter defaultAndroidLogcatFilter = new DefaultAndroidLogcatFilter(name, logMessagePattern, logTagPattern, pkgNamePattern, pid, logLevel);
        if (defaultAndroidLogcatFilter == null) {
            DefaultAndroidLogcatFilter.$$$reportNull$$$0(8);
        }
        return defaultAndroidLogcatFilter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logLevel";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/logcat/DefaultAndroidLogcatFilter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/logcat/DefaultAndroidLogcatFilter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "compile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Builder {
        @NotNull
        private final String myName;
        @Nullable
        private Pattern myMessagePattern;
        @Nullable
        private Pattern myTagPattern;
        @Nullable
        private Pattern myPkgNamePattern;
        @Nullable
        private String myPid;
        @Nullable
        private Log.LogLevel myLogLevel;

        public Builder(@NotNull String name) {
            if (name == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        public Builder setMessagePattern(@Nullable Pattern messagePattern) {
            this.myMessagePattern = messagePattern;
            return this;
        }

        public Builder setTagPattern(@Nullable Pattern tagPattern) {
            this.myTagPattern = tagPattern;
            return this;
        }

        public Builder setPackagePattern(@Nullable Pattern pkgNamePattern) {
            this.myPkgNamePattern = pkgNamePattern;
            return this;
        }

        public Builder setPid(@Nullable String pid) {
            this.myPid = pid;
            return this;
        }

        public Builder setPid(@Nullable Integer pid) {
            return this.setPid(pid != null ? pid.toString() : null);
        }

        public Builder setLogLevel(@Nullable Log.LogLevel logLevel) {
            this.myLogLevel = logLevel;
            return this;
        }

        @NotNull
        public DefaultAndroidLogcatFilter build() {
            DefaultAndroidLogcatFilter defaultAndroidLogcatFilter = new DefaultAndroidLogcatFilter(this.myName, this.myMessagePattern, this.myTagPattern, this.myPkgNamePattern, this.myPid, this.myLogLevel);
            if (defaultAndroidLogcatFilter == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return defaultAndroidLogcatFilter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/logcat/DefaultAndroidLogcatFilter$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/logcat/DefaultAndroidLogcatFilter$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

