/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.energy.model;

import com.android.tools.adtui.model.SeriesData;
import com.android.tools.datastore.DataAdapter;
import gnu.trove.TLongArrayList;
import org.jetbrains.annotations.NotNull;

public class EnergyDataAdapter
implements DataAdapter<Long> {
    private boolean myRenderInstantaneousData = true;
    @NotNull
    private final TLongArrayList myTimestampData = new TLongArrayList();
    @NotNull
    private final TLongArrayList myData = new TLongArrayList();

    public void setReturnInstantaneousData(boolean useInstantaneous) {
        this.myRenderInstantaneousData = useInstantaneous;
    }

    public void updateByDelta(long timestamp, long delta) {
        this.update(timestamp, this.myData.get(this.myData.size() - 1) + delta);
    }

    public void update(long timestamp, long value) {
        this.myTimestampData.add(timestamp);
        this.myData.add(value);
    }

    public int getClosestTimeIndex(long timeUs, boolean leftClosest) {
        return DataAdapter.getClosestIndex((TLongArrayList)this.myTimestampData, (long)timeUs, (boolean)leftClosest);
    }

    public SeriesData<Long> get(int index) {
        if (this.myRenderInstantaneousData) {
            return new SeriesData(this.myTimestampData.get(index), (Object)(this.getInternal(index) - this.getInternal(index - 1)));
        }
        return new SeriesData(this.myTimestampData.get(index), (Object)this.getInternal(index));
    }

    public long getInternal(int index) {
        if (index <= 0) {
            return this.myData.get(0);
        }
        if (index >= this.myData.size()) {
            return this.myData.get(this.myData.size());
        }
        return this.myData.get(index);
    }

    public long getLatest() {
        return this.getInternal(this.myData.size() - 1);
    }

    public long getLatestDelta() {
        return this.getInternal(this.myData.size() - 1) - this.getInternal(this.myData.size() - 2);
    }

    public void reset() {
        this.myTimestampData.clear();
        this.myData.clear();
    }

    public void stop() {
    }
}

