/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeFolder;
import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.android.tools.idea.navigator.nodes.NativeAndroidSourceDirectoryNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeAndroidLibraryNode
extends ProjectViewNode<Collection<NativeArtifact>>
implements DirectoryGroupNode {
    private static final Set<String> HEADER_FILE_EXTENSIONS = ImmutableSet.of((Object)"h", (Object)"hpp", (Object)"hh", (Object)"h++", (Object)"hxx");
    @NotNull
    private final String myNativeLibraryName;
    @NotNull
    private final String myNativeLibraryType;
    @NotNull
    private final Collection<String> mySourceFileExtensions;
    @Nullable
    private VirtualFile libraryDirectory;

    public NativeAndroidLibraryNode(@NotNull Project project, @NotNull String nativeLibraryName, @NotNull String nativeLibraryType, @NotNull Collection<NativeArtifact> artifacts, @NotNull ViewSettings settings, @NotNull Collection<String> sourceFileExtensions) {
        if (project == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(0);
        }
        if (nativeLibraryName == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(1);
        }
        if (nativeLibraryType == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(2);
        }
        if (artifacts == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(4);
        }
        if (sourceFileExtensions == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(5);
        }
        super(project, artifacts, settings);
        this.myNativeLibraryName = nativeLibraryName;
        this.myNativeLibraryType = nativeLibraryType;
        this.mySourceFileExtensions = sourceFileExtensions;
    }

    @NotNull
    public static Collection<AbstractTreeNode> getSourceDirectoryNodes(@NotNull Project project, @NotNull Collection<NativeArtifact> artifacts, @NotNull ViewSettings settings, @NotNull Collection<String> sourceFileExtensions) {
        if (project == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(6);
        }
        if (artifacts == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(7);
        }
        if (settings == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(8);
        }
        if (sourceFileExtensions == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(9);
        }
        TreeMap<String, RootDirectory> rootDirectories = new TreeMap<String, RootDirectory>();
        for (NativeArtifact artifact : artifacts) {
            NativeAndroidLibraryNode.addSourceFolders(rootDirectories, artifact);
            NativeAndroidLibraryNode.addSourceFiles(rootDirectories, artifact);
        }
        if (rootDirectories.size() > 1) {
            NativeAndroidLibraryNode.groupDirectories(rootDirectories);
        }
        if (rootDirectories.size() > 1) {
            NativeAndroidLibraryNode.mergeDirectories(rootDirectories);
        }
        HashSet fileExtensions = Sets.newHashSetWithExpectedSize((int)(sourceFileExtensions.size() + HEADER_FILE_EXTENSIONS.size()));
        fileExtensions.addAll(sourceFileExtensions);
        fileExtensions.addAll(HEADER_FILE_EXTENSIONS);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ArrayList children = Lists.newArrayList();
        for (RootDirectory rootDirectory : rootDirectories.values()) {
            PsiDirectory psiDir = psiManager.findDirectory(rootDirectory.rootDir);
            if (psiDir == null) continue;
            children.add(new NativeAndroidSourceDirectoryNode(project, psiDir, settings, fileExtensions, rootDirectory.sourceFolders, rootDirectory.sourceFiles));
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static void addSourceFolders(TreeMap<String, RootDirectory> rootDirectories, NativeArtifact artifact) {
        for (VirtualFile sourceFolder : NativeAndroidLibraryNode.getSourceFolders(artifact)) {
            String path = sourceFolder.getPath();
            if (rootDirectories.containsKey(path)) continue;
            RootDirectory rootDirectory = new RootDirectory(sourceFolder);
            rootDirectory.sourceFolders.add(sourceFolder);
            rootDirectories.put(path, rootDirectory);
        }
    }

    @NotNull
    private static List<VirtualFile> getSourceFolders(@NotNull NativeArtifact artifact) {
        if (artifact == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(11);
        }
        ArrayList sourceFolders = Lists.newArrayList();
        for (File headerRoot : artifact.getExportedHeaders()) {
            sourceFolders.add(headerRoot);
        }
        for (NativeFolder sourceFolder : artifact.getSourceFolders()) {
            sourceFolders.add(sourceFolder.getFolderPath());
        }
        List<VirtualFile> list = NativeAndroidLibraryNode.convertToVirtualFiles(sourceFolders);
        if (list == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static void addSourceFiles(TreeMap<String, RootDirectory> rootDirectories, NativeArtifact artifact) {
        for (VirtualFile sourceFile : NativeAndroidLibraryNode.getSourceFiles(artifact)) {
            VirtualFile sourceFolder = sourceFile.getParent();
            String path = sourceFolder.getPath();
            RootDirectory rootDirectory = rootDirectories.get(path);
            if (rootDirectory == null) {
                rootDirectory = new RootDirectory(sourceFolder);
                rootDirectories.put(path, rootDirectory);
            }
            rootDirectory.sourceFiles.add(sourceFile);
        }
    }

    @NotNull
    private static List<VirtualFile> getSourceFiles(@NotNull NativeArtifact artifact) {
        if (artifact == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(13);
        }
        ArrayList sourceFiles = Lists.newArrayList();
        for (NativeFile sourceFile : artifact.getSourceFiles()) {
            File source = sourceFile.getFilePath();
            sourceFiles.add(source);
            for (String extension : HEADER_FILE_EXTENSIONS) {
                sourceFiles.add(new File(source.getParentFile(), FileUtil.getNameWithoutExtension((File)source) + "." + extension));
            }
        }
        List<VirtualFile> list = NativeAndroidLibraryNode.convertToVirtualFiles(sourceFiles);
        if (list == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private static List<VirtualFile> convertToVirtualFiles(@NotNull Collection<File> files) {
        if (files == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(15);
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)files.size());
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (File file : files) {
            VirtualFile virtualFile = fileSystem.findFileByIoFile(file);
            if (virtualFile == null) continue;
            result.add(virtualFile);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    private static void groupDirectories(TreeMap<String, RootDirectory> rootDirectories) {
        String keyToMerge = rootDirectories.lastKey();
        while (keyToMerge != null) {
            RootDirectory dirToMerge = rootDirectories.get(keyToMerge);
            VirtualFile dirToMergeParent = dirToMerge.rootDir.getParent();
            if (dirToMergeParent == null) {
                keyToMerge = rootDirectories.lowerKey(keyToMerge);
                continue;
            }
            RootDirectory targetDir = rootDirectories.get(dirToMergeParent.getPath());
            if (targetDir != null) {
                targetDir.sourceFolders.addAll(dirToMerge.sourceFolders);
                targetDir.sourceFiles.addAll(dirToMerge.sourceFiles);
                rootDirectories.remove(keyToMerge);
                keyToMerge = rootDirectories.lastKey();
                continue;
            }
            String previousKey = rootDirectories.lowerKey(keyToMerge);
            if (previousKey == null) break;
            RootDirectory previousDir = rootDirectories.get(previousKey);
            VirtualFile previousDirParent = previousDir.rootDir.getParent();
            if (previousDirParent != null && previousDirParent.getPath().equals(dirToMergeParent.getPath())) {
                targetDir = rootDirectories.get(dirToMergeParent.getPath());
                if (targetDir == null) {
                    targetDir = new RootDirectory(dirToMergeParent);
                    rootDirectories.put(dirToMergeParent.getPath(), targetDir);
                }
                targetDir.sourceFolders.addAll(dirToMerge.sourceFolders);
                targetDir.sourceFolders.addAll(previousDir.sourceFolders);
                targetDir.sourceFiles.addAll(dirToMerge.sourceFiles);
                targetDir.sourceFiles.addAll(previousDir.sourceFiles);
                rootDirectories.remove(keyToMerge);
                rootDirectories.remove(previousKey);
                keyToMerge = rootDirectories.lastKey();
                continue;
            }
            keyToMerge = previousKey;
        }
    }

    private static void mergeDirectories(TreeMap<String, RootDirectory> rootDirectories) {
        String keyToMerge = rootDirectories.lastKey();
        while (keyToMerge != null) {
            VirtualFile dir;
            RootDirectory dirToMerge = rootDirectories.get(keyToMerge);
            for (dir = dirToMerge.rootDir.getParent(); dir != null; dir = dir.getParent()) {
                RootDirectory targetDir = rootDirectories.get(dir.getPath());
                if (targetDir == null) {
                    continue;
                }
                targetDir.sourceFolders.addAll(dirToMerge.sourceFolders);
                targetDir.sourceFiles.addAll(dirToMerge.sourceFiles);
                rootDirectories.remove(keyToMerge);
                keyToMerge = rootDirectories.lastKey();
                break;
            }
            if (rootDirectories.size() <= 1) break;
            if (dir != null) continue;
            keyToMerge = rootDirectories.lowerKey(keyToMerge);
        }
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        Collection<AbstractTreeNode> sourceDirectoryNodes = NativeAndroidLibraryNode.getSourceDirectoryNodes(this.myProject, this.getArtifacts(), this.getSettings(), this.mySourceFileExtensions);
        if (sourceDirectoryNodes.size() == 1) {
            AbstractTreeNode node = (AbstractTreeNode)Iterables.getOnlyElement(sourceDirectoryNodes);
            assert (node instanceof NativeAndroidSourceDirectoryNode);
            NativeAndroidSourceDirectoryNode sourceDirectoryNode = (NativeAndroidSourceDirectoryNode)node;
            sourceDirectoryNode.setShowDirectoryPath(false);
            this.libraryDirectory = sourceDirectoryNode.getVirtualFile();
            Collection collection = sourceDirectoryNode.getChildren();
            if (collection == null) {
                NativeAndroidLibraryNode.$$$reportNull$$$0(17);
            }
            return collection;
        }
        for (AbstractTreeNode sourceDirectoryNode : sourceDirectoryNodes) {
            if (!(sourceDirectoryNode instanceof NativeAndroidSourceDirectoryNode)) continue;
            ((NativeAndroidSourceDirectoryNode)sourceDirectoryNode).setShowDirectoryPath(true);
        }
        this.libraryDirectory = null;
        Collection<AbstractTreeNode> collection = sourceDirectoryNodes;
        if (collection == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(18);
        }
        return collection;
    }

    protected void update(PresentationData presentation) {
        presentation.addText(this.myNativeLibraryName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (!this.myNativeLibraryType.isEmpty()) {
            presentation.addText(" (" + this.myNativeLibraryType + (this.libraryDirectory != null ? ", " + FileUtil.getLocationRelativeToUserHome((String)this.libraryDirectory.getPresentableUrl()) : "") + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation.setIcon(AllIcons.Nodes.NativeLibrariesFolder);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(19);
        }
        for (NativeArtifact artifact : this.getArtifacts()) {
            for (VirtualFile folder : NativeAndroidLibraryNode.getSourceFolders(artifact)) {
                if (!VfsUtilCore.isAncestor((VirtualFile)folder, (VirtualFile)file, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.myNativeLibraryType + this.myNativeLibraryName;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.myNativeLibraryName + (this.myNativeLibraryType.isEmpty() ? "" : " (" + this.myNativeLibraryType + ")");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NativeAndroidLibraryNode that = (NativeAndroidLibraryNode)o;
        return this.getValue() == that.getValue();
    }

    public int hashCode() {
        int result = super.hashCode();
        for (NativeArtifact artifact : this.getArtifacts()) {
            result = 31 * result + artifact.hashCode();
        }
        return result;
    }

    @Override
    @NotNull
    public PsiDirectory[] getDirectories() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList<PsiDirectory> psiDirectories = new ArrayList<PsiDirectory>();
        for (NativeArtifact artifact : this.getArtifacts()) {
            for (VirtualFile f : NativeAndroidLibraryNode.getSourceFolders(artifact)) {
                PsiDirectory dir = psiManager.findDirectory(f);
                if (dir == null) continue;
                psiDirectories.add(dir);
            }
        }
        PsiDirectory[] psiDirectoryArray = psiDirectories.toArray(new PsiDirectory[psiDirectories.size()]);
        if (psiDirectoryArray == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(20);
        }
        return psiDirectoryArray;
    }

    @NotNull
    private Collection<NativeArtifact> getArtifacts() {
        Collection artifacts = (Collection)this.getValue();
        assert (artifacts != null);
        Collection collection = artifacts;
        if (collection == null) {
            NativeAndroidLibraryNode.$$$reportNull$$$0(21);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeLibraryName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeLibraryType";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFileExtensions";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/NativeAndroidLibraryNode";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/NativeAndroidLibraryNode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceDirectoryNodes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFolders";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToVirtualFiles";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSourceDirectoryNodes";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFolders";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFiles";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "convertToVirtualFiles";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RootDirectory {
        @NotNull
        private final VirtualFile rootDir;
        @NotNull
        private final List<VirtualFile> sourceFolders;
        @NotNull
        private final List<VirtualFile> sourceFiles;

        public RootDirectory(@NotNull VirtualFile rootDir) {
            if (rootDir == null) {
                RootDirectory.$$$reportNull$$$0(0);
            }
            this.sourceFolders = Lists.newArrayList();
            this.sourceFiles = Lists.newArrayList();
            this.rootDir = rootDir;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "com/android/tools/idea/navigator/nodes/NativeAndroidLibraryNode$RootDirectory", "<init>"));
        }
    }
}

