/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.npw.AbstractModuleTemplate;
import com.android.tools.idea.npw.ChooseTemplateStep;
import com.android.tools.idea.npw.ModuleTemplate;
import com.android.tools.idea.npw.NewModuleDynamicPath;
import com.android.tools.idea.npw.NewModuleWizardState;
import com.android.tools.idea.npw.WizardPath;
import com.android.tools.idea.npw.deprecated.ImportSourceModulePath;
import com.android.tools.idea.npw.deprecated.WrapArchiveWizardPath;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.options.ConfigurationException;
import icons.AndroidIcons;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyPathWrapper
implements NewModuleDynamicPath {
    private final NewModuleWizardState myWizardState;
    private final WizardPath myWizardPath;
    private final List<ModuleWizardStep> mySteps;
    private final Iterable<ModuleTemplate> myTemplates;
    private DynamicWizard myWizard;
    private int myCurrentStep;

    public LegacyPathWrapper(NewModuleWizardState wizardState, WizardPath wizardPath) {
        this.myTemplates = LegacyPathWrapper.getModuleTemplates(wizardPath);
        this.myWizardState = wizardState;
        this.myWizardPath = wizardPath;
        this.mySteps = ImmutableList.copyOf(this.myWizardPath.getSteps());
    }

    private static boolean isStepValid(ModuleWizardStep currentStep) {
        if (currentStep == null) {
            return true;
        }
        try {
            return currentStep.validate();
        }
        catch (ConfigurationException e) {
            return false;
        }
    }

    static Iterable<ModuleTemplate> getModuleTemplates(@NotNull WizardPath wizardPath) {
        if (wizardPath == null) {
            LegacyPathWrapper.$$$reportNull$$$0(0);
        }
        Collection<ChooseTemplateStep.MetadataListItem> templates = wizardPath.getBuiltInTemplates();
        if (wizardPath instanceof ImportSourceModulePath) {
            ChooseTemplateStep.MetadataListItem template = (ChooseTemplateStep.MetadataListItem)Iterables.getFirst(templates, null);
            assert (template != null);
            LegacyModuleTemplate importEclipse = new LegacyModuleTemplate(template, "Import Eclipse ADT Project", "Import an existing Eclipse ADT project as a module", AndroidIcons.ModuleTemplates.EclipseModule);
            LegacyModuleTemplate importGradle = new LegacyModuleTemplate(template, "Import Gradle Project", "Import an existing Gradle project as a module", AndroidIcons.ModuleTemplates.GradleModule);
            return ImmutableList.of((Object)importGradle, (Object)importEclipse);
        }
        if (wizardPath instanceof WrapArchiveWizardPath) {
            ChooseTemplateStep.MetadataListItem template = (ChooseTemplateStep.MetadataListItem)Iterables.getFirst(templates, null);
            assert (template != null);
            return Collections.singleton(new LegacyModuleTemplate(template, "Import .JAR/.AAR Package", "Import an existing JAR or AAR package as a new project module", AndroidIcons.ModuleTemplates.Android));
        }
        ImmutableList.Builder templatesBuilder = ImmutableList.builder();
        for (ChooseTemplateStep.MetadataListItem template : templates) {
            templatesBuilder.add((Object)new LegacyModuleTemplate(template, null));
        }
        return templatesBuilder.build();
    }

    @Override
    public void onPathStarted(boolean fromBeginning) {
        if (fromBeginning) {
            ModuleTemplate moduleTemplate = this.myWizard.getState().get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
            if (moduleTemplate instanceof LegacyModuleTemplate) {
                this.myWizardState.setTemplateLocation(((LegacyModuleTemplate)moduleTemplate).getLocation());
            }
            this.myCurrentStep = this.findNext(-1, 1);
        } else {
            this.myCurrentStep = this.findNext(this.mySteps.size(), -1);
        }
        this.updateWizard();
    }

    private int findNext(int currentStep, int direction) {
        boolean isWithinBounds;
        int stepCount = this.mySteps.size();
        do {
            boolean bl = isWithinBounds = (currentStep += direction) >= 0 && currentStep < stepCount;
        } while (isWithinBounds && !this.myWizardPath.isStepVisible(this.mySteps.get(currentStep)));
        return !isWithinBounds ? -1 : currentStep;
    }

    public ModuleWizardStep getCurrentStep() {
        return this.myCurrentStep < 0 ? null : this.mySteps.get(this.myCurrentStep);
    }

    public List<ModuleWizardStep> getAllSteps() {
        return this.mySteps;
    }

    @Override
    public boolean hasNext() {
        return this.findNext(this.myCurrentStep, 1) >= 0;
    }

    @Override
    public boolean hasPrevious() {
        return this.findNext(this.myCurrentStep, -1) >= 0;
    }

    @Override
    public boolean canGoPrevious() {
        return true;
    }

    @Override
    public boolean canGoNext() {
        return LegacyPathWrapper.isStepValid(this.getCurrentStep()) && this.hasNext();
    }

    @Override
    public boolean containsStep(@NotNull String stepName, boolean visibleOnly) {
        if (stepName == null) {
            LegacyPathWrapper.$$$reportNull$$$0(1);
        }
        for (ModuleWizardStep step : this.mySteps) {
            if (!stepName.equals(step.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void navigateToNamedStep(@NotNull String stepName, boolean requireVisible) {
        if (stepName == null) {
            LegacyPathWrapper.$$$reportNull$$$0(2);
        }
        for (ModuleWizardStep step : this.mySteps) {
            if (!stepName.equals(step.getName())) continue;
            this.myCurrentStep = this.mySteps.indexOf(step);
            this.updateWizard();
            return;
        }
    }

    @Override
    public boolean isPathVisible() {
        ModuleTemplate moduleTemplate = this.myWizard.getState().get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
        return moduleTemplate != null && Iterables.contains(this.myTemplates, (Object)moduleTemplate);
    }

    @Override
    public int getVisibleStepCount() {
        int count = 0;
        for (ModuleWizardStep step : this.mySteps) {
            if (!this.myWizardPath.isStepVisible(step)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void attachToWizard(DynamicWizard dynamicWizard) {
        this.myWizard = dynamicWizard;
    }

    @Override
    @Nullable
    public DynamicWizard getWizard() {
        return this.myWizard;
    }

    @Override
    public boolean isPathRequired() {
        return true;
    }

    @Override
    @Nullable
    public Step next() {
        return this.navigate(1);
    }

    private Step navigate(int direction) {
        this.myCurrentStep = this.findNext(this.myCurrentStep, direction);
        if (this.myCurrentStep < 0) {
            return null;
        }
        assert (this.myCurrentStep >= 0);
        this.updateWizard();
        return (Step)this.mySteps.get(this.myCurrentStep);
    }

    @Override
    @Nullable
    public Step previous() {
        return this.navigate(-1);
    }

    @Override
    public boolean canPerformFinishingActions() {
        return true;
    }

    @Override
    public boolean performFinishingActions() {
        this.myWizardPath.createModule();
        return true;
    }

    @Override
    public void updateCurrentStep() {
    }

    @Override
    public void setErrorHtml(String errorMessage) {
    }

    @Override
    @NotNull
    public Iterable<ModuleTemplate> getModuleTemplates() {
        Iterable<ModuleTemplate> iterable = this.myTemplates;
        if (iterable == null) {
            LegacyPathWrapper.$$$reportNull$$$0(3);
        }
        return iterable;
    }

    public void updateWizard() {
        if (this.isPathVisible()) {
            for (ModuleWizardStep step : this.myWizardPath.getSteps()) {
                step.updateStep();
            }
            this.myWizard.updateButtons(true, this.canGoNext(), true, !this.canGoNext() && LegacyPathWrapper.isStepValid(this.getCurrentStep()));
        }
    }

    @Override
    public boolean readyToLeavePath() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardPath";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/LegacyPathWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/LegacyPathWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModuleTemplates";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "containsStep";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "navigateToNamedStep";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LegacyModuleTemplate
    extends AbstractModuleTemplate {
        private final File myLocation;

        public LegacyModuleTemplate(@NotNull ChooseTemplateStep.MetadataListItem listItem, @NotNull String name, @Nullable String description, @Nullable Icon icon) {
            if (listItem == null) {
                LegacyModuleTemplate.$$$reportNull$$$0(0);
            }
            if (name == null) {
                LegacyModuleTemplate.$$$reportNull$$$0(1);
            }
            super(name, description, null, icon);
            this.myLocation = listItem.getTemplateFile();
        }

        public LegacyModuleTemplate(@NotNull ChooseTemplateStep.MetadataListItem listItem, @Nullable Icon icon) {
            if (listItem == null) {
                LegacyModuleTemplate.$$$reportNull$$$0(2);
            }
            this(listItem, listItem.toString(), listItem.getDescription(), icon);
        }

        @NotNull
        public File getLocation() {
            File file = this.myLocation;
            if (file == null) {
                LegacyModuleTemplate.$$$reportNull$$$0(3);
            }
            return file;
        }

        @Override
        public void updateWizardState(@NotNull ScopedStateStore state) {
            if (state == null) {
                LegacyModuleTemplate.$$$reportNull$$$0(4);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listItem";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/LegacyPathWrapper$LegacyModuleTemplate";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/LegacyPathWrapper$LegacyModuleTemplate";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "updateWizardState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

