/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.npw.PostStartupGradleSyncListener;
import com.android.tools.idea.npw.cpp.ConfigureCppSupportPath;
import com.android.tools.idea.npw.deprecated.ConfigureAndroidProjectPath;
import com.android.tools.idea.npw.deprecated.NewFormFactorModulePath;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.templates.KeystoreUtils;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.idea.templates.SupportLibrary;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewProjectWizardDynamic
extends DynamicWizard {
    private static final String ERROR_MSG_TITLE = "Error in New Project Wizard";
    private Project myProject;

    public NewProjectWizardDynamic(@Nullable Project project, @Nullable Module module) {
        super(project, module, "New Project");
        this.setTitle("Create New Project");
    }

    public NewProjectWizardDynamic(@Nullable Project project, @Nullable Module module, @NotNull DynamicWizardHost host) {
        if (host == null) {
            NewProjectWizardDynamic.$$$reportNull$$$0(0);
        }
        super(project, module, "New Project", host);
        this.setTitle("Create New Project");
    }

    @Override
    public void init() {
        this.checkSdk();
        this.addPaths();
        this.initState();
        super.init();
    }

    protected void checkSdk() {
        if (!AndroidSdkUtils.isAndroidSdkAvailable() || !TemplateManager.templatesAreValid()) {
            String title = "SDK problem";
            String msg = "<html>Your Android SDK is missing, out of date, or is missing templates.<br>You can configure your SDK via <b>Configure | Project Defaults | Project Structure | SDKs</b></html>";
            Messages.showErrorDialog((String)msg, (String)title);
            throw new IllegalStateException("Android SDK missing");
        }
    }

    private void addPaths() {
        this.addPath(new ConfigureAndroidProjectPath(this.getDisposable()));
        for (NewFormFactorModulePath path : NewFormFactorModulePath.getAvailableFormFactorModulePaths(this.getDisposable())) {
            this.addPath(path);
        }
        this.addPath(new ConfigureCppSupportPath(this.getDisposable()));
    }

    private void initState() {
        NewProjectWizardDynamic.initState(this.getState(), AndroidPluginGeneration.ORIGINAL.getLatestKnownVersion());
    }

    static void initState(@NotNull ScopedStateStore state, @NotNull String gradlePluginVersion) {
        AndroidSdkData data;
        if (state == null) {
            NewProjectWizardDynamic.$$$reportNull$$$0(1);
        }
        if (gradlePluginVersion == null) {
            NewProjectWizardDynamic.$$$reportNull$$$0(2);
        }
        state.put(WizardConstants.GRADLE_PLUGIN_VERSION_KEY, gradlePluginVersion);
        state.put(WizardConstants.GRADLE_VERSION_KEY, "3.3");
        state.put(WizardConstants.IS_GRADLE_PROJECT_KEY, true);
        state.put(WizardConstants.IS_NEW_PROJECT_KEY, true);
        state.put(WizardConstants.TARGET_FILES_KEY, new HashSet());
        state.put(WizardConstants.FILES_TO_OPEN_KEY, new ArrayList());
        state.put(WizardConstants.USE_PER_MODULE_REPOS_KEY, false);
        state.put(WizardConstants.ALSO_CREATE_IAPK_KEY, true);
        state.put(WizardConstants.IS_LOW_MEMORY_KEY, SystemInfo.is32Bit);
        try {
            state.put(WizardConstants.DEBUG_KEYSTORE_SHA_1_KEY, KeystoreUtils.sha1(KeystoreUtils.getOrCreateDefaultDebugKeystore()));
        }
        catch (Exception exception) {
            LOG.warn("Could not create debug keystore", (Throwable)exception);
            state.put(WizardConstants.DEBUG_KEYSTORE_SHA_1_KEY, "");
        }
        String mavenUrl = System.getProperty("android.mavenRepoUrl");
        if (mavenUrl != null) {
            state.put(WizardConstants.MAVEN_URL_KEY, mavenUrl);
        }
        if ((data = AndroidSdks.getInstance().tryToChooseAndroidSdk()) != null) {
            File sdkLocation = data.getLocation();
            state.put(WizardConstants.SDK_DIR_KEY, sdkLocation.getPath());
            String espressoVersion = RepositoryUrlManager.get().getLibraryRevision(SupportLibrary.ESPRESSO_CORE.getGroupId(), SupportLibrary.ESPRESSO_CORE.getArtifactId(), null, false, sdkLocation, FileOpUtils.create());
            if (espressoVersion != null) {
                state.put(WizardConstants.ESPRESSO_VERSION_KEY, espressoVersion);
            }
        }
    }

    @Override
    protected String getWizardActionDescription() {
        return String.format("Create %1$s", this.getState().get(WizardConstants.APPLICATION_NAME_KEY));
    }

    @Override
    public void performFinishingActions() {
        ApplicationManager.getApplication().invokeLater(this::runFinish);
    }

    private void runFinish() {
        Sdk jdk;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        GradleProjectImporter projectImporter = GradleProjectImporter.getInstance();
        String rootPath = this.getState().get(WizardConstants.PROJECT_LOCATION_KEY);
        if (rootPath == null) {
            LOG.error("No root path specified for project");
            return;
        }
        File rootLocation = new File(rootPath);
        File wrapperPropertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(rootLocation);
        try {
            GradleWrapper.get(wrapperPropertiesFilePath).updateDistributionUrl("3.3");
        }
        catch (IOException e) {
            LOG.warn("Failed to update Gradle wrapper file", (Throwable)e);
        }
        String projectName = this.getState().get(WizardConstants.APPLICATION_NAME_KEY);
        if (projectName == null) {
            projectName = "Unnamed Project";
        }
        LanguageLevel initialLanguageLevel = null;
        for (FormFactor factor : FormFactor.values()) {
            LanguageLevel level;
            String version = this.getState().get(FormFactorUtils.getLanguageLevelKey(factor));
            if (version == null || (level = LanguageLevel.parse((String)version.toString())) == null || initialLanguageLevel != null && !level.isAtLeast(initialLanguageLevel)) continue;
            initialLanguageLevel = level;
        }
        if (!IdeInfo.getInstance().isAndroidStudio() && (jdk = IdeSdks.getInstance().getJdk()) != null) {
            ApplicationManager.getApplication().runWriteAction(() -> ProjectRootManager.getInstance((Project)this.myProject).setProjectSdk(jdk));
        }
        try {
            PostStartupGradleSyncListener listener = new PostStartupGradleSyncListener(() -> {
                Iterable targetFiles = this.myState.get(WizardConstants.TARGET_FILES_KEY);
                assert (targetFiles != null);
                TemplateUtils.reformatAndRearrange(this.myProject, targetFiles);
                Collection filesToOpen = this.myState.get(WizardConstants.FILES_TO_OPEN_KEY);
                assert (filesToOpen != null);
                TemplateUtils.openEditors(this.myProject, filesToOpen, true);
            });
            GradleProjectImporter.Request request = new GradleProjectImporter.Request();
            request.setLanguageLevel(initialLanguageLevel).setProject(this.myProject);
            projectImporter.importProject(projectName, rootLocation, request, listener);
        }
        catch (ConfigurationException | IOException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)ERROR_MSG_TITLE);
            LOG.error(e);
        }
    }

    @Override
    @NotNull
    protected String getProgressTitle() {
        if ("Creating project..." == null) {
            NewProjectWizardDynamic.$$$reportNull$$$0(3);
        }
        return "Creating project...";
    }

    @Override
    public void doFinishAction() {
        if (!this.checkFinish()) {
            return;
        }
        final String projectLocation = this.myState.get(WizardConstants.PROJECT_LOCATION_KEY);
        assert (projectLocation != null);
        boolean couldEnsureLocationExists = (Boolean)WriteCommandAction.runWriteCommandAction((Project)this.getProject(), (Computable)new Computable<Boolean>(){

            public Boolean compute() {
                try {
                    if (VfsUtil.createDirectoryIfMissing((String)projectLocation) != null && FileOpUtils.create().canWrite(new File(projectLocation))) {
                        return true;
                    }
                }
                catch (Exception e) {
                    DynamicWizard.LOG.error(String.format("Exception thrown when creating target project location: %1$s", projectLocation), (Throwable)e);
                }
                return false;
            }
        });
        if (!couldEnsureLocationExists) {
            Messages.showErrorDialog((String)String.format("Could not ensure the target project location exists and is accessible:\n\n%1$s\n\nPlease try to specify another path.", projectLocation), (String)"Error Creating Project");
            this.navigateToNamedStep("Create Android Project", true);
            this.myHost.shakeWindow();
            return;
        }
        try {
            this.doFinish();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    protected void doFinish() throws IOException {
        String projectLocation = this.myState.get(WizardConstants.PROJECT_LOCATION_KEY);
        String name = this.myState.get(WizardConstants.APPLICATION_NAME_KEY);
        assert (projectLocation != null && name != null);
        this.myProject = (Project)UIUtil.invokeAndWaitIfNeeded(() -> ProjectManager.getInstance().createProject(name, projectLocation));
        super.doFinish();
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePluginVersion";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/NewProjectWizardDynamic";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/NewProjectWizardDynamic";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initState";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

