/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.CategoryIconMap;
import com.android.tools.idea.npw.assetstudio.wizard.GenerateIconsModel;
import com.android.tools.idea.npw.project.AndroidSourceSet;
import com.android.tools.idea.ui.FileTreeCellRenderer;
import com.android.tools.idea.ui.FileTreeModel;
import com.android.tools.idea.ui.properties.ListenerManager;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.expressions.value.AsValueExpression;
import com.android.tools.idea.ui.properties.swing.SelectedItemProperty;
import com.android.tools.idea.ui.validation.Validator;
import com.android.tools.idea.ui.validation.ValidatorPanel;
import com.android.tools.idea.ui.validation.validators.FalseValidator;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.primitives.Ints;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;

public final class ConfirmGenerateIconsStep
extends ModelWizardStep<GenerateIconsModel> {
    private static final DefaultTreeModel EMPTY_MODEL = new DefaultTreeModel(null);
    private static final int MAX_TREE_ROW_HEIGHT = 200;
    private final ValidatorPanel myValidatorPanel;
    private final ListenerManager myListeners;
    private JPanel myRootPanel;
    private JComboBox myPathsComboBox;
    private Tree myOutputPreviewTree;
    private ObservableValue<AndroidSourceSet> mySelectedSourceSet;
    private BoolProperty myFilesAlreadyExist;

    public ConfirmGenerateIconsStep(@NotNull GenerateIconsModel model, @NotNull List<AndroidSourceSet> sourceSets) {
        if (model == null) {
            ConfirmGenerateIconsStep.$$$reportNull$$$0(0);
        }
        if (sourceSets == null) {
            ConfirmGenerateIconsStep.$$$reportNull$$$0(1);
        }
        super(model, "Confirm Icon Path");
        this.$$$setupUI$$$();
        this.myListeners = new ListenerManager();
        this.myFilesAlreadyExist = new BoolValueProperty();
        this.myValidatorPanel = new ValidatorPanel(this, this.myRootPanel);
        DefaultComboBoxModel<AndroidSourceSet> sourceSetsModel = new DefaultComboBoxModel<AndroidSourceSet>();
        for (AndroidSourceSet sourceSet : sourceSets) {
            sourceSetsModel.addElement(sourceSet);
        }
        this.myPathsComboBox.setRenderer(new ListCellRendererWrapper<AndroidSourceSet>(){

            public void customize(JList list, AndroidSourceSet sourceSet, int index, boolean selected, boolean hasFocus) {
                this.setText(sourceSet.getName());
            }
        });
        this.myPathsComboBox.setModel(sourceSetsModel);
        this.myOutputPreviewTree.setModel((TreeModel)EMPTY_MODEL);
        this.myOutputPreviewTree.setCellRenderer((TreeCellRenderer)((Object)new FileTreeCellRenderer()));
        this.myOutputPreviewTree.setBorder(BorderFactory.createLineBorder(UIUtil.getBoundsColor()));
        this.myOutputPreviewTree.setRowHeight(-1);
        this.myOutputPreviewTree.getEmptyText().setText("No resource folder defined in project");
        String alreadyExistsError = WizardUtils.toHtmlString("Some existing files will be overwritten by this operation.<br>Files which replace existing files are marked red in the preview above.");
        this.myValidatorPanel.registerValidator(this.myFilesAlreadyExist, new FalseValidator(Validator.Severity.WARNING, alreadyExistsError));
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        ValidatorPanel validatorPanel = this.myValidatorPanel;
        if (validatorPanel == null) {
            ConfirmGenerateIconsStep.$$$reportNull$$$0(2);
        }
        return validatorPanel;
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            ConfirmGenerateIconsStep.$$$reportNull$$$0(3);
        }
        this.mySelectedSourceSet = new AsValueExpression<AndroidSourceSet>(new SelectedItemProperty(this.myPathsComboBox));
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            ConfirmGenerateIconsStep.$$$reportNull$$$0(4);
        }
        return observableBool;
    }

    @Override
    protected void onProceeding() {
        ((GenerateIconsModel)this.getModel()).setPaths(this.mySelectedSourceSet.get().getPaths());
    }

    @Override
    protected void onEntering() {
        this.myListeners.release(this.mySelectedSourceSet);
        this.myListeners.receiveAndFire(this.mySelectedSourceSet, sourceSet -> {
            AndroidIconGenerator iconGenerator = ((GenerateIconsModel)this.getModel()).getIconGenerator();
            File resDir = sourceSet.getPaths().getResDirectory();
            if (iconGenerator == null || resDir == null || resDir.getParentFile() == null) {
                return;
            }
            final Map<File, BufferedImage> pathIconMap = iconGenerator.generateIntoFileMap(sourceSet.getPaths());
            this.myFilesAlreadyExist.set(false);
            int minHeight = Integer.MAX_VALUE;
            int maxHeight = Integer.MIN_VALUE;
            for (BufferedImage image : pathIconMap.values()) {
                minHeight = Math.min(minHeight, image.getHeight());
                maxHeight = Math.max(maxHeight, image.getHeight());
            }
            ImmutableSortedSet.Builder sortedPaths = ImmutableSortedSet.orderedBy((Comparator)new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    String path1 = file1.getAbsolutePath();
                    String path2 = file2.getAbsolutePath();
                    Density density1 = CategoryIconMap.pathToDensity(path1);
                    Density density2 = CategoryIconMap.pathToDensity(path2);
                    if (density1 != null && density2 != null && density1 != density2) {
                        return Ints.compare((int)density2.ordinal(), (int)density1.ordinal());
                    }
                    BufferedImage image1 = (BufferedImage)pathIconMap.get(file1);
                    BufferedImage image2 = (BufferedImage)pathIconMap.get(file2);
                    int compareValue = Ints.compare((int)image2.getHeight(), (int)image1.getHeight());
                    return compareValue != 0 ? compareValue : path2.compareTo(path1);
                }
            });
            sortedPaths.addAll(pathIconMap.keySet());
            FileTreeModel treeModel = new FileTreeModel(resDir.getParentFile(), true);
            for (File path : sortedPaths.build()) {
                Image image = pathIconMap.get(path);
                if (path.exists()) {
                    this.myFilesAlreadyExist.set(true);
                }
                if (maxHeight > 200) {
                    double hScale;
                    int hCurr = image.getHeight(null);
                    int wCurr = image.getWidth(null);
                    if (maxHeight != minHeight) {
                        double hCurrPercent = (double)(hCurr - minHeight) / (double)(maxHeight - minHeight);
                        double scaledDeltaH = hCurrPercent * (double)(200 - minHeight);
                        double hCurrScaled = (double)minHeight + scaledDeltaH;
                        hScale = hCurrScaled / (double)hCurr;
                    } else {
                        hScale = 200.0 / (double)hCurr;
                    }
                    int hFinal = (int)((double)hCurr * hScale);
                    int wFinal = (int)((double)wCurr * hScale);
                    image = image.getScaledInstance(wFinal, hFinal, 4);
                }
                treeModel.forceAddFile(path, new ImageIcon(image));
            }
            this.myOutputPreviewTree.setModel((TreeModel)treeModel);
            for (int i = 0; i < this.myOutputPreviewTree.getRowCount(); ++i) {
                this.myOutputPreviewTree.expandRow(i);
            }
        });
    }

    @Override
    public void dispose() {
        this.myListeners.releaseAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSets";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/wizard/ConfirmGenerateIconsStep";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/wizard/ConfirmGenerateIconsStep";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        Tree tree;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Res Directory:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Output Directories:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myPathsComboBox = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myOutputPreviewTree = tree = new Tree();
        tree.setOpaque(false);
        tree.setToolTipText("A preview rendering of the output tree");
        jBScrollPane.setViewportView((Component)tree);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

