/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.IntArrayWrapper;
import com.android.resources.ResourceType;
import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.res.FileResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepositoryRootListener;
import com.android.tools.idea.res.RDotTxtParser;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.util.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppResourceRepository
extends MultiResourceRepository {
    private static final Logger LOG = Logger.getInstance(AppResourceRepository.class);
    private final AndroidFacet myFacet;
    private List<FileResourceRepository> myLibraries;
    private long myIdsModificationCount;
    private final LinkedList<FileResourceRepository> myAarLibraries;
    private Set<String> myIds;
    private ResourceVisibilityLookup myResourceVisibility;
    private ResourceVisibilityLookup.Provider myResourceVisibilityProvider;
    private static final int DYNAMIC_ID_SEED_START = 0x7FFF0000;
    private Map<ResourceType, TObjectIntHashMap<String>> myResourceValueMap;
    private TIntObjectHashMap<Pair<ResourceType, String>> myResIdValueToNameMap;
    private Map<IntArrayWrapper, String> myStyleableValueToNameMap;
    private final TObjectIntHashMap<TypedResourceName> myName2DynamicIdMap;
    private final TIntObjectHashMap<TypedResourceName> myDynamicId2ResourceMap;
    private int myDynamicSeed;
    private final IntArrayWrapper myWrapper;

    protected AppResourceRepository(@NotNull AndroidFacet facet, @NotNull List<? extends LocalResourceRepository> delegates, @NotNull List<FileResourceRepository> libraries) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(0);
        }
        if (delegates == null) {
            AppResourceRepository.$$$reportNull$$$0(1);
        }
        if (libraries == null) {
            AppResourceRepository.$$$reportNull$$$0(2);
        }
        super(facet.getModule().getName() + " with modules and libraries", delegates);
        this.myAarLibraries = Lists.newLinkedList();
        this.myName2DynamicIdMap = new TObjectIntHashMap();
        this.myDynamicId2ResourceMap = new TIntObjectHashMap();
        this.myDynamicSeed = 0x7FFF0000;
        this.myWrapper = new IntArrayWrapper(null);
        this.myFacet = facet;
        this.myLibraries = libraries;
        for (FileResourceRepository library : libraries) {
            if (library.getResourceTextFile() == null) continue;
            this.myAarLibraries.add(library);
        }
    }

    @Nullable
    public static AppResourceRepository getAppResources(@NotNull Module module, boolean createIfNecessary) {
        AndroidFacet facet;
        if (module == null) {
            AppResourceRepository.$$$reportNull$$$0(3);
        }
        if ((facet = AndroidFacet.getInstance(module)) != null) {
            return facet.getAppResources(createIfNecessary);
        }
        return null;
    }

    @Contract(value="!null, true -> !null")
    @Nullable
    public static AppResourceRepository getAppResources(@NotNull AndroidFacet facet, boolean createIfNecessary) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(4);
        }
        return facet.getAppResources(createIfNecessary);
    }

    @NotNull
    public static AppResourceRepository create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(5);
        }
        List<FileResourceRepository> libraries = AppResourceRepository.computeLibraries(facet);
        List<LocalResourceRepository> delegates = AppResourceRepository.computeRepositories(facet, libraries);
        AppResourceRepository repository = new AppResourceRepository(facet, delegates, libraries);
        ProjectResourceRepositoryRootListener.ensureSubscribed(facet.getModule().getProject());
        AppResourceRepository appResourceRepository = repository;
        if (appResourceRepository == null) {
            AppResourceRepository.$$$reportNull$$$0(6);
        }
        return appResourceRepository;
    }

    private static List<LocalResourceRepository> computeRepositories(@NotNull AndroidFacet facet, List<FileResourceRepository> libraries) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(7);
        }
        ArrayList repositories = Lists.newArrayListWithExpectedSize((int)10);
        ProjectResourceRepository resources = ProjectResourceRepository.getProjectResources(facet, true);
        repositories.addAll(libraries);
        repositories.add(resources);
        return repositories;
    }

    private static List<FileResourceRepository> computeLibraries(@NotNull AndroidFacet facet) {
        List<AndroidFacet> dependentFacets;
        Map<File, String> aarDirs;
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(8);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("computeLibraries");
        }
        if ((aarDirs = AppResourceRepository.findAarLibraries(facet, dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true))).isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  No AARs");
            }
            return Collections.emptyList();
        }
        ArrayList dirs = Lists.newArrayList(aarDirs.keySet());
        Collections.sort(dirs);
        if (LOG.isDebugEnabled()) {
            for (File root : dirs) {
                LOG.debug("  Dependency: " + LogAnonymizerUtil.anonymizeClassName(aarDirs.get(root)));
            }
        }
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)aarDirs.size());
        for (File root : dirs) {
            resources.add(FileResourceRepository.get(root, aarDirs.get(root)));
        }
        return resources;
    }

    @NotNull
    private static Map<File, String> findAarLibraries(@NotNull AndroidFacet facet, @NotNull List<AndroidFacet> dependentFacets) {
        AndroidModuleModel androidModuleModel;
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(9);
        }
        if (dependentFacets == null) {
            AppResourceRepository.$$$reportNull$$$0(10);
        }
        if ((androidModuleModel = AndroidModuleModel.get(facet)) != null) {
            ArrayList libraries = Lists.newArrayList();
            AppResourceRepository.addGradleLibraries(libraries, androidModuleModel);
            for (AndroidFacet dependentFacet : dependentFacets) {
                AndroidModuleModel dependentGradleModel = AndroidModuleModel.get(dependentFacet);
                if (dependentGradleModel == null) continue;
                AppResourceRepository.addGradleLibraries(libraries, dependentGradleModel);
            }
            Map<File, String> map = AppResourceRepository.findAarLibrariesFromGradle(androidModuleModel.getModelVersion(), dependentFacets, libraries);
            if (map == null) {
                AppResourceRepository.$$$reportNull$$$0(11);
            }
            return map;
        }
        Map<File, String> map = AppResourceRepository.findAarLibrariesFromIntelliJ(facet, dependentFacets);
        if (map == null) {
            AppResourceRepository.$$$reportNull$$$0(12);
        }
        return map;
    }

    @NotNull
    public static Collection<AndroidLibrary> findAarLibraries(@NotNull AndroidFacet facet) {
        AndroidModuleModel androidModel;
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(13);
        }
        ArrayList libraries = Lists.newArrayList();
        if (facet.requiresAndroidModel() && (androidModel = AndroidModuleModel.get(facet)) != null) {
            List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
            AppResourceRepository.addGradleLibraries(libraries, androidModel);
            for (AndroidFacet dependentFacet : dependentFacets) {
                AndroidModuleModel dependentGradleModel = AndroidModuleModel.get(dependentFacet);
                if (dependentGradleModel == null) continue;
                AppResourceRepository.addGradleLibraries(libraries, dependentGradleModel);
            }
        }
        ArrayList arrayList = libraries;
        if (arrayList == null) {
            AppResourceRepository.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private static Map<File, String> findAarLibrariesFromIntelliJ(AndroidFacet facet, List<AndroidFacet> dependentFacets) {
        HashMap<File, String> dirs = new HashMap<File, String>();
        ResourceFolderManager.addAarsFromModuleLibraries(facet, dirs);
        for (AndroidFacet f : dependentFacets) {
            ResourceFolderManager.addAarsFromModuleLibraries(f, dirs);
        }
        return dirs;
    }

    @NotNull
    private static Map<File, String> findAarLibrariesFromGradle(@NotNull GradleVersion modelVersion, List<AndroidFacet> dependentFacets, List<AndroidLibrary> libraries) {
        if (modelVersion == null) {
            AppResourceRepository.$$$reportNull$$$0(15);
        }
        HashMap<File, String> files = new HashMap<File, String>(libraries.size());
        HashSet moduleNames = Sets.newHashSet();
        for (AndroidFacet f : dependentFacets) {
            moduleNames.add(f.getModule().getName());
        }
        try {
            for (AndroidLibrary library : libraries) {
                File resFolder;
                String libraryName = null;
                String projectName = library.getProject();
                if (projectName != null && !projectName.isEmpty()) {
                    libraryName = projectName.substring(projectName.lastIndexOf(58) + 1);
                    moduleNames.add(libraryName);
                    continue;
                }
                File folder = library.getFolder();
                String name = folder.getName();
                if (modelVersion.getMajor() > 2 || modelVersion.getMajor() == 2 && modelVersion.getMinor() >= 2) {
                    libraryName = library.getName();
                } else if (name.endsWith(".aar")) {
                    libraryName = name.substring(0, name.length() - ".aar".length());
                } else if (folder.getPath().contains("exploded-aar")) {
                    libraryName = folder.getParentFile().getName();
                }
                if (libraryName == null || moduleNames.contains(libraryName) || !(resFolder = library.getResFolder()).exists()) continue;
                files.put(resFolder, libraryName);
                moduleNames.add(libraryName);
            }
        }
        catch (UnsupportedMethodException e) {
            LOG.warn("Incompatibility found between the IDE's builder-model and the cached Gradle model", (Throwable)e);
        }
        HashMap<File, String> hashMap = files;
        if (hashMap == null) {
            AppResourceRepository.$$$reportNull$$$0(16);
        }
        return hashMap;
    }

    private static void addGradleLibraries(List<AndroidLibrary> list, AndroidModuleModel androidModuleModel) {
        Collection libraries = androidModuleModel.getSelectedMainCompileDependencies().getLibraries();
        HashSet unique = Sets.newHashSet();
        for (AndroidLibrary library : libraries) {
            AppResourceRepository.addGradleLibrary(list, library, unique);
        }
    }

    private static void addGradleLibrary(List<AndroidLibrary> list, AndroidLibrary library, Set<File> unique) {
        File folder = library.getFolder();
        if (!unique.add(folder)) {
            return;
        }
        list.add(library);
        for (AndroidLibrary dependency : library.getLibraryDependencies()) {
            AppResourceRepository.addGradleLibrary(list, dependency, unique);
        }
    }

    @NotNull
    public List<FileResourceRepository> getLibraries() {
        List<FileResourceRepository> list = this.myLibraries;
        if (list == null) {
            AppResourceRepository.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    private Set<String> getAllIds() {
        long currentModCount = this.getModificationCount();
        if (this.myIdsModificationCount < currentModCount) {
            this.myIdsModificationCount = currentModCount;
            if (this.myIds == null) {
                int size = 0;
                for (FileResourceRepository library : this.myLibraries) {
                    if (library.getAllDeclaredIds() == null) continue;
                    size += library.getAllDeclaredIds().size();
                }
                this.myIds = Sets.newHashSetWithExpectedSize((int)size);
            } else {
                this.myIds.clear();
            }
            for (FileResourceRepository library : this.myLibraries) {
                if (library.getAllDeclaredIds() == null) continue;
                this.myIds.addAll(library.getAllDeclaredIds());
            }
            this.myIds.addAll(super.getItemsOfType(ResourceType.ID));
        }
        Set<String> set = this.myIds;
        if (set == null) {
            AppResourceRepository.$$$reportNull$$$0(18);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<String> getItemsOfType(@NotNull ResourceType type) {
        if (type == null) {
            AppResourceRepository.$$$reportNull$$$0(19);
        }
        Object object = ITEM_MAP_LOCK;
        // MONITORENTER : object
        Collection<String> collection = type == ResourceType.ID ? this.getAllIds() : super.getItemsOfType(type);
        // MONITOREXIT : object
        if (collection != null) return collection;
        AppResourceRepository.$$$reportNull$$$0(20);
        return collection;
    }

    void updateRoots() {
        List<FileResourceRepository> libraries = AppResourceRepository.computeLibraries(this.myFacet);
        List<LocalResourceRepository> repositories = AppResourceRepository.computeRepositories(this.myFacet, libraries);
        this.updateRoots(repositories, libraries);
    }

    void updateRoots(List<LocalResourceRepository> resources, List<FileResourceRepository> libraries) {
        this.myResourceVisibility = null;
        this.myResourceVisibilityProvider = null;
        this.invalidateResourceDirs();
        if (resources.equals(this.myChildren)) {
            return;
        }
        this.myResourceVisibility = null;
        this.myLibraries = libraries;
        this.myAarLibraries.clear();
        for (FileResourceRepository library : this.myLibraries) {
            if (library.getResourceTextFile() == null) continue;
            this.myAarLibraries.add(library);
        }
        this.setChildren(resources);
        this.resetDynamicIds(true);
        ModuleClassLoader.clearCache(this.myFacet.getModule());
    }

    @NotNull
    static AppResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull List<LocalResourceRepository> modules, @NotNull List<FileResourceRepository> libraries) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(21);
        }
        if (modules == null) {
            AppResourceRepository.$$$reportNull$$$0(22);
        }
        if (libraries == null) {
            AppResourceRepository.$$$reportNull$$$0(23);
        }
        assert (modules.containsAll(libraries));
        assert (modules.size() == libraries.size() + 1);
        AppResourceRepository appResourceRepository = new AppResourceRepository(facet, modules, libraries);
        if (appResourceRepository == null) {
            AppResourceRepository.$$$reportNull$$$0(24);
        }
        return appResourceRepository;
    }

    @Nullable
    public FileResourceRepository findRepositoryFor(@NotNull File aarDirectory) {
        if (aarDirectory == null) {
            AppResourceRepository.$$$reportNull$$$0(25);
        }
        String aarPath = aarDirectory.getPath();
        for (LocalResourceRepository localResourceRepository : this.myLibraries) {
            if (localResourceRepository instanceof FileResourceRepository) {
                FileResourceRepository repository = (FileResourceRepository)localResourceRepository;
                if (!repository.getResourceDirectory().getPath().startsWith(aarPath)) continue;
                return repository;
            }
            assert (false) : ((Object)((Object)localResourceRepository)).getClass();
        }
        int exploded = aarPath.indexOf("exploded-aar");
        if (exploded != -1) {
            String string = aarPath.substring(exploded) + File.separator + "res";
            for (LocalResourceRepository localResourceRepository : this.myLibraries) {
                if (localResourceRepository instanceof FileResourceRepository) {
                    FileResourceRepository repository = (FileResourceRepository)localResourceRepository;
                    String path = repository.getResourceDirectory().getPath();
                    if (!path.endsWith(string)) continue;
                    return repository;
                }
                assert (false) : ((Object)((Object)localResourceRepository)).getClass();
            }
        }
        return null;
    }

    @Nullable
    public ResourceVisibilityLookup.Provider getResourceVisibilityProvider() {
        if (this.myResourceVisibilityProvider == null) {
            if (!this.myFacet.requiresAndroidModel() || this.myFacet.getAndroidModel() == null) {
                return null;
            }
            this.myResourceVisibilityProvider = new ResourceVisibilityLookup.Provider();
        }
        return this.myResourceVisibilityProvider;
    }

    @NotNull
    public ResourceVisibilityLookup getResourceVisibility(@NotNull AndroidFacet facet) {
        ResourceVisibilityLookup.Provider provider;
        AndroidModuleModel androidModel;
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(26);
        }
        if ((androidModel = AndroidModuleModel.get(facet)) != null && (provider = this.getResourceVisibilityProvider()) != null) {
            AndroidProject androidProject = androidModel.getAndroidProject();
            Variant variant = androidModel.getSelectedVariant();
            ResourceVisibilityLookup resourceVisibilityLookup = provider.get(androidProject, variant);
            if (resourceVisibilityLookup == null) {
                AppResourceRepository.$$$reportNull$$$0(27);
            }
            return resourceVisibilityLookup;
        }
        ResourceVisibilityLookup resourceVisibilityLookup = ResourceVisibilityLookup.NONE;
        if (resourceVisibilityLookup == null) {
            AppResourceRepository.$$$reportNull$$$0(28);
        }
        return resourceVisibilityLookup;
    }

    public boolean isPrivate(@NotNull ResourceType type, @NotNull String name) {
        if (type == null) {
            AppResourceRepository.$$$reportNull$$$0(29);
        }
        if (name == null) {
            AppResourceRepository.$$$reportNull$$$0(30);
        }
        if (this.myResourceVisibility == null) {
            ResourceVisibilityLookup.Provider provider = this.getResourceVisibilityProvider();
            if (provider == null) {
                return false;
            }
            AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
            if (androidModel == null) {
                return false;
            }
            this.myResourceVisibility = provider.get(androidModel.getAndroidProject(), androidModel.getSelectedVariant());
        }
        return this.myResourceVisibility.isPrivate(type, name);
    }

    @Nullable
    public Pair<ResourceType, String> resolveResourceId(int id) {
        TypedResourceName pair;
        Pair<ResourceType, String> result = null;
        if (this.myResIdValueToNameMap != null) {
            result = (Pair<ResourceType, String>)this.myResIdValueToNameMap.get(id);
        }
        if (result == null && (pair = (TypedResourceName)this.myDynamicId2ResourceMap.get(id)) != null) {
            result = pair.toPair();
        }
        return result;
    }

    @Nullable
    public String resolveStyleable(int[] id) {
        if (this.myStyleableValueToNameMap != null) {
            this.myWrapper.set(id);
            return this.myStyleableValueToNameMap.get(this.myWrapper);
        }
        return null;
    }

    @NotNull
    public Integer getResourceId(ResourceType type, String name) {
        TObjectIntHashMap<String> map;
        TObjectIntHashMap<String> tObjectIntHashMap = map = this.myResourceValueMap != null ? this.myResourceValueMap.get(type) : null;
        if (map == null || !map.containsKey((Object)name)) {
            Integer n = this.getDynamicId(type, name);
            if (n == null) {
                AppResourceRepository.$$$reportNull$$$0(31);
            }
            return n;
        }
        Integer n = map.get((Object)name);
        if (n == null) {
            AppResourceRepository.$$$reportNull$$$0(32);
        }
        return n;
    }

    @Nullable
    Integer[] getDeclaredArrayValues(List<AttrResourceValue> attrs, String styleableName) {
        ListIterator iter = this.myAarLibraries.listIterator();
        while (iter.hasNext()) {
            Integer[] in;
            FileResourceRepository repo = (FileResourceRepository)((Object)iter.next());
            File resourceTextFile = repo.getResourceTextFile();
            if (resourceTextFile == null || (in = RDotTxtParser.getDeclareStyleableArray(resourceTextFile, attrs, styleableName)) == null) continue;
            iter.remove();
            this.myAarLibraries.addFirst(repo);
            return in;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDynamicId(ResourceType type, String name) {
        TypedResourceName key = new TypedResourceName(type, name);
        TObjectIntHashMap<TypedResourceName> tObjectIntHashMap = this.myName2DynamicIdMap;
        synchronized (tObjectIntHashMap) {
            if (this.myName2DynamicIdMap.containsKey((Object)key)) {
                return this.myName2DynamicIdMap.get((Object)key);
            }
            int value = ++this.myDynamicSeed;
            this.myName2DynamicIdMap.put((Object)key, value);
            this.myDynamicId2ResourceMap.put(value, (Object)key);
            return value;
        }
    }

    public void setCompiledResources(TIntObjectHashMap<Pair<ResourceType, String>> id2res, Map<IntArrayWrapper, String> styleableId2name, Map<ResourceType, TObjectIntHashMap<String>> res2id) {
        this.myResourceValueMap = res2id;
        this.myResIdValueToNameMap = id2res;
        this.myStyleableValueToNameMap = styleableId2name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDynamicIds(boolean clearResourceRegistry) {
        if (clearResourceRegistry) {
            ResourceClassRegistry.get(this.myFacet.getModule().getProject()).clearCache(this);
        }
        TObjectIntHashMap<TypedResourceName> tObjectIntHashMap = this.myName2DynamicIdMap;
        synchronized (tObjectIntHashMap) {
            this.myDynamicSeed = 0x7FFF0000;
            this.myName2DynamicIdMap.clear();
            this.myDynamicId2ResourceMap.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegates";
                break;
            }
            case 2: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/AppResourceRepository";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentFacets";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelVersion";
                break;
            }
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aarDirectory";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/AppResourceRepository";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findAarLibraries";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findAarLibrariesFromGradle";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllIds";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsOfType";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createForTest";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceVisibility";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAppResources";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeRepositories";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeLibraries";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findAarLibraries";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findAarLibrariesFromGradle";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getItemsOfType";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createForTest";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findRepositoryFor";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getResourceVisibility";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isPrivate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TypedResourceName {
        @Nullable
        final ResourceType myType;
        @NotNull
        final String myName;
        Pair<ResourceType, String> myPair;

        public TypedResourceName(@Nullable ResourceType type, @NotNull String name) {
            if (name == null) {
                TypedResourceName.$$$reportNull$$$0(0);
            }
            this.myType = type;
            this.myName = name;
        }

        public Pair<ResourceType, String> toPair() {
            if (this.myPair == null) {
                this.myPair = Pair.of((Object)this.myType, (Object)this.myName);
            }
            return this.myPair;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypedResourceName that = (TypedResourceName)o;
            if (this.myType != that.myType) {
                return false;
            }
            return this.myName.equals(that.myName);
        }

        public int hashCode() {
            int result = this.myType != null ? this.myType.hashCode() : 0;
            result = 31 * result + this.myName.hashCode();
            return result;
        }

        public String toString() {
            return String.format("Type=%1$s, value=%2$s", this.myType, this.myName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/res/AppResourceRepository$TypedResourceName", "<init>"));
        }
    }
}

